/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.action.TokenService;
import org.jivesoftware.openfire.plugin.util.WeaverStringUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitUsersThread
extends Thread {
    private static Logger Log = LoggerFactory.getLogger(InitUsersThread.class);
    private int userCount;
    private String UDID;

    public InitUsersThread(int userCount) {
        this.userCount = userCount;
        this.UDID = this.getUDID();
    }

    @Override
    public void run() {
        if (this.userCount < 500) {
            this.initUsersLess500();
        } else {
            int num = this.userCount / 500;
            if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                for (int i = 0; i <= num; ++i) {
                    this.initUserForOracle(i * 500 + 1, (i + 1) * 500);
                }
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                for (int i = 0; i <= num; ++i) {
                    this.initUserForMySQL(i * 500, 500);
                }
            } else {
                for (int i = 0; i <= num; ++i) {
                    this.initUserForSqlServer(i * 500, 500);
                }
            }
        }
        JiveGlobals.setProperty((String)"initUsers", (String)"true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUserForMySQL(int index, int num) {
        Log.info("now initUser index={},num={},db is mysql ", (Object)index, (Object)num);
        TokenService ts = new TokenService();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select id,lastname,messagerurl from hrmresource limit ?,?");
            pstmt.setInt(1, index);
            pstmt.setInt(2, num);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String nickname = rs.getString("lastname");
                String avatarUrl = rs.getString("messagerurl");
                id = id + "|" + this.UDID;
                ts.getToken(id, nickname, avatarUrl, false);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("initUserForMySQL,error:{}", (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUserForSqlServer(int index, int num) {
        Log.info("now initUser index={},num={},db is sqlserver", (Object)index, (Object)num);
        TokenService ts = new TokenService();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select top (?) id,lastname,messagerurl from HrmResource where id not in ( select top (?) id from HrmResource ) order by id ");
            pstmt.setInt(1, num);
            pstmt.setInt(2, index);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String nickname = rs.getString("lastname");
                String avatarUrl = rs.getString("messagerurl");
                id = id + "|" + this.UDID;
                ts.getToken(id, nickname, avatarUrl, false);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("initUserForSqlServer,error=" + e.toString());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUserForOracle(int index, int num) {
        Log.info("now initUser index = {}, num={},db is oracle", (Object)index, (Object)num);
        TokenService ts = new TokenService();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select t.* from (SELECT id,lastname,messagerurl,rownum rn FROM HrmResource order by id) t where rn between ? and ? ");
            pstmt.setInt(1, index);
            pstmt.setInt(2, num);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String nickname = rs.getString("lastname");
                String avatarUrl = rs.getString("messagerurl");
                id = id + "|" + this.UDID;
                Log.info("server plugin initUsers id =" + id);
                ts.getToken(id, nickname, avatarUrl, false);
            }
        }
        catch (Exception e) {
            try {
                Log.error("initUserForOracle,error=" + e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUsersLess500() {
        TokenService ts = new TokenService();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("SELECT id,lastname,messagerurl FROM HrmResource");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String nickname = rs.getString("lastname");
                String avatarUrl = rs.getString("messagerurl");
                id = id + "|" + this.UDID;
                Log.info("server plugin initUsers id =" + id);
                ts.getToken(id, nickname, avatarUrl, false);
            }
        }
        catch (Exception e) {
            try {
                Log.error("initUsersLess500,error={}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String getUDID() {
        block6: {
            block5: {
                con = null;
                pstmt = null;
                rs = null;
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select * from mobileProperty where name ='rongAppUDIDNew'");
                rs = pstmt.executeQuery();
                if (!rs.next()) ** GOTO lbl17
                propvalue = rs.getString("propvalue");
                if (propvalue == null) break block5;
                var5_7 = propvalue;
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                return var5_7;
            }
            try {
                break block6;
lbl17:
                // 1 sources

                DbConnectionManager.closeStatement((Statement)pstmt);
                UDID = WeaverStringUtil.getRandomLowercase(6);
                pstmt = con.prepareStatement("insert into mobileProperty (name,propValue) values (?,?)");
                pstmt.setString(1, "rongAppUDIDNew");
                pstmt.setString(2, UDID);
                pstmt.execute();
                var5_8 = UDID;
            }
            catch (Exception e) {
                try {
                    InitUsersThread.Log.error("getUDID,error:{}", (Object)e.getMessage());
                }
                catch (Throwable var6_9) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw var6_9;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return var5_8;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return "";
    }
}

