/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.util.ServerInfo;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.util.CloseMessage;
import org.jivesoftware.openfire.plugin.util.DBUtil;
import org.jivesoftware.openfire.plugin.util.PasswordUtil;
import org.jivesoftware.openfire.plugin.util.TokenCacheUtilMgr;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class KillUserOfflineUtil {
    private static final Logger Log = LoggerFactory.getLogger(KillUserOfflineUtil.class);

    public static void killUserOffline(String userId, String clientType) {
        Log.info("killUserOffline,userId:{},clientType:{}", (Object)userId, (Object)clientType);
        UserManager userManager = UserManager.getInstance();
        String username = userId + "|" + ServerInfo.SYSTEM_UDID;
        try {
            User user = userManager.getUser(username);
            if (clientType == null || clientType.isEmpty()) {
                KillUserOfflineUtil.killUser(username, "mobile");
                KillUserOfflineUtil.killUser(username, "pc");
                if (JiveGlobals.getBooleanProperty((String)"padlogin", (boolean)false)) {
                    KillUserOfflineUtil.killUser(username, "pad");
                }
            } else {
                KillUserOfflineUtil.killUser(username, clientType);
            }
            String token = PasswordUtil.genRandomNum(24);
            user.setPassword(token);
            TokenCacheUtilMgr.getInstance().remove(username);
            TokenCacheUtilMgr.getInstance().removeTimes(username);
        }
        catch (Exception e) {
            Log.error("killUserOffline,userId:{},clientType:{},error:{}", new Object[]{userId, clientType, e.getMessage()});
        }
    }

    private static void killUser(String username, String resource) {
        Log.info("killUser,username:{},resource:{}", (Object)username, (Object)resource);
        SessionManager sessionManager = SessionManager.getInstance();
        Message msg = new Message();
        msg.setFrom(XMPPServer.getInstance().getServerInfo().getXMPPDomain());
        msg.setID(StringUtils.randomString((int)8));
        msg.setType(Message.Type.chat);
        CloseMessage cm = new CloseMessage("");
        msg.setBody(cm.toString());
        JID jid = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), resource, true);
        ClientSession clientSession = sessionManager.getSession(jid);
        if (clientSession != null && clientSession.canFloodOfflineMessages()) {
            msg.setTo(clientSession.getAddress());
            clientSession.deliverRawText(msg.toString());
            clientSession.close();
        } else {
            ClusterRedisUtil clusterRedisUtil;
            String clusterNode;
            ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
            if (clusterPropBeanUtil.isUseCluster() && (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(jid)) != null && !clusterNode.isEmpty() && !clusterNode.equals(clusterPropBeanUtil.getClusterName())) {
                msg.setTo(jid);
                clusterRedisUtil.saveToRedis(clusterNode, msg);
            }
        }
        if ("mobile".equals(resource) || "pad".equals(resource)) {
            DBUtil.unregister(username, resource);
        }
    }
}

