/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.jivesoftware.openfire.plugin.util.HttpProxyForPush;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetDetectionUtil {
    public static final String WePushApiUrl = "https://pushserver.weaver.com.cn/api/im/push/send";
    public static final Logger Log = LoggerFactory.getLogger(NetDetectionUtil.class);
    public static boolean pushNetStatus = false;
    private static final X509TrustManager x = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    private static final TrustManager[] trustAllCerts = new TrustManager[]{x};
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static void NetDetectionUtilInit() {
        boolean weAppPush = false;
        int WePushApi = NetDetectionUtil.testUrl(WePushApiUrl);
        if (WePushApi != 500) {
            weAppPush = true;
        }
        if (pushNetStatus = weAppPush) {
            JiveGlobals.setProperty((String)"pushNetStatus", (String)String.valueOf(System.currentTimeMillis()));
        }
    }

    public static Map<String, String> pushNetDetectionUtil() {
        HashMap<String, String> map = new HashMap<String, String>();
        int weAppPush = NetDetectionUtil.testUrl(WePushApiUrl);
        if (weAppPush != 500) {
            map.put("weAppPush", "true");
        } else {
            map.put("weAppPush", "false");
        }
        return map;
    }

    public static void main(String[] args) {
        System.out.println("startTime:" + System.currentTimeMillis());
        System.out.println("endTine:" + System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int httpclientTest(String httpUrl) {
        int status = 500;
        HttpProxyForPush httpProxy = HttpProxyForPush.getInstance();
        boolean isUserProxy = httpProxy.isUserProxy();
        CloseableHttpClient httpClient = null;
        if (isUserProxy) {
            HttpHost proxy = new HttpHost(httpProxy.getProxyHost(), httpProxy.getProxyPort());
            if (httpProxy.isPropxyNeedAuth()) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxy.getHostName(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(httpProxy.getProxyUsername(), httpProxy.getProxyPassword()));
                httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy)).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            } else {
                httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy)).build();
            }
        } else {
            httpClient = HttpClients.custom().build();
        }
        HttpPost post = new HttpPost(httpUrl);
        post.setHeader("Content-Type", "application/json");
        CloseableHttpResponse response = null;
        try {
            try {
                response = httpClient.execute((HttpUriRequest)post);
                status = response.getStatusLine().getStatusCode();
            }
            catch (ClientProtocolException e) {
                status = 500;
            }
            catch (IOException e) {
                status = 500;
            }
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
        return status;
    }

    public static int testUrl(String url) {
        if (JiveGlobals.getBooleanProperty((String)"httpClientRequest", (boolean)false)) {
            return NetDetectionUtil.httpclientTest(url);
        }
        int status = 500;
        try {
            URL urlObj = new URL(url);
            HttpsURLConnection urlConnection = null;
            HttpProxyForPush httpProxyForPush = HttpProxyForPush.getInstance();
            boolean isUserProxy = httpProxyForPush.isUserProxy();
            if (isUserProxy) {
                InetSocketAddress addr = new InetSocketAddress(httpProxyForPush.getProxyHost(), httpProxyForPush.getProxyPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                urlConnection = (HttpsURLConnection)urlObj.openConnection(proxy);
                boolean isNeedAuth = httpProxyForPush.isPropxyNeedAuth();
                if (isNeedAuth) {
                    String encoded = new String(Base64.encodeBase64((byte[])(httpProxyForPush.getProxyUsername() + ":" + httpProxyForPush.getProxyPassword()).getBytes()));
                    urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                }
            } else {
                urlConnection = (HttpsURLConnection)urlObj.openConnection();
            }
            if (JiveGlobals.getBooleanProperty((String)"Skip.certificate.validation", (boolean)false)) {
                NetDetectionUtil.trustAllHosts(urlConnection);
                urlConnection.setHostnameVerifier(DO_NOT_VERIFY);
            }
            urlConnection.setUseCaches(false);
            urlConnection.setConnectTimeout(5000);
            status = urlConnection.getResponseCode();
        }
        catch (Exception e) {
            Log.error("NetDetectionUtil testUrl :{} ,error:{}", (Object)url, (Object)e.getMessage());
            status = 500;
        }
        return status;
    }

    private static SSLSocketFactory trustAllHosts(HttpsURLConnection connection) {
        SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return oldFactory;
    }
}

