/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.action.GroupService;
import org.jivesoftware.openfire.plugin.bean.RongGroup;
import org.jivesoftware.openfire.plugin.util.WeaverStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldGroupInitThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(OldGroupInitThread.class);
    private String UDID;
    private Integer oldGroupCount;
    private GroupService gs;

    public OldGroupInitThread(Integer oldGroupCount) {
        this.oldGroupCount = oldGroupCount;
        this.UDID = this.getUDID();
        this.gs = new GroupService();
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        if (this.oldGroupCount <= 500) {
            this.oldGroupInitLess500();
        } else {
            int num = this.oldGroupCount / 500;
            if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                for (int i = 0; i <= num; ++i) {
                    this.oldGroupInitForOracle(i * 500 + 1, (i + 1) * 500);
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        log.error("oldGroupInitForOracle,sleep,error={}", (Object)e.getMessage());
                        return;
                    }
                }
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                for (int i = 0; i <= num; ++i) {
                    this.oldGroupInitForMySQL(i * 500, 500);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    log.error("oldGroupInitForMySQL,sleep,error={}", (Object)e.getMessage());
                }
            } else {
                HashMap<String, Integer> idTemp = new HashMap<String, Integer>();
                idTemp.put("id", 0);
                for (int i = 0; i <= num; ++i) {
                    this.oldGroupInitForSqlServer(idTemp, 500);
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        log.error("oldGroupInitForSqlServer,sleep,error={}", (Object)e.getMessage());
                        return;
                    }
                }
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("done server plugin init old group, cost time:{}ms, group count:{}", (Object)(endTime - startTime), (Object)this.oldGroupCount);
    }

    private void oldGroupInitForMySQL(int index, int size) {
        List<RongGroup> groups = this.getOldGroupsForMySQL(index, size);
        if (groups != null) {
            for (RongGroup rg : groups) {
                this.gs.recreateGroup(rg.groupid, rg.groupname, rg.members, rg.adminuserid);
            }
        }
    }

    private void oldGroupInitForSqlServer(Map<String, Integer> idTemp, int size) {
        List<RongGroup> groups = this.getOldGroupsForSqlServer(idTemp, size);
        if (groups != null) {
            for (RongGroup rg : groups) {
                this.gs.recreateGroup(rg.groupid, rg.groupname, rg.members, rg.adminuserid);
            }
        }
    }

    private void oldGroupInitForOracle(int index, int size) {
        List<RongGroup> groups = this.getOldGroupsForOracle(index, size);
        if (groups != null) {
            for (RongGroup rg : groups) {
                this.gs.recreateGroup(rg.groupid, rg.groupname, rg.members, rg.adminuserid);
            }
        }
    }

    private void oldGroupInitLess500() {
        List<RongGroup> groups = this.getOldGroups();
        if (groups != null) {
            for (RongGroup rg : groups) {
                this.gs.recreateGroup(rg.groupid, rg.groupname, rg.members, rg.adminuserid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RongGroup> getOldGroupsForMySQL(int index, int size) {
        if (this.UDID == null || "".equals(this.UDID)) {
            log.error("getOldGroupsForMySQL error!udid is null ,do noting!index={},size={}", (Object)index, (Object)size);
            return null;
        }
        log.info("getOldGroupsForMySQL,index={},size={}", (Object)index, (Object)size);
        ArrayList<RongGroup> groups = new ArrayList<RongGroup>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select groupid,groupname,createuserid,members from social_allgroupinfos limit ?,?");
            pstmt.setInt(1, index);
            pstmt.setInt(2, size);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String adminuserid;
                RongGroup rg = new RongGroup();
                String groupid = rs.getString("groupid");
                String groupname = rs.getString("groupname");
                String createuserid = rs.getString("createuserid");
                String members = rs.getString("members");
                if (members == null || members.equals("")) continue;
                String[] memberlist = members.split(",");
                rg.groupid = groupid;
                rg.groupname = groupname;
                rg.adminuserid = adminuserid = createuserid + "|" + this.UDID;
                for (String mem : memberlist) {
                    String userid = mem + "|" + this.UDID;
                    rg.members.add(userid);
                }
                groups.add(rg);
            }
        }
        catch (SQLException e) {
            try {
                log.error("getOldGroupsForMySQL,index={},size={},error={}", new Object[]{index, size, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RongGroup> getOldGroupsForSqlServer(Map<String, Integer> idTemp, int size) {
        if (this.UDID == null || "".equals(this.UDID)) {
            log.error("getOldGroupsForSqlServer error! uuid is null, do nothing! index={},size={}", (Object)idTemp.get("id"), (Object)size);
            return null;
        }
        log.info("getOldGroupsForSqlServer,index={},size={}", (Object)idTemp.get("id"), (Object)size);
        ArrayList<RongGroup> groups = new ArrayList<RongGroup>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select top(?) id,groupid,groupname,createuserid,members from Social_AllGroupInfos  where id > ? ");
            pstmt.setInt(1, size);
            pstmt.setInt(2, idTemp.get("id"));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String adminuserid;
                RongGroup rg = new RongGroup();
                idTemp.put("id", rs.getInt("id"));
                String groupid = rs.getString("groupid");
                String groupname = rs.getString("groupname");
                String createuserid = rs.getString("createuserid");
                String members = rs.getString("members");
                if (members == null || members.equals("")) continue;
                String[] memberlist = members.split(",");
                rg.groupid = groupid;
                rg.groupname = groupname;
                rg.adminuserid = adminuserid = createuserid + "|" + this.UDID;
                for (String mem : memberlist) {
                    String userid = mem + "|" + this.UDID;
                    rg.members.add(userid);
                }
                groups.add(rg);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            log.error("getOldGroupsForSqlServer,index={},error={}", (Object)idTemp.get("id"), (Object)e.getMessage());
            List<RongGroup> list = null;
            return list;
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RongGroup> getOldGroupsForOracle(int index, int size) {
        if (this.UDID == null || "".equals(this.UDID)) {
            log.error("getOldGroupsForOracle error! uuid is null, do nothing! index={},size={}", (Object)index, (Object)size);
            return null;
        }
        log.info("getOldGroupsForOracle,index={},size={}", (Object)index, (Object)size);
        ArrayList<RongGroup> groups = new ArrayList<RongGroup>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select t.* from (SELECT groupid,groupname,createuserid,members,rownum rn FROM social_allgroupinfos order by groupid) t where rn between ? and ? ");
            pstmt.setInt(1, index);
            pstmt.setInt(2, size);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String adminuserid;
                RongGroup rg = new RongGroup();
                String groupid = rs.getString("groupid");
                String groupname = rs.getString("groupname");
                String createuserid = rs.getString("createuserid");
                String members = rs.getString("members");
                if (members == null || members.equals("")) continue;
                String[] memberlist = members.split(",");
                rg.groupid = groupid;
                rg.groupname = groupname;
                rg.adminuserid = adminuserid = createuserid + "|" + this.UDID;
                for (String mem : memberlist) {
                    String userid = mem + "|" + this.UDID;
                    rg.members.add(userid);
                }
                groups.add(rg);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            log.error("getOldGroupsForOracle error,index={},error={}", (Object)index, (Object)e.getMessage());
            List<RongGroup> list = null;
            return list;
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RongGroup> getOldGroups() {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<RongGroup> groups = new ArrayList<RongGroup>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select groupid,groupname,createuserid,members from social_allgroupinfos");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String adminuserid;
                RongGroup rg = new RongGroup();
                String groupid = rs.getString("groupid");
                String groupname = rs.getString("groupname");
                String createuserid = rs.getString("createuserid");
                String members = rs.getString("members");
                if (members == null || members.equals("")) continue;
                String[] memberlist = members.split(",");
                rg.groupid = groupid;
                rg.groupname = groupname;
                rg.adminuserid = adminuserid = createuserid + "|" + this.UDID;
                for (String mem : memberlist) {
                    String userid = mem + "|" + this.UDID;
                    rg.members.add(userid);
                }
                groups.add(rg);
            }
        }
        catch (Exception e) {
            List<RongGroup> list;
            try {
                log.error("getOldGroups error={}", (Object)e.toString());
                list = null;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return list;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String getUDID() {
        block6: {
            block5: {
                con = null;
                pstmt = null;
                rs = null;
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select * from mobileProperty where name ='rongAppUDIDNew'");
                rs = pstmt.executeQuery();
                if (!rs.next()) ** GOTO lbl17
                propvalue = rs.getString("propvalue");
                if (propvalue == null) break block5;
                var5_7 = propvalue.toLowerCase();
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                return var5_7;
            }
            try {
                break block6;
lbl17:
                // 1 sources

                DbConnectionManager.closeStatement((Statement)pstmt);
                UDID = WeaverStringUtil.getRandomLowercase(6);
                pstmt = con.prepareStatement("insert into mobileProperty (name,propValue) values (?,?)");
                pstmt.setString(1, "rongAppUDIDNew");
                pstmt.setString(2, UDID);
                pstmt.execute();
                var5_8 = UDID.toLowerCase();
            }
            catch (Exception e) {
                try {
                    OldGroupInitThread.log.error("getUDID error={}", (Object)e.getMessage());
                }
                catch (Throwable var6_9) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw var6_9;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return var5_8;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return "";
    }
}

