/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushKitFileUpload {
    private static final Logger Log = LoggerFactory.getLogger(PushKitFileUpload.class);

    public static int uploadPushKit(InputStream in, String filename) {
        if (in == null || filename == null || filename.length() < 1) {
            Log.error("Error installing plugin: Input stream was null or pluginFilename was null or had no length.");
            return 0;
        }
        try {
            int index = filename.lastIndexOf(File.separator);
            if (index != -1) {
                filename = filename.substring(index + 1);
            }
            if (!"voip.p12".equals(filename)) {
                Log.warn("uploadPushKit filename is not voip.p12.fileName:{}", (Object)filename);
                return 3;
            }
            File file = new File(JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + filename);
            if (file.exists()) {
                Log.warn("file is exist.now replace file .");
                file.delete();
            }
            File partfile = new File(JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + filename + ".part");
            Path absolutePath = file.toPath();
            Path partFile = partfile.toPath();
            Files.copy(in, partFile, StandardCopyOption.REPLACE_EXISTING);
            Files.move(partFile, absolutePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Log.error("Error installing new version of plugin: " + filename, (Throwable)e);
            return 2;
        }
        return 1;
    }
}

