/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.action.MessageService;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class SendFGroupMessageThread
implements Runnable {
    private static final Logger Log = LoggerFactory.getLogger(SendFGroupMessageThread.class);
    private String fromUserId;
    private String toGroupId;
    private String content;
    private String resource;
    private String XMPPDomain;

    public SendFGroupMessageThread(String fromUserId, String toGroupId, String content, String resource) {
        this.fromUserId = fromUserId;
        this.toGroupId = toGroupId;
        this.content = content;
        this.resource = resource;
        this.XMPPDomain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
    }

    @Override
    public void run() {
        String[] groupIds = this.toGroupId.split(",");
        for (int i = 0; i < groupIds.length; ++i) {
            String groupId = groupIds[i];
            String seContent = new String(this.content);
            Message message = this.getMessage(groupId, seContent);
            MessageService ms = new MessageService();
            ms.sendMessageToGroup(message);
            Log.info("SendFGroupMessageThread.success.message:{}", (Object)message.toString());
        }
    }

    private Message getMessage(String groupId, String content) {
        Log.info("getMessage groupId:{} ,content :{} ", (Object)groupId, (Object)content);
        ArrayList<String> userIds = new ArrayList<String>();
        try {
            GroupManager groupManager = GroupManager.getInstance();
            Group group = groupManager.getGroup(groupId);
            Collection groupMembers = group.getAll();
            for (JID jid : groupMembers) {
                String username = jid.getNode();
                userIds.add(this.getRealIdByUsername(username));
            }
        }
        catch (Exception e) {
            Log.error("getMessage ERROR :{} ", (Object)e.getMessage());
        }
        if (userIds.contains(this.getRealIdByUsername(this.fromUserId))) {
            userIds.remove(this.getRealIdByUsername(this.fromUserId));
        }
        String userids = "";
        for (String userid : userIds) {
            userids = userids + userid + ",";
        }
        if (userids.endsWith(",")) {
            userids = userids.substring(0, userids.length() - 1);
        }
        try {
            JSONObject json = JSONObject.parseObject((String)content);
            if (json != null && json.containsKey((Object)"extra")) {
                String extra = json.getString("extra");
                JSONObject extraJSON = JSONObject.parseObject((String)extra);
                if (extraJSON != null && !extraJSON.containsKey((Object)"receiverids")) {
                    if (extraJSON.containsKey((Object)"to_users")) {
                        String to_users = extraJSON.getString("to_users");
                        extraJSON.put("receiverids", (Object)to_users);
                    } else {
                        extraJSON.put("receiverids", (Object)userids);
                    }
                }
                if (extraJSON != null && !extraJSON.containsKey((Object)"msg_id")) {
                    extraJSON.put("msg_id", (Object)UUID.randomUUID().toString());
                }
                json.put("extra", (Object)extraJSON);
            }
            content = JSON.toJSONString((Object)json).toString();
        }
        catch (Exception e) {
            Log.error("getMessage json error :{} ", (Object)e.getMessage());
        }
        Log.info("getMessage groupId:{} ,content :{} ", (Object)groupId, (Object)content);
        Message message = new Message();
        message.setType(Message.Type.chat);
        if (this.resource == null || this.resource.isEmpty()) {
            message.setFrom(new JID(this.fromUserId, this.XMPPDomain, null, true));
        } else {
            message.setFrom(new JID(this.fromUserId, this.XMPPDomain, this.resource, true));
        }
        message.setTo(new JID(groupId, "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
        message.setBody(content);
        message.setID(StringUtils.randomString((int)8));
        return message;
    }

    private String getRealIdByUsername(String username) {
        if (username.startsWith("push|")) {
            return "-1";
        }
        int i = username.indexOf("|");
        if (i > 0) {
            return username.substring(0, i);
        }
        if (i == 0) {
            return "-1";
        }
        return username;
    }
}

