/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson2.JSONObject;
import java.util.List;
import java.util.UUID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.action.MessageService;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class SendPublishMessageThread
implements Runnable {
    private static final Logger Log = LoggerFactory.getLogger(SendPublishMessageThread.class);
    private List<String> tousers;
    private String content;
    private String fromUserId;
    private String XMPPDomain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
    private String resource;

    public SendPublishMessageThread(List<String> tousers, String content, String fromUserId, String resource) {
        this.tousers = tousers;
        this.content = content;
        this.fromUserId = fromUserId;
        this.resource = resource;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        Message message = this.getMessage();
        MessageService ms = new MessageService();
        if (this.tousers != null && this.tousers.size() > 0) {
            for (int i = 0; i < this.tousers.size(); ++i) {
                if (i != 0 && i % 200 == 0) {
                    Log.info("SendPublishMessageThread,sendMessageNumber is {} ,and now thread sleep,msgid={}", (Object)i, (Object)message.getID());
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Log.error("SendPublishMessageThread,sendMessageThread sleep msgid={}, error={},", (Object)message.getID(), (Object)e.getMessage());
                    }
                }
                message = this.isNumber(this.conNodeToID(this.fromUserId)) ? this.getMessage() : message.createCopy();
                String toUserId = this.tousers.get(i).toLowerCase();
                message.setTo(new JID(toUserId, this.XMPPDomain, null, true));
                Log.debug("SendPublishMessageThread,message:{}", (Object)message.toString());
                ms.sendMessage(message);
            }
        }
        long endTime = System.currentTimeMillis();
        Log.info("done SendPublishMessageThread,fromUserId = {},toUser={},msgid={},cost time={}ms", new Object[]{this.fromUserId, this.tousers, message.getID(), endTime - startTime});
    }

    private Message getMessage() {
        Message message = new Message();
        message.setType(Message.Type.chat);
        if (this.resource == null || this.resource.isEmpty()) {
            message.setFrom(new JID(this.fromUserId, this.XMPPDomain, null, true));
        } else {
            message.setFrom(new JID(this.fromUserId, this.XMPPDomain, this.resource, true));
        }
        String bodyStr = this.content;
        if (this.isNumber(this.conNodeToID(this.fromUserId))) {
            JSONObject json = JSONObject.parseObject((String)this.content);
            if (json != null && json.containsKey("extra")) {
                String extraStr = json.getString("extra");
                JSONObject extra = JSONObject.parseObject((String)extraStr);
                if (extra != null && extra.containsKey("msg_id")) {
                    extra.put((Object)"msg_id", (Object)UUID.randomUUID().toString());
                }
                json.put((Object)"extra", (Object)extra.toString());
            }
            bodyStr = json.toString();
        }
        message.setBody(bodyStr);
        message.setID(StringUtils.randomString((int)8));
        return message;
    }

    private String conNodeToID(String node) {
        if (node.startsWith("push|")) {
            return "-1";
        }
        int i = node.indexOf("|");
        if (i > 0) {
            return node.substring(0, i);
        }
        if (i == 0) {
            return "-1";
        }
        return node;
    }

    private boolean isNumber(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if ("admin".equals(str)) {
            return true;
        }
        boolean result = str.matches("[0-9]+");
        return result;
    }
}

