/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.util.cluster.ClusterPropBeanUtil;
import com.weaver.util.cluster.ClusterRedisUtil;
import java.util.List;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class SendPublishMessageToMobileOrPcThread
implements Runnable {
    private static final Logger Log = LoggerFactory.getLogger(SendPublishMessageToMobileOrPcThread.class);
    private List<String> tousers;
    private String content;
    private String fromUserId;
    private String XMPPDomain;
    private String resource;
    private String toResource;

    public SendPublishMessageToMobileOrPcThread(List<String> tousers, String content, String fromUserId, String resource, String toResource) {
        this.tousers = tousers;
        this.content = content;
        this.fromUserId = fromUserId;
        this.resource = resource;
        this.toResource = toResource;
        this.XMPPDomain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        Message message = this.getMessage();
        SessionManager sessionManager = SessionManager.getInstance();
        if (this.tousers != null && this.tousers.size() > 0) {
            for (int i = 0; i < this.tousers.size(); ++i) {
                ClusterRedisUtil clusterRedisUtil;
                String clusterNode;
                if (i != 0 && i % 200 == 0) {
                    Log.info("SendPublishMessageToMobileOrPcThread,sendMessageNumber is {} ,and now thread sleep,msgid={}", (Object)i, (Object)message.getID());
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Log.error("SendPublishMessageToMobileOrPcThread,sendMessageThread sleep msgid={}, error={},", (Object)message.getID(), (Object)e.getMessage());
                    }
                }
                message = message.createCopy();
                String toUserId = this.tousers.get(i).toLowerCase();
                JID toJID = new JID(toUserId, this.XMPPDomain, this.toResource, true);
                ClientSession clientSession = sessionManager.getSession(toJID);
                boolean hasRouted = false;
                if (clientSession != null) {
                    JID clientSessionAddress = clientSession.getAddress();
                    String clientSessionResource = clientSessionAddress.getResource();
                    if (toJID.getResource().equals(clientSessionResource)) {
                        message.setTo(toJID);
                    }
                    if (clientSession.canFloodOfflineMessages()) {
                        hasRouted = true;
                        clientSession.process((Packet)message);
                    }
                }
                ClusterPropBeanUtil clusterPropBeanUtil = ClusterPropBeanUtil.getInstance();
                if (hasRouted || !clusterPropBeanUtil.isUseCluster() || (clusterNode = (clusterRedisUtil = ClusterRedisUtil.getInstance()).getUserResourceNode(toJID)) == null || clusterNode.isEmpty()) continue;
                message.setTo(toJID);
                clusterRedisUtil.saveToRedis(clusterNode, message);
            }
        }
        long endTime = System.currentTimeMillis();
        Log.info("done SendPublishMessageToMobileOrPcThread,fromUserId = {},toUser={},msgid={},content:{},toResource:{},cost time={}ms", new Object[]{this.fromUserId, this.tousers, message.getID(), this.content, this.toResource, endTime - startTime});
    }

    private Message getMessage() {
        Message message = new Message();
        message.setType(Message.Type.chat);
        if (this.resource == null || this.resource.isEmpty()) {
            message.setFrom(new JID(this.fromUserId, this.XMPPDomain, null, true));
        } else {
            message.setFrom(new JID(this.fromUserId, this.XMPPDomain, this.resource, true));
        }
        message.setBody(this.content);
        message.setID(StringUtils.randomString((int)8));
        return message;
    }
}

