/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSONObject;
import com.weaver.server.util.UsernameUtil;
import com.weaver.util.ServerInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.plugin.action.MessageService;
import org.jivesoftware.openfire.plugin.bean.DingBean;
import org.jivesoftware.openfire.plugin.bean.DingReciver;
import org.jivesoftware.openfire.plugin.bean.DingReply;
import org.jivesoftware.openfire.plugin.util.DingDataBaseUtil;
import org.jivesoftware.openfire.plugin.util.UuidUtils;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class SendPushDingMessageThread
implements Runnable {
    private static final Logger Log = LoggerFactory.getLogger(SendPushDingMessageThread.class);
    private List<String> toUserids;
    private String fromUserId = ServerInfo.SYSTEM_UDID + "|ding";
    private String XMPPDomain;
    private DingBean dingBean;
    private DingDataBaseUtil dingDataBaseUtil;

    public SendPushDingMessageThread(List<String> toUserids, String content, String sendId, String messageId, int module, int hadSend, String sendTime, String isPrivate) {
        this.dingBean = new DingBean();
        this.dingDataBaseUtil = new DingDataBaseUtil();
        this.XMPPDomain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
        this.dingBean.setContent(content);
        this.dingBean.setSendid(sendId);
        this.dingBean.setMessageid(messageId);
        this.dingBean.setModule(module);
        this.dingBean.setHadSend(hadSend);
        this.dingBean.setOperateDate(sendTime);
        this.dingBean.setIsPrivate(isPrivate);
        this.toUserids = toUserids;
    }

    public SendPushDingMessageThread() {
        this.toUserids = new ArrayList<String>();
        this.dingBean = new DingBean();
        this.dingDataBaseUtil = new DingDataBaseUtil();
        this.XMPPDomain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
    }

    @Override
    public void run() {
        String sendUserId;
        long startTime = System.currentTimeMillis();
        Message message = this.getMessage();
        for (int i = 0; i < this.toUserids.size(); ++i) {
            this.toUserids.set(i, this.dingDataBaseUtil.getJIDNode(this.toUserids.get(i)));
        }
        if (this.dingBean.getSendid() != null && !this.toUserids.contains(sendUserId = this.dingDataBaseUtil.getJIDNode(this.dingBean.getSendid()))) {
            this.toUserids.add(sendUserId);
            Log.info("done SendPushDingMessageThread, contains sendid:{}", (Object)sendUserId);
        }
        MessageService ms = new MessageService();
        if (this.toUserids != null && this.toUserids.size() > 0) {
            for (int i = 0; i < this.toUserids.size(); ++i) {
                if (i != 0 && i % 200 == 0) {
                    Log.info("SendPushDingMessageThread,sendMessageNumber is {} ,and now thread sleep,msgid={}", (Object)i, (Object)message.getID());
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Log.error("SendPushDingMessageThread,sendMessageThread sleep msgid={}, error={},", (Object)message.getID(), (Object)e.getMessage());
                    }
                }
                message = message.createCopy();
                String toUserId = this.toUserids.get(i).toLowerCase();
                message.setTo(new JID(toUserId, this.XMPPDomain, null, true));
                ms.sendMessage(message);
            }
        }
        long endTime = System.currentTimeMillis();
        Log.info("done SendPushDingMessageThread,fromUserId = {},toUser={},msgid={},content:{},cost time={}ms", new Object[]{this.fromUserId, this.toUserids, message.getID(), this.dingBean.getContent(), endTime - startTime});
    }

    private Message getMessage() {
        Message message = new Message();
        JSONObject dingMessage = new JSONObject();
        JSONObject contentObject = new JSONObject();
        JSONObject paraObject = new JSONObject();
        contentObject.put("sound", (Object)"default");
        contentObject.put("alert", (Object)"\u76ef\u529e");
        contentObject.put("vibrate", (Object)"1");
        contentObject.put("badge", (Object)"1");
        String xmppid = StringUtils.randomString((int)8);
        UserManager userManager = UserManager.getInstance();
        try {
            User user = userManager.getUser(this.dingDataBaseUtil.getJIDNode(this.dingBean.getSendid()));
            this.dingBean.setDisplayedContent(UsernameUtil.getUserName(user.getUsername(), user.getName()) + ":" + this.dingBean.getContent());
        }
        catch (UserNotFoundException e) {
            Log.error("SendPushDingMessageThread.getMessage could not find user,err:{}", (Object)e.getMessage());
            this.dingBean.setDisplayedContent(this.dingBean.getContent());
        }
        if (this.toUserids != null && this.toUserids.size() > 0) {
            for (String i : this.toUserids) {
                String reciverId = this.dingDataBaseUtil.getRealUserId(i);
                this.dingDataBaseUtil.updateDingCon(this.dingBean.getSendid(), "bing_" + reciverId, "3", "\u5fc5\u8fbe", this.dingBean.getDisplayedContent(), xmppid, reciverId, true, "FW:CMDMsg", this.dingBean.getContent());
            }
        }
        this.dingDataBaseUtil.updateDingCon(this.dingBean.getSendid(), "bing_" + this.dingBean.getSendid(), "3", "\u5fc5\u8fbe", this.dingBean.getDisplayedContent(), xmppid, this.dingBean.getSendid(), false, "FW:CMDMsg", this.dingBean.getContent());
        paraObject.put("ding", (Object)this.dingBean);
        contentObject.put("para", (Object)paraObject);
        dingMessage.put("objectName", (Object)"FW:CMDMsg");
        dingMessage.put("content", (Object)contentObject.toJSONString());
        message.setType(Message.Type.chat);
        message.setBody(dingMessage.toJSONString());
        message.setFrom(new JID(this.fromUserId, this.XMPPDomain, null, true));
        message.setID(xmppid);
        if (!"".equals(this.dingBean.getMessageid())) {
            this.dingDataBaseUtil.updateDingClassName(this.dingBean.getMessageid(), contentObject.toJSONString());
        }
        return message;
    }

    public String saveDing() throws Exception {
        if (this.dingBean.getOperateDate().isEmpty()) {
            SimpleDateFormat SDF_ALL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.dingBean.setOperateDate(SDF_ALL.format(new Date()));
        }
        this.dingBean.setUdid(UuidUtils.uuid());
        this.dingBean.setScopeid("");
        this.dingBean.setReplyUpdate("false");
        this.dingBean.setConfirmUpdate("false");
        this.dingBean.setSendid(this.dingDataBaseUtil.getRealUserId(this.dingBean.getSendid()));
        this.dingBean.setDingReplys(new ArrayList<DingReply>());
        this.dingDataBaseUtil.saveMobileDing(this.dingBean, this.toUserids);
        return this.dingBean.getId();
    }

    public DingBean getDingBeanByDingid(int dingId) {
        this.dingBean = this.dingDataBaseUtil.getDingBeanByDingId(dingId);
        this.dingBean.setReplyUpdate("false");
        this.dingBean.setConfirmUpdate("false");
        for (DingReciver dingReciver : this.dingBean.getDingRecivers()) {
            this.toUserids.add(dingReciver.getUserid());
        }
        return this.dingBean;
    }

    public boolean updateDingBeanHadSend(int dingId, int hasSend) {
        this.dingBean.setHadSend(hasSend);
        return this.dingDataBaseUtil.updateDingBeanHadSend(dingId, hasSend) > -1;
    }

    public String getDingBeanId() {
        return this.dingBean.getId();
    }
}

