/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.action.TokenService;
import org.jivesoftware.openfire.plugin.servlet.UserServerServlet;
import org.jivesoftware.openfire.plugin.util.WeaverStringUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncUsersThread
extends Thread {
    private static Logger Log = LoggerFactory.getLogger(SyncUsersThread.class);
    private int userCount;
    private String UDID = this.getUDID();
    private UserManager userManager;
    private RedisPoolMgr redisPoolMgr;

    public SyncUsersThread() {
        this.userCount = this.getUserCount();
        this.userManager = UserManager.getInstance();
    }

    @Override
    public void run() {
        UserServerServlet.isSyncUser = true;
        if (this.userCount <= 500) {
            this.syncUsersLess500();
        } else {
            int num = this.userCount / 500;
            if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                for (int i = 0; i <= num; ++i) {
                    this.syncUserForOracle(i * 500 + 1, (i + 1) * 500);
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Log.error("syncUserForOracle,sleep,error={}", (Object)e.getMessage());
                        return;
                    }
                }
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                for (int i = 0; i <= num; ++i) {
                    this.syncUserForMySQL(i * 500, 500);
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Log.error("syncUserForMySQl,sleep,error={}", (Object)e.getMessage());
                        return;
                    }
                }
            } else {
                for (int i = 0; i <= num; ++i) {
                    this.syncUserForSqlServer(i * 500, 500);
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Log.error("syncUserForSqlServer,sleep,error={}", (Object)e.getMessage());
                        return;
                    }
                }
            }
        }
        Log.info("now start to kill Departing personnel from group .");
        this.killDepartingPersonnelFromGroup();
        UserServerServlet.isSyncUser = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killDepartingPersonnelFromGroup() {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.oracle) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) ? con.prepareStatement(" delete from ofgroupuser where username in ( SELECT a.id || '|" + this.UDID + "' from HRMRESOURCE a where a.status > 3 ) ") : (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.mysql) ? con.prepareStatement(" delete from ofgroupuser where username in ( SELECT concat( a.id ,'|" + this.UDID + "') from HRMRESOURCE a where a.status > 3 ) ") : con.prepareStatement(" delete from ofgroupuser where username in ( SELECT cast(a.id as varchar)+ '|" + this.UDID + "' from HRMRESOURCE a where a.status > 3 ) "));
            pstmt.execute();
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("killDepartingPersonnelFromGroup delete from DB error .e:{}", (Object)e.toString());
        }
        finally {
            DbConnectionManager.closeConnection(pstmt, (Connection)con);
        }
        try {
            SyncUsersThread syncUsersThread = this;
            RedisPoolMgr mgr = syncUsersThread.redisPoolMgr.getInstance();
            if (mgr != null) {
                Set desc = mgr.Keys("sgroup:desc:*");
                mgr.batchDel(desc);
                Set prop = mgr.Keys("sgroup:prop:*");
                mgr.batchDel(prop);
                Set admins = mgr.Keys("sgroup:admins:*");
                mgr.batchDel(admins);
                Set members = mgr.Keys("sgroup:members:*");
                mgr.batchDel(members);
            }
            Cache groupCache = CacheFactory.createCache((String)"Group");
            groupCache.clear();
        }
        catch (Exception e) {
            Log.error("killDepartingPersonnelFromGroup delete from cache error . e:{}", (Object)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUserForSqlServer(int index, int num) {
        Log.info("SyncUsersTimerTask now SyncUser index={},num={},db is sqlserver", (Object)index, (Object)num);
        TokenService ts = new TokenService();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select top (?) id,lastname,messagerurl from hrmresource a left join ofuser b on cast(a.id as varchar)+ '|" + this.UDID + "' = b.username where b.username is null or a.lastname != b.name and id not in ( select top (?) id from hrmresource a left join ofuser b on cast(a.id as varchar)+ '|" + this.UDID + "' = b.username where b.username is null or a.lastname != b.name ) order by id ");
            pstmt.setInt(1, num);
            pstmt.setInt(2, index);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String nickname = rs.getString("lastname");
                id = id + "|" + this.UDID;
                try {
                    User user = this.userManager.getUser(id);
                    user.setName(nickname);
                }
                catch (UserNotFoundException e) {
                    Log.info("syncUserForSqlServer user not found.now create user : {}", (Object)id);
                    String avatarUrl = rs.getString("messagerurl");
                    ts.getToken(id, nickname, avatarUrl, false);
                }
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("initUserForSqlServer,error=" + e.toString());
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUserForMySQL(int index, int num) {
        Log.info("SyncUsersTimerTask now SyncUser index={},num={},db is mysql ", (Object)index, (Object)num);
        TokenService ts = new TokenService();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select id,lastname,messagerurl from hrmresource a left join ofuser b on concat(a.id,'|" + this.UDID + "') = b.username where b.username is null or a.lastname != b.name order by id limit ?,?");
            pstmt.setInt(1, index);
            pstmt.setInt(2, num);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String nickname = rs.getString("lastname");
                id = id + "|" + this.UDID;
                try {
                    User user = this.userManager.getUser(id);
                    user.setName(nickname);
                }
                catch (UserNotFoundException e) {
                    Log.info("syncUserForMysql user not found.now create user : {} ", (Object)id);
                    String avatarUrl = rs.getString("messagerurl");
                    ts.getToken(id, nickname, avatarUrl, false);
                }
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("initUserForMySQL,error:{}", (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUserForOracle(int index, int num) {
        Log.info("SyncUsersTimerTask now SyncUsers index = {}, num={},db is oracle", (Object)index, (Object)num);
        TokenService ts = new TokenService();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select t.* from (SELECT id,lastname,messagerurl,rownum rn from hrmresource a left join ofuser b on a.id || '|" + this.UDID + "' = b.username where b.username is null or a.lastname != b.name order by id) t where rn between ? and ? ");
            pstmt.setInt(1, index);
            pstmt.setInt(2, num);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String nickname = rs.getString("lastname");
                id = id + "|" + this.UDID;
                try {
                    User user = this.userManager.getUser(id);
                    user.setName(nickname);
                }
                catch (UserNotFoundException e) {
                    Log.info("syncUserForOracle user not fount.now create user : {} ", (Object)id);
                    String avatarUrl = rs.getString("messagerurl");
                    ts.getToken(id, nickname, avatarUrl, false);
                }
            }
        }
        catch (SQLException e) {
            try {
                Log.error("initUserForOracle,error=" + e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUsersLess500() {
        TokenService ts = new TokenService();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.oracle) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) ? con.prepareStatement(" select id,lastname,messagerurl from hrmresource a left join ofuser b on a.id || '|" + this.UDID + "' = b.username where b.username is null or a.lastname != b.name ") : (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.mysql) ? con.prepareStatement(" select id,lastname,messagerurl from hrmresource a left join ofuser b on concat(a.id,'|" + this.UDID + "') = b.username where b.username is null or a.lastname != b.name ") : con.prepareStatement(" select id,lastname,messagerurl from hrmresource a left join ofuser b on cast(a.id as varchar)+ '|" + this.UDID + "' = b.username where b.username is null or a.lastname != b.name "));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String nickname = rs.getString("lastname");
                id = id + "|" + this.UDID;
                try {
                    User user = this.userManager.getUser(id);
                    user.setName(nickname);
                }
                catch (UserNotFoundException e) {
                    Log.info("syncUsersLess500 user not found.now create user : {} ", (Object)id);
                    String avatarUrl = rs.getString("messagerurl");
                    ts.getToken(id, nickname, avatarUrl, false);
                }
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("initUsersLess500,error={}", (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getUserCount() {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Integer userCount = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.oracle) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) ? con.prepareStatement(" select count(*) as userCount  from hrmresource a left join ofuser b on a.id || '|" + this.UDID + "' = b.username where b.username is null or a.lastname != b.name ") : (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.mysql) ? con.prepareStatement(" select count(*) as userCount from hrmresource a left join ofuser b on concat(a.id,'|" + this.UDID + "') = b.username where b.username is null or a.lastname != b.name ") : con.prepareStatement(" select count(*) as userCount from hrmresource a left join ofuser b on cast(a.id as varchar)+ '|" + this.UDID + "' = b.username where b.username is null or a.lastname != b.name "));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                userCount = Integer.parseInt(rs.getString("userCount"));
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("getUserCount,error={}", (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        }
        return userCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String getUDID() {
        block6: {
            block5: {
                con = null;
                pstmt = null;
                rs = null;
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select * from mobileProperty where name ='rongAppUDIDNew'");
                rs = pstmt.executeQuery();
                if (!rs.next()) ** GOTO lbl17
                propvalue = rs.getString("propvalue");
                if (propvalue == null) break block5;
                var5_7 = propvalue.toLowerCase();
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                return var5_7;
            }
            try {
                break block6;
lbl17:
                // 1 sources

                DbConnectionManager.closeStatement((Statement)pstmt);
                UDID = WeaverStringUtil.getRandomLowercase(6);
                pstmt = con.prepareStatement("insert into mobileProperty (name,propValue) values (?,?)");
                pstmt.setString(1, "rongAppUDIDNew");
                pstmt.setString(2, UDID);
                pstmt.execute();
                var5_8 = UDID.toLowerCase();
            }
            catch (Exception e) {
                try {
                    SyncUsersThread.Log.error("getUDID,error:{}", (Object)e.getMessage());
                }
                catch (Throwable var6_9) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw var6_9;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return var5_8;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return "";
    }
}

