/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.util.server2server.Server2ServerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.ConnectionException;
import org.jivesoftware.openfire.auth.InternalUnauthenticatedException;
import org.jivesoftware.openfire.plugin.util.PasswordUtil;
import org.jivesoftware.openfire.plugin.util.TokenCacheUtilMgr;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCacheUtil {
    private static final Logger Log = LoggerFactory.getLogger(TokenCacheUtil.class);
    private static final UserManager userManager = UserManager.getInstance();
    private static Map<String, String> tokensMap = new HashMap<String, String>();

    public static String getTokenObj(String username, String name, String url) {
        if (username == null || username.isEmpty()) {
            Log.warn("getToken username is null. name = {},url ={} ", (Object)name, (Object)url);
            return "";
        }
        username = username.toLowerCase();
        String token = null;
        try {
            token = TokenCacheUtilMgr.getInstance().get(username);
        }
        catch (Exception e) {
            Log.error("getToken from cache error : {} ", (Object)e.getMessage());
        }
        try {
            User user = userManager.getUser(username);
            if (token == null || token.isEmpty() || token.length() != 24 || !TokenCacheUtil.checkPassword(token)) {
                try {
                    token = PasswordUtil.genRandomNum(24);
                    AuthFactory.setPassword((String)username, (String)token);
                    TokenCacheUtilMgr.getInstance().put(username, token);
                }
                catch (Exception e) {
                    token = PasswordUtil.genRandomNum(24);
                    try {
                        AuthFactory.setPassword((String)username, (String)token);
                    }
                    catch (ConnectionException e1) {
                        Log.error("getTokenObj,ConnectionException,username={},error={}", (Object)username, (Object)e1.getMessage());
                    }
                    catch (InternalUnauthenticatedException e1) {
                        Log.error("getTokenObj,InternalUnauthenticatedException,username={},error={}", (Object)username, (Object)e1.getMessage());
                    }
                    TokenCacheUtilMgr.getInstance().put(username, token);
                }
            }
            if (url != null && !url.isEmpty() && !url.equals(user.getEmail())) {
                user.setEmail(url);
            }
            if (!user.getName().equals(name)) {
                user.setName(name);
            }
            if (user.isIsTurnover()) {
                user.setIsTurnover(false);
            }
        }
        catch (UnsupportedOperationException e) {
            Log.error("getTokenObj,UnsupportedOperationException,username={},error={}", (Object)username, (Object)e.getMessage());
        }
        catch (UserNotFoundException e) {
            Log.info("user not found,now create user and return token,username={}", (Object)username);
            token = PasswordUtil.genRandomNum(24);
            try {
                User user = userManager.createUser(username, token, name, url);
                TokenCacheUtilMgr.getInstance().put(username, token);
                token = AuthFactory.getPassword((String)username);
                AuthFactory.setPassword((String)username, (String)token);
                if (!Server2ServerUtil.isUserCurrent((String)username)) {
                    String serverUrl = Server2ServerUtil.getServerUrl((String)username);
                    if (serverUrl == null || serverUrl.isEmpty()) {
                        user.setIsExternal(false);
                    } else {
                        user.setIsExternal(true);
                        user.setServerUrl(serverUrl);
                    }
                } else {
                    user.setIsExternal(false);
                }
            }
            catch (Exception e1) {
                Log.error("getToken refresh user failed:name={},username={},error:{}", new Object[]{name, username, e1.getMessage()});
                return "";
            }
        }
        try {
            String passworkToken = AuthFactory.getPassword((String)username);
            if (!passworkToken.equals(token)) {
                AuthFactory.setPassword((String)username, (String)token);
            }
        }
        catch (Exception e) {
            Log.error("getToken ,error :{} ", (Object)e.getMessage());
        }
        return token;
    }

    public static void main(String[] args) {
        System.out.println(TokenCacheUtil.checkPassword("aaaaa2222aaaa333333a"));
    }

    private static boolean checkPassword(String password) {
        String reg = "[a-z0-9]+";
        return password.matches(reg);
    }
}

