/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.cache.redis.RedisPoolMgr;
import org.jivesoftware.openfire.plugin.util.TokenCacheUtil;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.jivesoftware.util.cache.DefaultCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCacheUtilMgr {
    private static final Logger Log = LoggerFactory.getLogger(TokenCacheUtil.class);
    private RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
    private Cache<String, String> tokenCache = null;
    private Cache<String, Integer> tokenCacheTimes = null;
    private static final String tokenCacheName = "Token Cache";
    private static final String redisCacheKey = "user_token_";
    private static final String redisCacheTimesKey = "user_token_times_";
    private static final String tokenCacheTimesName = "Token Cache Times";
    private static TokenCacheUtilMgr instance = null;

    private TokenCacheUtilMgr() {
        if (this.redisPoolMgr == null) {
            this.tokenCache = CacheFactory.createCache((String)tokenCacheName);
            this.tokenCacheTimes = CacheFactory.createCache((String)tokenCacheTimesName);
            if (this.tokenCacheTimes instanceof DefaultCache) {
                this.tokenCacheTimes.setMaxLifetime(60000L);
            } else {
                JiveGlobals.setProperty((String)"cache.TokenCacheTimes.maxLifetime", (String)Long.toString(60000L));
            }
            Log.info("redis server not install. now token cache name is : {}", (Object)"Token CacheToken Cache Times");
        }
    }

    public static TokenCacheUtilMgr getInstance() {
        if (instance == null) {
            instance = new TokenCacheUtilMgr();
        }
        return instance;
    }

    public void put(String username, String token) {
        try {
            if (this.redisPoolMgr != null) {
                String key = redisCacheKey + username;
                this.redisPoolMgr.set(key, token, 259200);
            } else {
                this.tokenCache.put((Object)username, (Object)token);
            }
        }
        catch (Exception e) {
            Log.error("put token to cache or redis error.username:{},token:{},error:{}", new Object[]{username, token, e.getMessage()});
        }
    }

    public void remove(String username) {
        try {
            if (this.redisPoolMgr != null) {
                String key = redisCacheKey + username;
                this.redisPoolMgr.del(key);
            } else {
                this.tokenCache.remove((Object)username);
            }
        }
        catch (Exception e) {
            Log.error("remove token from cache or redis error.username:{},error:{}", (Object)username, (Object)e.getMessage());
        }
    }

    public String get(String username) {
        String token = null;
        try {
            if (this.redisPoolMgr != null) {
                String key = redisCacheKey + username;
                token = this.redisPoolMgr.get(key);
            } else {
                token = (String)this.tokenCache.get((Object)username);
            }
        }
        catch (Exception e) {
            Log.error("get token from cache or redis error.username :{},error:{}", (Object)username, (Object)e.getMessage());
        }
        return token;
    }

    public void removeTimes(String username) {
        try {
            if (this.redisPoolMgr != null) {
                String key = redisCacheTimesKey + username;
                this.redisPoolMgr.del(key);
            } else {
                this.tokenCacheTimes.remove((Object)username);
            }
        }
        catch (Exception e) {
            Log.error("TokenCacheUtil.removeTimes.error.username:{},error:{}", (Object)username, (Object)e.getMessage());
        }
    }

    public void putTimes(String username) {
        int times = this.getTimes(username);
        int newTimes = times + 1;
        try {
            if (this.redisPoolMgr != null) {
                String key = redisCacheTimesKey + username;
                this.redisPoolMgr.setex(key, String.valueOf(newTimes), 60);
            } else {
                this.tokenCacheTimes.put((Object)username, (Object)newTimes);
            }
        }
        catch (Exception e) {
            Log.error("TokenCacheUtilMgr .putTimes error :{} ,username :{}", (Object)e.getMessage(), (Object)username);
        }
    }

    public int getTimes(String username) {
        int times = 0;
        try {
            if (this.redisPoolMgr != null) {
                String key = redisCacheTimesKey + username;
                String timesStr = this.redisPoolMgr.get(key);
                if (timesStr != null && !timesStr.isEmpty()) {
                    times = Integer.parseInt(timesStr);
                }
            } else {
                times = (Integer)this.tokenCacheTimes.get((Object)username);
            }
        }
        catch (Exception e) {
            Log.error("TokenCacheUtilMgr . getTimes error .username :{} ,error:{} ", (Object)username, (Object)e.getMessage());
        }
        return times;
    }
}

