/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl.entity;

import ytx.org.apache.http.HttpException;
import ytx.org.apache.http.HttpMessage;
import ytx.org.apache.http.ProtocolException;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.entity.ContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

