/*
 * Decompiled with CFR 0.152.
 */
package bingo.jpush.base;

import bingo.jpush.model.PushMessage;
import bingo.jpush.model.PushResult;
import bingo.jpush.model.ResultModel;
import bingo.jpush.model.SignatureHeader;
import bingo.jpush.model.UserLabel;
import bingo.jpush.utils.SignUtil;
import bingo.jpush.utils.httpclientutil.HttpClientUtil;
import bingo.jpush.utils.httpclientutil.common.HttpConfig;
import bingo.jpush.utils.httpclientutil.common.HttpHeader;
import bingo.jpush.utils.httpclientutil.exception.HttpProcessException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSendService {
    static final Logger logger = LoggerFactory.getLogger(ClientSendService.class);

    public ResultModel sendNotice(PushMessage pushMessage) throws HttpProcessException {
        String[] cidList;
        String[] labelList;
        logger.info("sendNotice \u5f00\u59cb pushMessage=" + pushMessage.toString());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", pushMessage.getJpushAppId());
        params.put("msgType", pushMessage.getMsgType());
        if (StringUtils.isNotEmpty((CharSequence)pushMessage.getTitle())) {
            params.put("title", pushMessage.getTitle());
        }
        if (StringUtils.isNotEmpty((CharSequence)pushMessage.getText())) {
            params.put("text", pushMessage.getText());
        }
        params.put("id", pushMessage.getId());
        params.put("logoUrl", pushMessage.getLogoUrl());
        params.put("pushType", pushMessage.getPushType());
        if (1 == pushMessage.getPushType()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
            params.put("timingPushDateFmt", sdf.format(pushMessage.getTimingPushDate()));
        }
        params.put("linkUrl", pushMessage.getLinkUrl());
        params.put("notifyAction", pushMessage.getNotifyAction());
        params.put("isRing", pushMessage.getIsRing() + "");
        params.put("isFloat", pushMessage.getIsFloat() + "");
        params.put("isVibrate", pushMessage.getIsVibrate() + "");
        params.put("isClearable", pushMessage.getIsClearable() + "");
        params.put("transmissionContent", pushMessage.getTransmissionContent());
        params.put("targetUserType", pushMessage.getTargetUserType() + "");
        String[] userList = pushMessage.getUserList();
        if (userList != null && userList.length > 0) {
            params.put("userListJson", JSON.toJSONString((Object)userList));
        }
        if ((labelList = pushMessage.getLabelList()) != null && labelList.length > 0) {
            params.put("labelListJson", JSON.toJSONString((Object)labelList));
        }
        if ((cidList = pushMessage.getCidList()) != null && cidList.length > 0) {
            params.put("cidListJson", JSON.toJSONString((Object)cidList));
        }
        String signStr = StringUtils.isNotEmpty((CharSequence)pushMessage.getSign()) ? pushMessage.getSign() : SignUtil.sign(pushMessage.getJpushMasterSecret(), "", params, null);
        SignatureHeader signatureHeader = new SignatureHeader();
        signatureHeader.setAppKey(pushMessage.getJpushAppKey());
        signatureHeader.setClientType("1");
        signatureHeader.setNonceStr(pushMessage.getJpushNonceStr());
        signatureHeader.setTimestamp(new Date().getTime());
        signatureHeader.setSign(signStr);
        signatureHeader.setAppId(pushMessage.getJpushAppId());
        HttpConfig config = HttpConfig.custom();
        Header[] headers = HttpHeader.custom().other("jpush", JSON.toJSONString((Object)signatureHeader)).build();
        config.headers(headers);
        config.map(params);
        config.encoding("utf-8");
        config.outenc("utf-8");
        config.inenc("utf-8");
        String result = HttpClientUtil.post(config.url(pushMessage.getJpushUrl() + "/push/sendNotice"));
        logger.info("result=" + result);
        ResultModel resultModel = (ResultModel)JSONObject.parseObject((String)result, ResultModel.class);
        logger.info("sendNotice \u7ed3\u675f resultModel=" + resultModel.toString());
        return resultModel;
    }

    public ResultModel getPushCount(PushResult pushResult) throws HttpProcessException {
        logger.info("getPushCount \u5f00\u59cb pushResult=" + pushResult.toString());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", pushResult.getJpushAppId());
        params.put("pushId", pushResult.getPushId());
        String signStr = StringUtils.isNotEmpty((CharSequence)pushResult.getSign()) ? pushResult.getSign() : SignUtil.sign(pushResult.getJpushMasterSecret(), "", params, null);
        HashMap<String, String> propertys = new HashMap<String, String>();
        SignatureHeader signatureHeader = new SignatureHeader();
        signatureHeader.setAppKey(pushResult.getJpushAppKey());
        signatureHeader.setClientType("1");
        signatureHeader.setNonceStr(pushResult.getJpushNonceStr());
        signatureHeader.setTimestamp(new Date().getTime());
        signatureHeader.setSign(signStr);
        propertys.put("jpush", JSON.toJSONString((Object)signatureHeader));
        HttpConfig config = HttpConfig.custom();
        Header[] headers = HttpHeader.custom().other("jpush", JSON.toJSONString((Object)signatureHeader)).build();
        config.headers(headers);
        config.map(params);
        config.encoding("utf-8");
        config.outenc("utf-8");
        config.inenc("utf-8");
        String result = HttpClientUtil.post(config.url(pushResult.getJpushUrl() + "/pushCount/getPushCount"));
        ResultModel resultModel = (ResultModel)JSONObject.parseObject((String)result, ResultModel.class);
        logger.info("getPushCount \u7ed3\u675f resultModel=" + resultModel.toString());
        return resultModel;
    }

    public ResultModel userLabel(UserLabel userLabel) throws HttpProcessException {
        logger.info("userLabel \u5f00\u59cb userLabel=" + userLabel.toString());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", userLabel.getJpushAppId());
        params.put("labelName", userLabel.getLabelName());
        params.put("userId", userLabel.getUserId());
        String signStr = StringUtils.isNotEmpty((CharSequence)userLabel.getSign()) ? userLabel.getSign() : SignUtil.sign(userLabel.getJpushMasterSecret(), "", params, null);
        HashMap<String, String> header = new HashMap<String, String>();
        SignatureHeader signatureHeader = new SignatureHeader();
        signatureHeader.setAppKey(userLabel.getJpushAppKey());
        signatureHeader.setClientType("1");
        signatureHeader.setNonceStr(userLabel.getJpushNonceStr());
        signatureHeader.setTimestamp(new Date().getTime());
        signatureHeader.setSign(signStr);
        header.put("jpush", JSON.toJSONString((Object)signatureHeader));
        HttpConfig config = HttpConfig.custom();
        Header[] headers = HttpHeader.custom().other("jpush", JSON.toJSONString((Object)signatureHeader)).build();
        config.headers(headers);
        config.map(params);
        config.encoding("utf-8");
        config.outenc("utf-8");
        config.inenc("utf-8");
        String result = "";
        if (userLabel.getBusType() == 1) {
            result = HttpClientUtil.post(config.url(userLabel.getJpushUrl() + "/message/userLabel/bindUserLabel"));
        } else if (userLabel.getBusType() == 2) {
            result = HttpClientUtil.post(config.url(userLabel.getJpushUrl() + "/message/userLabel/unBindUserLabel"));
        }
        logger.info("result=" + result);
        ResultModel resultModel = (ResultModel)JSONObject.parseObject((String)result, ResultModel.class);
        logger.info("userLabel \u7ed3\u675f resultModel=" + resultModel.toString());
        return resultModel;
    }

    public ResultModel addApp(String jpushUrl, String appKey, String appSecret, String nonceStr, String masterSecret) throws HttpProcessException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String body = "{\n  \"androidPackageName\": \"string\",\n  \"appKey\": \"" + appKey + "\",\n  \"appLogo\": \"string\",\n  \"appSecret\": \"" + appSecret + "\",\n  \"id\": \"string\",\n  \"iosCertificate\": \"string\",\n  \"iosCertificateSecret\": \"string\",\n  \"masterSecret\": \"" + masterSecret + "\",\n  \"name\": \"jpush\u6d4b\u8bd5\",\n  \"status\": \"1\",\n  \"typeId\": \"5cac55a076d1a42a88997f6b\",\n  \"typePlatform\": \"0\"\n}";
        params.put("$ENTITY_JSON$", body);
        String signStr = SignUtil.sign(masterSecret, body, params, null);
        HashMap<String, String> propertys = new HashMap<String, String>();
        SignatureHeader signatureHeader = new SignatureHeader();
        signatureHeader.setAppKey(appKey);
        signatureHeader.setClientType("1");
        signatureHeader.setNonceStr(nonceStr);
        signatureHeader.setTimestamp(new Date().getTime());
        signatureHeader.setSign(signStr);
        propertys.put("jpush", JSON.toJSONString((Object)signatureHeader));
        HttpConfig config = HttpConfig.custom();
        Header[] headers = HttpHeader.custom().other("jpush", JSON.toJSONString((Object)signatureHeader)).build();
        config.headers(headers);
        config.map(params);
        String result = HttpClientUtil.post(config.url(jpushUrl));
        return (ResultModel)JSONObject.parseObject((String)result, ResultModel.class);
    }
}

