/*
 * Decompiled with CFR 0.152.
 */
package bingo.jpush.utils;

import bingo.jpush.utils.HMAC;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static Logger log = LoggerFactory.getLogger(SignUtil.class);

    public static String sign(String secret, String body, Map<String, Object> params, String[] paths) {
        log.info("\u3010SignUtil:sign\u3011\u8c03\u7528,secret:[{}],body:[{}],params:[{}],paths:[{}] ", new Object[]{secret, body, params, paths});
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            sb.append(body).append('#');
        }
        if (params != null && params.size() > 0) {
            params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(paramEntry -> {
                if (paramEntry.getValue() instanceof Object[]) {
                    String paramValue = String.join((CharSequence)",", (CharSequence[])Arrays.stream((Object[])paramEntry.getValue()).sorted().toArray(String[]::new));
                    sb.append((String)paramEntry.getKey()).append("=").append(paramValue).append('#');
                } else {
                    sb.append((String)paramEntry.getKey()).append("=").append(paramEntry.getValue()).append('#');
                }
            });
        }
        if (ArrayUtils.isNotEmpty((Object[])paths)) {
            String pathValues = String.join((CharSequence)",", (CharSequence[])Arrays.stream(paths).sorted().toArray(String[]::new));
            sb.append(pathValues);
        }
        log.info("\u3010SignUtil:sign\u3011\u8c03\u7528,\u7b7e\u540d\u5b57\u7b26\u4e32\u4e3a:" + sb);
        String createSign = "";
        try {
            createSign = HMAC.hmacSha1Encrypt(sb.toString(), secret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return createSign;
    }

    public static void main(String[] args) {
        try {
            String by = HMAC.hmacSha1Encrypt("caoke", "mw");
            System.out.println("by ============" + by);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

