/*
 * Decompiled with CFR 0.152.
 */
package bingo.jpush.utils.httpclientutil;

import bingo.jpush.utils.httpclientutil.builder.HCB;
import bingo.jpush.utils.httpclientutil.common.HttpConfig;
import bingo.jpush.utils.httpclientutil.common.HttpMethods;
import bingo.jpush.utils.httpclientutil.common.HttpResult;
import bingo.jpush.utils.httpclientutil.common.Utils;
import bingo.jpush.utils.httpclientutil.exception.HttpProcessException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static HttpClient client4HTTP;
    private static HttpClient client4HTTPS;

    private static void create(HttpConfig config) throws HttpProcessException {
        if (config.client() == null) {
            if (config.url().toLowerCase().startsWith("https://")) {
                config.client(client4HTTPS);
            } else {
                config.client(client4HTTP);
            }
        }
    }

    public static String get(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) throws HttpProcessException {
        return HttpClientUtil.get(HttpConfig.custom().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public static String get(HttpConfig config) throws HttpProcessException {
        return HttpClientUtil.send(config.method(HttpMethods.GET));
    }

    public static String post(HttpClient client, String url, Header[] headers, Map<String, Object> parasMap, HttpContext context, String encoding) throws HttpProcessException {
        return HttpClientUtil.post(HttpConfig.custom().client(client).url(url).headers(headers).map(parasMap).context(context).encoding(encoding));
    }

    public static String post(HttpConfig config) throws HttpProcessException {
        return HttpClientUtil.send(config.method(HttpMethods.POST));
    }

    public static String put(HttpClient client, String url, Map<String, Object> parasMap, Header[] headers, HttpContext context, String encoding) throws HttpProcessException {
        return HttpClientUtil.put(HttpConfig.custom().client(client).url(url).headers(headers).map(parasMap).context(context).encoding(encoding));
    }

    public static String put(HttpConfig config) throws HttpProcessException {
        return HttpClientUtil.send(config.method(HttpMethods.PUT));
    }

    public static String delete(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) throws HttpProcessException {
        return HttpClientUtil.delete(HttpConfig.custom().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public static String delete(HttpConfig config) throws HttpProcessException {
        return HttpClientUtil.send(config.method(HttpMethods.DELETE));
    }

    public static String patch(HttpClient client, String url, Map<String, Object> parasMap, Header[] headers, HttpContext context, String encoding) throws HttpProcessException {
        return HttpClientUtil.patch(HttpConfig.custom().client(client).url(url).headers(headers).map(parasMap).context(context).encoding(encoding));
    }

    public static String patch(HttpConfig config) throws HttpProcessException {
        return HttpClientUtil.send(config.method(HttpMethods.PATCH));
    }

    public static String head(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) throws HttpProcessException {
        return HttpClientUtil.head(HttpConfig.custom().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public static String head(HttpConfig config) throws HttpProcessException {
        return HttpClientUtil.send(config.method(HttpMethods.HEAD));
    }

    public static String options(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) throws HttpProcessException {
        return HttpClientUtil.options(HttpConfig.custom().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public static String options(HttpConfig config) throws HttpProcessException {
        return HttpClientUtil.send(config.method(HttpMethods.OPTIONS));
    }

    public static String trace(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) throws HttpProcessException {
        return HttpClientUtil.trace(HttpConfig.custom().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public static String trace(HttpConfig config) throws HttpProcessException {
        return HttpClientUtil.send(config.method(HttpMethods.TRACE));
    }

    public static OutputStream down(HttpClient client, String url, Header[] headers, HttpContext context, OutputStream out) throws HttpProcessException {
        return HttpClientUtil.down(HttpConfig.custom().client(client).url(url).headers(headers).context(context).out(out));
    }

    public static OutputStream down(HttpConfig config) throws HttpProcessException {
        if (config.method() == null) {
            config.method(HttpMethods.GET);
        }
        return HttpClientUtil.fmt2Stream(HttpClientUtil.execute(config), config.out());
    }

    public static String upload(HttpClient client, String url, Header[] headers, HttpContext context) throws HttpProcessException {
        return HttpClientUtil.upload(HttpConfig.custom().client(client).url(url).headers(headers).context(context));
    }

    public static String upload(HttpConfig config) throws HttpProcessException {
        if (config.method() != HttpMethods.POST && config.method() != HttpMethods.PUT) {
            config.method(HttpMethods.POST);
        }
        return HttpClientUtil.send(config);
    }

    public static int status(HttpClient client, String url, Header[] headers, HttpContext context, HttpMethods method) throws HttpProcessException {
        return HttpClientUtil.status(HttpConfig.custom().client(client).url(url).headers(headers).context(context).method(method));
    }

    public static int status(HttpConfig config) throws HttpProcessException {
        return HttpClientUtil.fmt2Int(HttpClientUtil.execute(config));
    }

    public static String send(HttpConfig config) throws HttpProcessException {
        return HttpClientUtil.fmt2String(HttpClientUtil.execute(config), config.outenc());
    }

    public static HttpResult sendAndGetResp(HttpConfig config) throws HttpProcessException {
        Header[] reqHeaders = config.headers();
        HttpResponse resp = HttpClientUtil.execute(config);
        HttpResult result = new HttpResult(resp);
        result.setResult(HttpClientUtil.fmt2String(resp, config.outenc()));
        result.setReqHeaders(reqHeaders);
        return result;
    }

    private static HttpResponse execute(HttpConfig config) throws HttpProcessException {
        HttpClientUtil.create(config);
        HttpResponse resp = null;
        try {
            HttpRequestBase request = HttpClientUtil.getRequest(config.url(), config.method());
            request.setConfig(config.requestConfig());
            request.setHeaders(config.headers());
            if (HttpEntityEnclosingRequestBase.class.isAssignableFrom(request.getClass())) {
                ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
                if (request.getClass() == HttpGet.class) {
                    config.url(Utils.checkHasParas(config.url(), nvps, config.inenc()));
                }
                HttpEntity entity = Utils.map2HttpEntity(nvps, config.map(), config.inenc());
                ((HttpEntityEnclosingRequestBase)request).setEntity(entity);
                Utils.info("\u8bf7\u6c42\u5730\u5740\uff1a" + config.url());
                if (nvps.size() > 0) {
                    Utils.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + ((Object)nvps).toString());
                }
                if (config.json() != null) {
                    Utils.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + config.json());
                }
            } else {
                int idx = config.url().indexOf("?");
                Utils.info("\u8bf7\u6c42\u5730\u5740\uff1a" + config.url().substring(0, idx > 0 ? idx : config.url().length()));
                if (idx > 0) {
                    Utils.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + config.url().substring(idx + 1));
                }
            }
            HttpResponse httpResponse = resp = config.context() == null ? config.client().execute((HttpUriRequest)request) : config.client().execute((HttpUriRequest)request, config.context());
            if (config.isReturnRespHeaders()) {
                config.headers(resp.getAllHeaders());
            }
            return resp;
        }
        catch (IOException e) {
            throw new HttpProcessException(e);
        }
    }

    private static String fmt2String(HttpResponse resp, String encoding) throws HttpProcessException {
        String body = "";
        try {
            if (resp.getEntity() != null) {
                body = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)encoding);
                Utils.info(body);
            } else {
                body = resp.getStatusLine().toString();
            }
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
        catch (IOException e) {
            throw new HttpProcessException(e);
        }
        finally {
            HttpClientUtil.close(resp);
        }
        return body;
    }

    private static int fmt2Int(HttpResponse resp) throws HttpProcessException {
        int statusCode;
        try {
            statusCode = resp.getStatusLine().getStatusCode();
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
        catch (IOException e) {
            throw new HttpProcessException(e);
        }
        finally {
            HttpClientUtil.close(resp);
        }
        return statusCode;
    }

    public static OutputStream fmt2Stream(HttpResponse resp, OutputStream out) throws HttpProcessException {
        try {
            resp.getEntity().writeTo(out);
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
        catch (IOException e) {
            throw new HttpProcessException(e);
        }
        finally {
            HttpClientUtil.close(resp);
        }
        return out;
    }

    private static HttpRequestBase getRequest(String url, HttpMethods method) {
        HttpGet request = null;
        switch (method.getCode()) {
            case 0: {
                request = new HttpGet(url);
                break;
            }
            case 1: {
                request = new HttpPost(url);
                break;
            }
            case 2: {
                request = new HttpHead(url);
                break;
            }
            case 3: {
                request = new HttpPut(url);
                break;
            }
            case 4: {
                request = new HttpDelete(url);
                break;
            }
            case 5: {
                request = new HttpTrace(url);
                break;
            }
            case 6: {
                request = new HttpPatch(url);
                break;
            }
            case 7: {
                request = new HttpOptions(url);
                break;
            }
            default: {
                request = new HttpPost(url);
            }
        }
        return request;
    }

    private static void close(HttpResponse resp) {
        try {
            if (resp == null) {
                return;
            }
            if (CloseableHttpResponse.class.isAssignableFrom(resp.getClass())) {
                ((CloseableHttpResponse)resp).close();
            }
        }
        catch (IOException e) {
            Utils.exception(e);
        }
    }

    static {
        try {
            client4HTTP = HCB.custom().build();
            client4HTTPS = HCB.custom().ssl().build();
        }
        catch (HttpProcessException e) {
            Utils.errorException("\u521b\u5efahttps\u534f\u8bae\u7684HttpClient\u5bf9\u8c61\u51fa\u9519\uff1a{}", e);
        }
    }
}

