/*
 * Decompiled with CFR 0.152.
 */
package bingo.jpush.utils.httpclientutil.common.util;

import bingo.jpush.utils.httpclientutil.HttpClientUtil;
import bingo.jpush.utils.httpclientutil.builder.HCB;
import bingo.jpush.utils.httpclientutil.common.HttpConfig;
import bingo.jpush.utils.httpclientutil.common.HttpHeader;
import bingo.jpush.utils.httpclientutil.common.Utils;
import bingo.jpush.utils.httpclientutil.common.util.PropertiesUtil;
import bingo.jpush.utils.httpclientutil.common.util.StringUtil;
import bingo.jpush.utils.httpclientutil.exception.HttpProcessException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;

public class OCR {
    private static final String apiUrl = "http://lab.ocrking.com/ok.html";
    private static final String apiKey = PropertiesUtil.getProperty("OCR.key");
    private static HttpClient client = null;

    public static void enableCatch() {
        client = HCB.custom().proxy("127.0.0.1", 8888).build();
    }

    public static void unEnableCatch() {
        client = null;
    }

    private static Map<String, Object> getParaMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("service", "OcrKingForCaptcha");
        map.put("language", "eng");
        map.put("charset", "7");
        map.put("type", "http://www.unknown.com");
        map.put("apiKey", apiKey);
        return map;
    }

    public static String ocrCode(String filePath) {
        return OCR.ocrCode(filePath, 0);
    }

    public static String ocrCode(String imgFilePath, int limitCodeLen) {
        File f = new File(imgFilePath);
        if (!f.exists()) {
            return "Error:\u6587\u4ef6\u4e0d\u5b58\u5728!";
        }
        try {
            String html = HttpClientUtil.upload(HttpConfig.custom().client(client).url(apiUrl).files(new String[]{imgFilePath}, "ocrfile", true).map(OCR.getParaMap()));
            String[] results = StringUtil.regex("<Result>([^<]*)</Result>\\s*<Status>([^<]*)</Status>", html);
            if (results.length > 0) {
                if (Boolean.parseBoolean(results[1])) {
                    if (limitCodeLen <= 0 || limitCodeLen == results[0].length()) {
                        return results[0];
                    }
                    return "Error:\u83b7\u53d6\u5931\u8d25! \u539f\u56e0\uff1a\u8bc6\u522b\u7ed3\u679c\u957f\u5ea6\u4e3a:" + results[0].length() + "\uff08\u671f\u671b\u957f\u5ea6:" + limitCodeLen + "\uff09";
                }
                return "Error:\u83b7\u53d6\u5931\u8d25! \u539f\u56e0\uff1a" + results[0];
            }
        }
        catch (HttpProcessException e) {
            Utils.exception(e);
        }
        return "Error:\u83b7\u53d6\u5931\u8d25!";
    }

    public static String ocrCode4Net(String imgUrl) {
        return OCR.ocrCode4Net(imgUrl, 0);
    }

    public static String ocrCode4Net(String imgUrl, int limitCodeLen) {
        Map<String, Object> map = OCR.getParaMap();
        map.put("url", imgUrl);
        Header[] headers = HttpHeader.custom().userAgent("Mozilla/5.0 (Windows NT 5.1; zh-CN; rv:1.9.1.3) Gecko/20100101 Firefox/8.0").build();
        try {
            String html = HttpClientUtil.post(HttpConfig.custom().client(client).url(apiUrl).headers(headers).map(map));
            String[] results = StringUtil.regex("<Result>([^<]*)</Result>\\s*<Status>([^<]*)</Status>", html);
            if (results.length > 0) {
                if (Boolean.parseBoolean(results[1])) {
                    if (limitCodeLen <= 0 || limitCodeLen == results[0].length()) {
                        return results[0];
                    }
                    return "Error:\u83b7\u53d6\u5931\u8d25! \u539f\u56e0\uff1a\u8bc6\u522b\u7ed3\u679c\u957f\u5ea6\u4e3a:" + results[0].length() + "\uff08\u671f\u671b\u957f\u5ea6:" + limitCodeLen + "\uff09";
                }
                return "Error:\u83b7\u53d6\u5931\u8d25! \u539f\u56e0\uff1a" + results[0];
            }
        }
        catch (HttpProcessException e) {
            Utils.exception(e);
        }
        return "Error:\u83b7\u53d6\u5931\u8d25!";
    }

    public static String ocrCode4Net(HttpConfig config, String savePath) {
        return OCR.ocrCode4Net(config, savePath, 0);
    }

    public static String ocrCode4Net(HttpConfig config, String savePath, int limitCodeLen) {
        if (savePath == null || savePath.equals("")) {
            return OCR.ocrCode4Net(config.url(), limitCodeLen);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out = (ByteArrayOutputStream)HttpClientUtil.down(config.client(client).out(out));
            FileOutputStream fos = new FileOutputStream(savePath);
            fos.write(out.toByteArray());
            return OCR.ocrCode(savePath, limitCodeLen);
        }
        catch (HttpProcessException e) {
            Utils.exception(e);
        }
        catch (IOException e) {
            Utils.exception(e);
        }
        return "Error:\u83b7\u53d6\u5931\u8d25!";
    }

    public static void main(String[] args) throws HttpProcessException, IOException {
        String filePath = "C:/Users/160049/Desktop/\u4e2d\u56fd.png";
        String url = "http://file.ocrking.net:6080/small/20161104/w4fCjnzCl8KTwphpwqnCv2bCn8Kp/66fcff8d-61b1-49d6-bbfe-7428cf7accdf_debug.png?e9gFvJmkLbmgsZNTUCCNkjfi8J0Wbpn1CZHeP98eT1kxZ0ISBDt8Ql6h6zQ79pJg";
        String url2 = "http://59.41.9.91/GZCX/WebUI/Content/Handler/ValidateCode.ashx?0.3271647585525703";
        String code1 = OCR.ocrCode(filePath, 5);
        String code2 = OCR.ocrCode4Net(url, 5);
        String code3 = OCR.ocrCode4Net(HttpConfig.custom().url(url2), System.getProperty("user.dir") + System.getProperty("file.separator") + "123.png", 5);
        System.out.println(code1);
        System.out.println(code2);
        System.out.println(code3);
        System.out.println("----");
    }
}

