/*
 * Decompiled with CFR 0.152.
 */
package bingo.jpush.utils.httpclientutil.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    protected static Properties defaultProp = null;
    protected static Map<String, Properties> allProps = new HashMap<String, Properties>();

    public static Properties getProperties(String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return defaultProp;
        }
        Properties prop = allProps.get(fileName);
        if (prop == null) {
            prop = PropertiesUtil.loadProperties(fileName);
            allProps.put(fileName, prop);
        }
        return prop;
    }

    protected static Properties loadProperties(String fileName) {
        Properties prop = new Properties();
        InputStream ins = null;
        ins = PropertiesUtil.class.getClassLoader().getResourceAsStream(fileName);
        if (ins == null) {
            System.err.println("Can not find the resource!");
        } else {
            try {
                prop.load(ins);
            }
            catch (IOException e) {
                System.err.println("An error occurred when reading from the input stream, " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                System.err.println("The input stream contains a malformed Unicode escape sequence, " + e.getMessage());
            }
        }
        return prop;
    }

    public static String getProperty(String fileName, String name) {
        return PropertiesUtil.getProperties(fileName).getProperty(name);
    }

    public static String getProperty(String name) {
        return PropertiesUtil.getProperties(null).getProperty(name);
    }

    static {
        if (defaultProp == null) {
            defaultProp = PropertiesUtil.loadProperties("config.properties");
            allProps.put("config.properties", defaultProp);
        }
    }
}

