/*
 * Decompiled with CFR 0.152.
 */
package com.vivo.push.sdk.common;

import com.alibaba.fastjson.JSON;
import com.vivo.push.sdk.common.Constants;
import com.vivo.push.sdk.notofication.Result;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    protected final String secret;
    private String authToken;
    private static PoolingHttpClientConnectionManager manager = null;

    public HttpUtil(String secret) {
        this.secret = secret;
        this.authToken = null;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void init() throws Exception {
        if (manager != null) return;
        Class<PoolingHttpClientConnectionManager> clazz = PoolingHttpClientConnectionManager.class;
        synchronized (PoolingHttpClientConnectionManager.class) {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial((KeyStore)null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory ssl = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)ssl).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
            manager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            manager.setMaxTotal(Constants.HTTP_MAX_CONNECTION);
            manager.setDefaultMaxPerRoute(Constants.HTTP_MAX_ROUTE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void init(int connection, int route) throws Exception {
        manager = null;
        Class<PoolingHttpClientConnectionManager> clazz = PoolingHttpClientConnectionManager.class;
        synchronized (PoolingHttpClientConnectionManager.class) {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial((KeyStore)null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory ssl = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)ssl).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
            manager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            manager.setMaxTotal(connection);
            manager.setDefaultMaxPerRoute(route);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected String doPost(String jsonBody, String path) throws Exception {
        HttpPost httpPost = new HttpPost(HttpUtil.getUrl(path));
        httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
        if (this.authToken != null) {
            httpPost.addHeader("authToken", this.authToken);
        }
        StringEntity stringEntity = new StringEntity(jsonBody, Constants.CHARSET);
        stringEntity.setContentEncoding("UTF-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        return HttpUtil.execute((HttpUriRequest)httpPost);
    }

    private static String execute(HttpUriRequest request) throws Exception {
        String data = null;
        CloseableHttpResponse response = null;
        try {
            int status;
            response = HttpUtil.getHttpClient().execute(request);
            try {
                status = response.getStatusLine().getStatusCode();
            }
            catch (Exception var3) {
                var3.printStackTrace();
                String string = null;
                try {
                    if (null != response) {
                        response.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return string;
            }
            if (status != 200) {
                try {
                    data = response.getStatusLine().getReasonPhrase();
                }
                catch (Exception var4) {
                    data = "N/A";
                    var4.printStackTrace();
                }
                throw new IOException("faild :" + status + ":" + data);
            }
            String string = data = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Constants.CHARSET);
            return string;
        }
        catch (Exception var3) {
            var3.printStackTrace();
            throw var3;
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String doGet(String requestPath) throws Exception {
        HttpGet httpGet = new HttpGet(HttpUtil.getUrl(requestPath));
        if (this.authToken != null) {
            httpGet.addHeader("authToken", this.authToken);
        }
        return HttpUtil.execute((HttpUriRequest)httpGet);
    }

    private static CloseableHttpClient getHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Constants.CONNECTION_REQUEST_TIMEOUT).setConnectTimeout(Constants.CONNECTION_TIMEOUT).setSocketTimeout(Constants.SOCKET_TIMEOUT).build();
        HttpRequestRetryHandler retry = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 3) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return true;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).setRetryHandler(retry).setConnectionManager((HttpClientConnectionManager)manager).build();
    }

    protected static Result sendMessage(String response) throws IOException {
        try {
            return (Result)JSON.parseObject((String)response, Result.class);
        }
        catch (Exception var6) {
            throw new IOException("Invalid response from Push: " + response);
        }
    }

    private static String getUrl(String path) {
        return String.format("https://%s%s", "api-push.vivo.com.cn", path);
    }
}

