/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms;

import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.spi.ObjectFactory;
import javax.transaction.TransactionManager;
import org.messaginghub.pooled.jms.JmsPoolConnection;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.messaginghub.pooled.jms.JmsPoolXAJMSContext;
import org.messaginghub.pooled.jms.pool.PooledConnectionKey;
import org.messaginghub.pooled.jms.pool.PooledXAConnection;
import org.messaginghub.pooled.jms.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsPoolXAConnectionFactory
extends JmsPoolConnectionFactory
implements ObjectFactory,
Serializable,
XAConnectionFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(JmsPoolXAConnectionFactory.class);
    private static final long serialVersionUID = 7753681333583183646L;
    private TransactionManager transactionManager;
    private boolean tmFromJndi = false;
    private String tmJndiName = "java:/TransactionManager";

    public TransactionManager getTransactionManager() {
        block3: {
            if (this.transactionManager == null && this.tmFromJndi) {
                try {
                    this.transactionManager = (TransactionManager)new InitialContext().lookup(this.getTmJndiName());
                }
                catch (Throwable ignored) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace("exception on tmFromJndi: " + this.getTmJndiName(), ignored);
                }
            }
        }
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void setConnectionFactory(Object toUse) {
        if (toUse instanceof XAConnectionFactory) {
            try {
                toUse.getClass().getMethod("createContext", String.class, String.class);
                LOG.info("Provided ConnectionFactory is JMS 2.0+ capable.");
                this.jmsContextSupported = true;
            }
            catch (NoSuchMethodException | SecurityException e) {
                LOG.info("Provided ConnectionFactory is not JMS 2.0+ capable.");
            }
        } else {
            throw new IllegalArgumentException("connectionFactory should implement javax.jms.XAConnectionFactory");
        }
        this.connectionFactory = toUse;
    }

    protected XAConnection createProviderConnection(PooledConnectionKey key) throws JMSException {
        if (this.connectionFactory instanceof XAConnectionFactory) {
            if (key.getUserName() == null && key.getPassword() == null) {
                return ((XAConnectionFactory)this.connectionFactory).createXAConnection();
            }
            return ((XAConnectionFactory)this.connectionFactory).createXAConnection(key.getUserName(), key.getPassword());
        }
        throw new IllegalStateException("connectionFactory should implement javax.jms.XAConnectionFactory");
    }

    protected XAJMSContext createProviderContext(String username, String password, int sessionMode) {
        if (this.connectionFactory instanceof XAConnectionFactory) {
            if (username == null && password == null) {
                return ((XAConnectionFactory)this.connectionFactory).createXAContext();
            }
            return ((XAConnectionFactory)this.connectionFactory).createXAContext(username, password);
        }
        throw new IllegalStateRuntimeException("connectionFactory should implement javax.jms.XAConnectionFactory");
    }

    @Override
    protected PooledXAConnection createPooledConnection(Connection connection) {
        return new PooledXAConnection(connection, this.getTransactionManager());
    }

    @Override
    protected JmsPoolXAJMSContext newPooledConnectionContext(JmsPoolConnection connection, int sessionMode) {
        return new JmsPoolXAJMSContext(connection, sessionMode);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        this.setTmFromJndi(true);
        this.configFromJndiConf(obj);
        if (environment != null) {
            IntrospectionSupport.setProperties(this, environment);
        }
        return this;
    }

    private void configFromJndiConf(Object rootContextName) {
        block4: {
            if (rootContextName instanceof String) {
                String name = (String)rootContextName;
                name = name.substring(0, name.lastIndexOf(47)) + "/conf" + name.substring(name.lastIndexOf(47));
                try {
                    InitialContext ctx = new InitialContext();
                    NamingEnumeration<Binding> bindings = ctx.listBindings(name);
                    while (bindings.hasMore()) {
                        Binding bd = bindings.next();
                        IntrospectionSupport.setProperty(this, bd.getName(), bd.getObject());
                    }
                }
                catch (Exception ignored) {
                    if (!LOG.isTraceEnabled()) break block4;
                    LOG.trace("exception on config from jndi: " + name, (Throwable)ignored);
                }
            }
        }
    }

    public String getTmJndiName() {
        return this.tmJndiName;
    }

    public void setTmJndiName(String tmJndiName) {
        this.tmJndiName = tmJndiName;
    }

    public boolean isTmFromJndi() {
        return this.tmFromJndi;
    }

    public void setTmFromJndi(boolean tmFromJndi) {
        this.tmFromJndi = tmFromJndi;
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createProviderConnection(new PooledConnectionKey(null, null));
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        return this.createProviderConnection(new PooledConnectionKey(userName, password));
    }

    public XAJMSContext createXAContext() {
        return this.createProviderContext(null, null, 0);
    }

    public XAJMSContext createXAContext(String userName, String password) {
        return this.createProviderContext(userName, password, 0);
    }
}

