/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.utils.qrcode;

import com.github.binarywang.utils.qrcode.BufferedImageLuminanceSource;
import com.github.binarywang.utils.qrcode.MatrixToImageWriter;
import com.github.binarywang.utils.qrcode.MatrixToLogoImageConfig;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrcodeUtils {
    private static final int DEFAULT_LENGTH = 400;
    private static final String FORMAT = "jpg";
    private static Logger logger = LoggerFactory.getLogger(QrcodeUtils.class);

    private static BitMatrix createQrcodeMatrix(String content, int length) {
        EnumMap hints = Maps.newEnumMap(EncodeHintType.class);
        hints.put(EncodeHintType.CHARACTER_SET, Charsets.UTF_8.name());
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        try {
            return new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, length, length, (Map)hints);
        }
        catch (Exception e) {
            logger.warn("\u5185\u5bb9\u4e3a\uff1a\u3010" + content + "\u3011\u7684\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    public static byte[] createQrcode(String content, int length, File logoFile) {
        if (logoFile != null && !logoFile.exists()) {
            throw new IllegalArgumentException("\u8bf7\u63d0\u4f9b\u6b63\u786e\u7684logo\u6587\u4ef6\uff01");
        }
        BitMatrix qrCodeMatrix = QrcodeUtils.createQrcodeMatrix(content, length);
        if (qrCodeMatrix == null) {
            return null;
        }
        try {
            File file = Files.createTempFile("qrcode_", ".jpg", new FileAttribute[0]).toFile();
            logger.debug(file.getAbsolutePath());
            MatrixToImageWriter.writeToFile(qrCodeMatrix, FORMAT, file);
            if (logoFile != null) {
                BufferedImage img = ImageIO.read(file);
                QrcodeUtils.overlapImage(img, FORMAT, file.getAbsolutePath(), logoFile, new MatrixToLogoImageConfig());
            }
            return QrcodeUtils.toByteArray(file);
        }
        catch (Exception e) {
            logger.warn("\u5185\u5bb9\u4e3a\uff1a\u3010" + content + "\u3011\u7684\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    public static byte[] createQrcode(String content, File logoFile) {
        return QrcodeUtils.createQrcode(content, 400, logoFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] toByteArray(File file) {
        try (FileChannel fc = new RandomAccessFile(file, "r").getChannel();){
            MappedByteBuffer byteBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size()).load();
            byte[] result = new byte[(int)fc.size()];
            if (byteBuffer.remaining() > 0) {
                byteBuffer.get(result, 0, byteBuffer.remaining());
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e) {
            logger.warn("\u6587\u4ef6\u8f6c\u6362\u6210byte[]\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    private static void overlapImage(BufferedImage image, String format, String imagePath, File logoFile, MatrixToLogoImageConfig logoConfig) throws IOException {
        try {
            BufferedImage logo = ImageIO.read(logoFile);
            Graphics2D g = image.createGraphics();
            int width = image.getWidth() / logoConfig.getLogoPart();
            int height = image.getHeight() / logoConfig.getLogoPart();
            int x = (image.getWidth() - width) / 2;
            int y = (image.getHeight() - height) / 2;
            g.drawImage(logo, x, y, width, height, null);
            g.setStroke(new BasicStroke(logoConfig.getBorder()));
            g.setColor(logoConfig.getBorderColor());
            g.drawRect(x, y, width, height);
            g.dispose();
            ImageIO.write((RenderedImage)image, format, new File(imagePath));
        }
        catch (Exception e) {
            throw new IOException("\u4e8c\u7ef4\u7801\u6dfb\u52a0logo\u65f6\u53d1\u751f\u5f02\u5e38\uff01", e);
        }
    }

    public static String decodeQrcode(File file) throws IOException, NotFoundException {
        BufferedImage image = ImageIO.read(file);
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
        EnumMap hints = Maps.newEnumMap(DecodeHintType.class);
        hints.put(DecodeHintType.CHARACTER_SET, Charsets.UTF_8.name());
        return new MultiFormatReader().decode(binaryBitmap, (Map)hints).getText();
    }
}

