/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.ocsp;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1GeneralizedTime;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERGeneralizedTime;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DERObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import cfca.sadk.org.bouncycastle.asn1.ocsp.CertStatus;
import cfca.sadk.org.bouncycastle.asn1.ocsp.ResponderID;
import cfca.sadk.org.bouncycastle.asn1.ocsp.ResponseData;
import cfca.sadk.org.bouncycastle.asn1.ocsp.RevokedInfo;
import cfca.sadk.org.bouncycastle.asn1.ocsp.SingleResponse;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.CRLReason;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Extensions;
import cfca.sadk.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import cfca.sadk.org.bouncycastle.cert.ocsp.CertificateID;
import cfca.sadk.org.bouncycastle.cert.ocsp.CertificateStatus;
import cfca.sadk.org.bouncycastle.cert.ocsp.RespID;
import cfca.sadk.org.bouncycastle.cert.ocsp.RevokedStatus;
import cfca.sadk.org.bouncycastle.cert.ocsp.UnknownStatus;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class BasicOCSPRespGenerator {
    private List list = new ArrayList();
    private Extensions responseExtensions = null;
    private RespID responderID;
    private static Hashtable algorithms = new Hashtable();

    private ASN1Object makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        return aIn.readObject();
    }

    public BasicOCSPRespGenerator(RespID responderID) {
        this.responderID = responderID;
    }

    public BasicOCSPRespGenerator(PublicKey pubKey) throws PKIException {
        DEROctetString derOCTString = new DEROctetString(pubKey.getEncoded());
        ResponderID responderID = new ResponderID(derOCTString);
        this.responderID = new RespID(responderID);
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus) throws PKIException {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), null, null));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, X509Extensions singleExtensions) throws PKIException {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), null, singleExtensions));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Date nextUpdate, X509Extensions singleExtensions) throws PKIException {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), nextUpdate, singleExtensions));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, X509Extensions singleExtensions) throws PKIException {
        this.list.add(new ResponseObject(certID, certStatus, thisUpdate, nextUpdate, singleExtensions));
    }

    public void setResponseExtensions(Extensions responseExtensions) {
        this.responseExtensions = responseExtensions;
    }

    private BasicOCSPResp generateResponse(ASN1ObjectIdentifier signingAlgorithm, PrivateKey priKey, X509Cert[] chain, Date producedAt, Session session) throws PKIException {
        Iterator it = this.list.iterator();
        ASN1EncodableVector responses = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                responses.add(((ResponseObject)it.next()).toResponse());
            }
            catch (Exception e) {
                throw new PKIException(PKIException.GEN_OCSP_RESPLIST_ERR, PKIException.GEN_OCSP_RESPLIST_ERR_DES, e);
            }
        }
        DERSequence derSeq = new DERSequence(responses);
        ResponseData tbsResp = new ResponseData(new ASN1Integer(0L), this.responderID.toASN1Object(), new ASN1GeneralizedTime(producedAt), ASN1Sequence.getInstance(derSeq), this.responseExtensions);
        byte[] signature = null;
        try {
            signature = session.sign(Mechanisms.M_SHA1_RSA, priKey, tbsResp.getEncoded());
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.SIGN_RESP_ERR, PKIException.SIGN_RESP_ERR_DES, ex);
        }
        DERBitString bitSig = new DERBitString(signature);
        AlgorithmIdentifier sigAlgId = new AlgorithmIdentifier(signingAlgorithm, DERNull.INSTANCE);
        if (chain != null && chain.length > 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i != chain.length; ++i) {
                v.add(chain[i].getCertStructure());
            }
            return new BasicOCSPResp(new BasicOCSPResponse(tbsResp, sigAlgId, bitSig, new DERSequence(v)));
        }
        return new BasicOCSPResp(new BasicOCSPResponse(tbsResp, sigAlgId, bitSig, null));
    }

    public BasicOCSPResp generate(String signingAlgorithm, PrivateKey priKey, X509Cert[] certChain, Date producedAt, Session session) throws PKIException {
        DERObjectIdentifier oid = new DERObjectIdentifier(signingAlgorithm);
        return this.generateResponse(oid, priKey, certChain, producedAt, session);
    }

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD2WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD5WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("MD5WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("SHA1WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA1WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("RIPEMD160WITHRSA", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("SHA1WITHDSA", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("DSAWITHSHA1", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("SHA1WITHECDSA", new DERObjectIdentifier("1.2.840.10045.4.1"));
        algorithms.put("ECDSAWITHSHA1", new DERObjectIdentifier("1.2.840.10045.4.1"));
    }

    private class ResponseObject {
        CertificateID certId;
        CertStatus certStatus;
        DERGeneralizedTime thisUpdate;
        DERGeneralizedTime nextUpdate;
        X509Extensions extensions;

        public ResponseObject(CertificateID certId, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, X509Extensions extensions) throws PKIException {
            RevokedStatus rs;
            this.certId = certId;
            this.certStatus = certStatus == null ? new CertStatus() : (certStatus instanceof UnknownStatus ? new CertStatus(2, new DERNull()) : ((rs = (RevokedStatus)certStatus).hasRevocationReason() ? new CertStatus(new RevokedInfo(new DERGeneralizedTime(rs.getRevocationTime()), CRLReason.lookup(rs.getRevocationReason()))) : new CertStatus(new RevokedInfo(new DERGeneralizedTime(rs.getRevocationTime()), null))));
            this.thisUpdate = new DERGeneralizedTime(thisUpdate);
            this.nextUpdate = nextUpdate != null ? new DERGeneralizedTime(nextUpdate) : null;
            this.extensions = extensions;
        }

        public SingleResponse toResponse() throws Exception {
            return new SingleResponse(this.certId.toASN1Object(), this.certStatus, (ASN1GeneralizedTime)this.thisUpdate, (ASN1GeneralizedTime)this.nextUpdate, this.extensions);
        }
    }
}

