/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.lib.crypto.hard.HardLib;
import cfca.sadk.lib.crypto.jni.JNIInit;
import cfca.sadk.lib.crypto.jni.JNISoftLib;
import cfca.sadk.license.LicenseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class JCrypto {
    public static final String LICENSE_FILE = "sadklicense.dat";
    public static final String JSOFT_LIB = "JSOFT_LIB";
    public static final String JNI_LIB = "JNISOFT_LIB";
    public static final String JHARD_LIB = "JHARD_LIB";
    private static JCrypto jCrypto = null;
    private Hashtable htable = new Hashtable();

    private JCrypto() {
    }

    public static synchronized JCrypto getInstance() {
        if (jCrypto == null) {
            jCrypto = new JCrypto();
            return jCrypto;
        }
        return jCrypto;
    }

    public Session openSession(String deviceName) throws PKIException {
        Session session = (Session)this.htable.get(deviceName);
        if (session == null) {
            throw new PKIException(PKIException.OPSESSION, PKIException.OPSESSION_DES + " " + deviceName);
        }
        return session;
    }

    public boolean initialize(String deviceName, Object param) throws PKIException {
        this.checkLicense();
        try {
            if (this.htable.containsKey(deviceName)) {
                return true;
            }
            if (deviceName.equals(JSOFT_LIB)) {
                this.htable.put(deviceName, new BCSoftLib());
            } else if (deviceName.equals(JHARD_LIB)) {
                this.htable.put(deviceName, new HardLib((String)param));
            } else if (deviceName.equals(JNI_LIB)) {
                JNIInit.initOpenSSL();
                this.htable.put(deviceName, new JNISoftLib());
            }
            return true;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT, PKIException.INIT_DES + " " + deviceName, ex);
        }
    }

    private void checkLicense() throws PKIException {
        block23: {
            LicenseUtil licenseUtil = new LicenseUtil();
            InputStream is = null;
            try {
                File file = new File(LICENSE_FILE);
                if (file.isFile() && file.exists()) {
                    is = new FileInputStream(file);
                } else {
                    is = this.getClass().getClassLoader().getResourceAsStream("META-INF/sadklicense.dat");
                    if (is == null) {
                        is = this.getClass().getClassLoader().getResourceAsStream(LICENSE_FILE);
                    }
                }
                if (is == null) {
                    throw new PKIException(PKIException.READ_LICENSE_ERR, PKIException.READ_LICENSE_ERR_DES);
                }
                licenseUtil.verifyLicense(is);
                String endDate = licenseUtil.getCustomerProp().getProperty("endDate");
                String hostIP = licenseUtil.getCustomerProp().getProperty("hostIP");
                String licenseUsage = licenseUtil.getCustomerProp().getProperty("licenseUsage");
                if ("probation".equals(licenseUsage)) {
                    if (endDate != null) {
                        this.checkEndDate(endDate);
                        break block23;
                    }
                    throw new PKIException(PKIException.LICENSE_END_DATE_NOTFOUND_ERR, PKIException.LICENSE_END_DATE_NOTFOUND_ERR_DES);
                }
                if ("regulation".equals(licenseUsage)) {
                    if (hostIP != null) {
                        this.checkIPv4(hostIP);
                        break block23;
                    }
                    throw new PKIException(PKIException.LICENSE_IP_NOTFOUND_ERR, PKIException.LICENSE_IP_NOTFOUND_ERR_DES);
                }
                if ("unbridled".equals(licenseUsage)) {
                    return;
                }
                throw new PKIException("\u975e\u6cd5\u8bb8\u53ef\u8bc1\uff01");
            }
            catch (PKIException ex) {
                throw new PKIException(PKIException.READ_LICENSE_ERR, PKIException.READ_LICENSE_ERR_DES + " " + ex.getMessage(), ex);
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.READ_LICENSE_ERR, PKIException.READ_LICENSE_ERR_DES + " " + ex.getMessage(), ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private void checkIPv4(String licenseHostIP) throws PKIException {
        try {
            InetAddress inetAdd = InetAddress.getLocalHost();
            String hostIP = inetAdd.getHostAddress().trim();
            if (licenseHostIP.indexOf(hostIP) <= -1) {
                throw new PKIException(PKIException.LICENSE_IP_ERR, PKIException.LICENSE_IP_ERR_DES + ",\u4e3b\u673aIP\u4e3a:" + hostIP + ",licenseIP\u4e3a:" + licenseHostIP);
            }
        }
        catch (Exception ex) {
            if (ex instanceof PKIException) {
                throw (PKIException)ex;
            }
            throw new PKIException(PKIException.LICENSE_IP_ERR, PKIException.LICENSE_IP_ERR_DES + ":" + ex.getMessage());
        }
    }

    private void checkEndDate(String endDate) throws PKIException {
        try {
            endDate = endDate + " 00:00:00";
            long licenseEndDate = this.formateLocalTime(endDate);
            Date sysDate = new Date();
            long sysLong = sysDate.getTime();
            if (sysLong > licenseEndDate) {
                throw new PKIException(PKIException.LICENSE_END_DATE_ERR, PKIException.LICENSE_END_DATE_ERR_DES + ":license\u6700\u8fd1\u62f7\u8d1d\u65e5\u671f\u4e3a" + endDate);
            }
        }
        catch (Exception ex) {
            if (ex instanceof PKIException) {
                throw (PKIException)ex;
            }
            throw new PKIException(PKIException.LICENSE_END_DATE_ERR, PKIException.LICENSE_END_DATE_ERR_DES + ":" + ex.getMessage());
        }
    }

    public long formateLocalTime(String localTime) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        date = simpleDateFormat.parse(localTime);
        return date.getTime();
    }

    public boolean finalize(String deviceName, Object param) throws PKIException {
        try {
            if (!this.htable.containsKey(deviceName)) {
                return true;
            }
            if (deviceName.equals(JNI_LIB)) {
                JNIInit.unInitOpenSSL();
            } else if (deviceName.equals(JHARD_LIB)) {
                // empty if block
            }
            this.htable.remove(deviceName);
            return true;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.FINI, PKIException.FINI_DES + " " + deviceName, ex);
        }
    }
}

