/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKCS7SignedFile;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.algorithm.util.FileUtil;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.asn1.cms.CMSAttributes;
import cfca.sadk.org.bouncycastle.asn1.cms.Time;
import cfca.sadk.org.bouncycastle.cms.CMSSignedDataParser;
import cfca.sadk.org.bouncycastle.cms.SignerInformation;
import cfca.sadk.org.bouncycastle.cms.SignerInformationStore;
import cfca.sadk.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.sadk.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import cfca.sadk.system.global.FileAndBufferConfig;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class Signature {
    private X509Cert signCert = null;
    private String digestAlgorithm = null;
    private byte[] signature = null;
    private byte[] sourceData = null;

    public X509Cert getSignerX509CertFromP7SignData(byte[] p7SignedData) throws PKIException {
        PKCS7SignedData pkcs7SignedData = new PKCS7SignedData(null);
        pkcs7SignedData.loadBase64(p7SignedData);
        return pkcs7SignedData.getSignerX509Cert();
    }

    public byte[] getContentFromP7SignData(byte[] p7SignedData) throws PKIException {
        PKCS7SignedData pkcs7SignedData = new PKCS7SignedData(null);
        pkcs7SignedData.loadBase64(p7SignedData);
        return pkcs7SignedData.getSourceData();
    }

    public String getDigestAlgorithmFromP7SignData(byte[] p7SignedData) throws PKIException {
        PKCS7SignedData pkcs7SignedData = new PKCS7SignedData(null);
        pkcs7SignedData.loadBase64(p7SignedData);
        return pkcs7SignedData.getDigestAlgorithm();
    }

    public byte[] getSourceData() {
        return this.sourceData;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public X509Cert getSignerCert() {
        return this.signCert;
    }

    private byte[] RStoASN1(byte[] signData) throws PKIException {
        if (signData != null && signData.length == 64) {
            byte[] r = null;
            byte[] s = null;
            if ((signData[0] & 0x80) != 0) {
                r = new byte[33];
                r[0] = 0;
                System.arraycopy(signData, 0, r, 1, 32);
            } else {
                r = new byte[32];
                System.arraycopy(signData, 0, r, 0, 32);
            }
            if ((signData[32] & 0x80) != 0) {
                s = new byte[33];
                s[0] = 0;
                System.arraycopy(signData, 32, s, 1, 32);
            } else {
                s = new byte[32];
                System.arraycopy(signData, 32, s, 0, 32);
            }
            ASN1Integer R = new ASN1Integer(r);
            ASN1Integer S = new ASN1Integer(s);
            ASN1EncodableVector rsV = new ASN1EncodableVector();
            rsV.add(R);
            rsV.add(S);
            DERSequence rsSequence = new DERSequence(rsV);
            try {
                return rsSequence.getEncoded();
            }
            catch (Exception e) {
                throw new PKIException("SM2Signature Encoded Failure", e);
            }
        }
        return signData;
    }

    private byte[] ASN1toRS(byte[] asn1RS) {
        ASN1Sequence sequence = ASN1Sequence.getInstance(asn1RS);
        ASN1Integer R = (ASN1Integer)sequence.getObjectAt(0);
        ASN1Integer S = (ASN1Integer)sequence.getObjectAt(1);
        byte[] r = BigIntegerUtil.asUnsigned32ByteArray(R.getPositiveValue());
        byte[] s = BigIntegerUtil.asUnsigned32ByteArray(S.getPositiveValue());
        byte[] signature = new byte[64];
        System.arraycopy(r, 0, signature, 0, 32);
        System.arraycopy(s, 0, signature, 32, 32);
        return signature;
    }

    public byte[] p1SignByHash(String signAlg, byte[] hashValue, PrivateKey privateKey, Session session) throws PKIException {
        return Base64.encode(this.RStoASN1(session.signByHash(new Mechanism(signAlg), privateKey, hashValue)));
    }

    public byte[] p7SignByHash(String signAlg, byte[] hashValue, PrivateKey privateKey, X509Cert signCert, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        X509Cert[] certs = new X509Cert[]{signCert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.signByHash(new Mechanism(signAlg), privateKey, hashValue);
        return Base64.encode(p7.packageSignedData(false, null, null, signture, mechanism, certs));
    }

    public boolean p1VerifyByHash(String signAlg, byte[] hashValue, byte[] base64P1SignedData, PublicKey publicKey, Session session) throws PKIException {
        byte[] asn1RS_RS = null;
        asn1RS_RS = ASN1Parser.isBase64Compatability(base64P1SignedData) ? Base64.decode(base64P1SignedData) : base64P1SignedData;
        if (asn1RS_RS.length == 64 || asn1RS_RS.length >= 128) {
            return session.verifyByHash(new Mechanism(signAlg), publicKey, hashValue, asn1RS_RS);
        }
        if (asn1RS_RS.length >= 66 && asn1RS_RS.length <= 72) {
            byte[] signature = this.ASN1toRS(asn1RS_RS);
            return session.verifyByHash(new Mechanism(signAlg), publicKey, hashValue, signature);
        }
        throw new PKIException("the sign data is wrong!");
    }

    public boolean p7VerifyByHash(byte[] hashValue, byte[] base64P7SignedData, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(base64P7SignedData);
        this.signCert = p7.getSignerX509Cert();
        this.digestAlgorithm = p7.getDigestAlgorithm();
        this.signature = p7.getSignature();
        return p7.verifyP7SignedDataByHash(hashValue);
    }

    public byte[] p1SignMessage(String signAlg, byte[] sourceData, PrivateKey privateKey, Session session) throws PKIException {
        return Base64.encode(this.RStoASN1(session.sign(new Mechanism(signAlg), privateKey, sourceData)));
    }

    public byte[] p1SignFile(String signAlg, String sourceFilePath, PrivateKey privateKey, Session session) throws PKIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            byte[] byArray = Base64.encode(this.RStoASN1(session.sign(new Mechanism(signAlg), privateKey, fis)));
            return byArray;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("P1File Signed Failure", e);
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (Exception e) {
                throw new PKIException("P1File Signed Failure", e);
            }
        }
    }

    public byte[] p7SignMessageAttach(String signAlg, byte[] sourceData, PrivateKey privateKey, X509Cert signCert, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        X509Cert[] certs = new X509Cert[]{signCert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.sign(mechanism, privateKey, sourceData);
        return Base64.encode(p7.packageSignedData(true, null, sourceData, signture, mechanism, certs));
    }

    public byte[] p7SignMessageDetach(String signAlg, byte[] sourceData, PrivateKey privateKey, X509Cert signCert, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        X509Cert[] certs = new X509Cert[]{signCert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.sign(mechanism, privateKey, sourceData);
        return Base64.encode(p7.packageSignedData(false, null, sourceData, signture, mechanism, certs));
    }

    public void p7SignFileAttach(String signAlg, String sourceFilePath, String outFilePath, PrivateKey privateKey, X509Cert signCert, Session session) throws PKIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            PKCS7SignedFile p7 = new PKCS7SignedFile(session);
            X509Cert[] certs = new X509Cert[]{signCert};
            Mechanism mechanism = new Mechanism(signAlg);
            byte[] signture = session.sign(mechanism, privateKey, fis);
            fis = new FileInputStream(sourceFilePath);
            p7.packageSignedFile(null, sourceFilePath, outFilePath, signture, mechanism, certs);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("P7SignFileAttach Signed Failure", e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                throw new PKIException("P7SignFileAttach Signed Failure", e);
            }
        }
    }

    public byte[] p7SignFileDetach(String signAlg, String sourceFilePath, PrivateKey privateKey, X509Cert signCert, Session session) throws PKIException {
        InputStream is = null;
        try {
            PKCS7SignedData p7 = new PKCS7SignedData(session);
            X509Cert[] certs = new X509Cert[]{signCert};
            Mechanism mechanism = new Mechanism(signAlg);
            is = new FileInputStream(sourceFilePath);
            byte[] signture = session.sign(mechanism, privateKey, is);
            byte[] byArray = Base64.encode(p7.packageSignedData(false, null, null, signture, mechanism, certs));
            return byArray;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("P7SignFileDetach Signed Failure", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    throw new PKIException("P7SignFileDetach Signed Failure", e);
                }
            }
        }
    }

    public boolean p1VerifyMessage(String signAlg, byte[] sourceData, byte[] base64P1SignedData, PublicKey publicKey, Session session) throws PKIException {
        byte[] asn1RS_RS = null;
        asn1RS_RS = ASN1Parser.isBase64Compatability(base64P1SignedData) ? Base64.decode(base64P1SignedData) : base64P1SignedData;
        if (asn1RS_RS.length == 64 || asn1RS_RS.length >= 128) {
            return session.verify(new Mechanism(signAlg), publicKey, sourceData, asn1RS_RS);
        }
        if (asn1RS_RS.length >= 66 && asn1RS_RS.length <= 72) {
            byte[] signature = this.ASN1toRS(asn1RS_RS);
            return session.verify(new Mechanism(signAlg), publicKey, sourceData, signature);
        }
        throw new PKIException("the sign data is wrong!");
    }

    public boolean p1VerifyFile(String signAlg, String sourceFilePath, byte[] base64P1SignedData, PublicKey publicKey, Session session) throws PKIException {
        InputStream is = null;
        try {
            byte[] asn1RS_RS = null;
            asn1RS_RS = ASN1Parser.isBase64Compatability(base64P1SignedData) ? Base64.decode(base64P1SignedData) : base64P1SignedData;
            is = new FileInputStream(sourceFilePath);
            if (asn1RS_RS.length == 64 || asn1RS_RS.length >= 128) {
                boolean bl = session.verify(new Mechanism(signAlg), publicKey, is, asn1RS_RS);
                return bl;
            }
            if (asn1RS_RS.length >= 66 && asn1RS_RS.length <= 72) {
                byte[] signature = this.ASN1toRS(asn1RS_RS);
                boolean bl = session.verify(new Mechanism(signAlg), publicKey, is, signature);
                return bl;
            }
            try {
                throw new PKIException("the sign data is wrong!");
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("P1File Verified Failure", e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    throw new PKIException("P1File Verified Failure", e);
                }
            }
        }
    }

    public boolean p7VerifyMessageAttach(byte[] base64P7SignedData, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(base64P7SignedData);
        this.signCert = p7.getSignerX509Cert();
        this.sourceData = p7.getSourceData();
        this.digestAlgorithm = p7.getDigestAlgorithm();
        this.signature = p7.getSignature();
        return p7.verifyP7SignedDataAttach();
    }

    public boolean p7VerifyMessageDetach(byte[] sourceData, byte[] base64P7SignedData, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(base64P7SignedData);
        this.signCert = p7.getSignerX509Cert();
        this.digestAlgorithm = p7.getDigestAlgorithm();
        this.signature = p7.getSignature();
        return p7.verifyP7SignedData(sourceData);
    }

    public boolean p7VerifyFileAttach(String signFilePath, String outSourceFilePath, Session session) throws PKIException {
        try {
            File f = new File(signFilePath);
            if (f.length() <= (long)FileAndBufferConfig.SIGN_FILE_SIZE) {
                byte[] temps = FileUtil.getBytesFromFile(signFilePath);
                boolean ret = this.p7VerifyMessageAttach(temps, session);
                if (outSourceFilePath != null && !outSourceFilePath.trim().equals("")) {
                    FileOutputStream fos = new FileOutputStream(outSourceFilePath);
                    FileUtil.writeBytesToFile(this.getSourceData(), fos);
                    fos.close();
                }
                return ret;
            }
            PKCS7SignedFile p7 = new PKCS7SignedFile(session);
            boolean result = p7.verifyP7SignedFile(signFilePath, outSourceFilePath);
            this.signCert = p7.getSignerX509Cert();
            this.digestAlgorithm = p7.getDigestAlgorithm();
            this.signature = p7.getSignature();
            return result;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("P7VerifyFileAttach Verified Failure", e);
        }
    }

    public boolean p7VerifyFileDetach(String sourceFilePath, byte[] base64P7SignedData, Session session) throws PKIException {
        InputStream is = null;
        try {
            PKCS7SignedData p7 = new PKCS7SignedData(session);
            p7.loadBase64(base64P7SignedData);
            this.signCert = p7.getSignerX509Cert();
            this.digestAlgorithm = p7.getDigestAlgorithm();
            this.signature = p7.getSignature();
            is = new FileInputStream(sourceFilePath);
            boolean bl = p7.verifyP7SignedData(is);
            return bl;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("P7VerifyFileDetach Verified Failure", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    throw new PKIException("P7VerifyFileDetach Verified Failure", e);
                }
            }
        }
    }

    public String getTimeFromTimeStamp(byte[] base64P7SignedData) throws PKIException {
        CMSSignedDataParser sp = null;
        byte[] binaryTimeStamp = null;
        try {
            binaryTimeStamp = ASN1Parser.isBase64Compatability(base64P7SignedData) ? Base64.decode(ASN1Parser.deleteCRLF(base64P7SignedData)) : base64P7SignedData;
            sp = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), new ByteArrayInputStream(binaryTimeStamp));
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            String strSignDate = null;
            while (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                AttributeTable attributeTable = signer.getSignedAttributes();
                Attribute signTimeAttri = attributeTable.get(CMSAttributes.signingTime);
                Time time = Time.getInstance(signTimeAttri.getAttrValues().getObjectAt(0).toASN1Primitive());
                Date signTimeDate = time.getDate();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                strSignDate = format.format(signTimeDate);
            }
            sp.close();
            return strSignDate;
        }
        catch (Exception ex2) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), ex2);
        }
    }
}

