/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.SM2OIDUtil;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.sadk.org.bouncycastle.asn1.x509.CertificateList;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertList;
import cfca.sadk.org.bouncycastle.asn1.x509.Time;
import cfca.sadk.signature.rsa.RSASignUtil;
import cfca.sadk.signature.sm2.SM2SignUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.x509.certificate.CFCAStyle;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Date;

public class X509CRL {
    private CertificateList certList = null;
    private TBSCertList.CRLEntry[] crlEntries = null;

    public X509CRL(byte[] derCRL) throws PKIException {
        FilterInputStream dis = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(derCRL);
            dis = new ASN1InputStream(bis);
            ASN1Sequence seq = (ASN1Sequence)((ASN1InputStream)dis).readObject();
            this.certList = CertificateList.getInstance(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES, ex);
        }
        catch (Throwable th) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception e) {
                    throw new PKIException("X509CRL Decoded Failure", e);
                }
            }
        }
    }

    public X509CRL(CertificateList certList) {
        this.certList = certList;
        this.crlEntries = certList.getTBSCertList().getRevokedCertificates();
    }

    public X509CRL(String crlFilePath) throws PKIException {
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            fis = new FileInputStream(crlFilePath);
            dis = new ASN1InputStream(fis);
            ASN1Sequence seq = (ASN1Sequence)((ASN1InputStream)dis).readObject();
            this.certList = CertificateList.getInstance(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES, ex);
        }
        catch (Throwable th) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public X509CRL(InputStream crlInputStream) throws PKIException {
        ASN1InputStream dis = null;
        try {
            dis = new ASN1InputStream(crlInputStream);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.certList = CertificateList.getInstance(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
            crlInputStream.close();
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES, ex);
        }
        catch (Throwable th) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public CertificateList getCertificateList() {
        return this.certList;
    }

    public byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        try {
            encoded = ASN1Parser.parseDERObj2Bytes(this.certList);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.ENCODED_CRL, PKIException.ENCODED_CRL_DES, ex);
        }
        return encoded;
    }

    public String getIssuer() {
        X500Name x500IssuerName = this.certList.getIssuer();
        X500Name cfca_issuer = new X500Name(CFCAStyle.INSTANCE, x500IssuerName);
        return cfca_issuer.toString();
    }

    public String getIssuer(X500NameStyle style) {
        X500Name x500IssuerName = this.certList.getIssuer();
        X500Name cfca_issuer = new X500Name(style, x500IssuerName);
        return cfca_issuer.toString();
    }

    public Date getThisUpdate() {
        Time thisUpdate = this.certList.getThisUpdate();
        return thisUpdate.getDate();
    }

    public Date getNextUpdate() {
        Time nextUpdate = this.certList.getNextUpdate();
        if (nextUpdate == null) {
            return null;
        }
        return nextUpdate.getDate();
    }

    public byte[] getSignature() {
        DERBitString derBit = this.certList.getSignature();
        return derBit.getBytes();
    }

    public boolean isRevoke(String serialNumber) {
        if (this.crlEntries == null) {
            return false;
        }
        BigInteger sn = new BigInteger(serialNumber, 16);
        for (int i = 0; i < this.crlEntries.length; ++i) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (!sn.equals(tmpSN)) continue;
            return true;
        }
        return false;
    }

    public boolean isRevoke(BigInteger serialNumber) {
        if (this.crlEntries == null) {
            return false;
        }
        for (int i = 0; i < this.crlEntries.length; ++i) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (!serialNumber.equals(tmpSN)) continue;
            return true;
        }
        return false;
    }

    public boolean verify(PublicKey publicKey) throws PKIException {
        ASN1ObjectIdentifier oid = this.certList.getSignatureAlgorithm().getAlgorithm();
        if (SM2OIDUtil.isSm3WithSM2Encryption(oid)) {
            if (!"SM2".equalsIgnoreCase(publicKey.getAlgorithm())) {
                return false;
            }
            return SM2SignUtil.verify(this.getTBSCertList(), null, this.getSignature(), publicKey);
        }
        String digestAlgorithm = Mechanisms.getDigestAlgorithmName(oid);
        if (digestAlgorithm == null) {
            throw new PKIException(PKIException.NONSUPPORT_SIGALG, PKIException.NONSUPPORT_SIGALG_DES + ":" + oid.getId());
        }
        return RSASignUtil.verifySign(digestAlgorithm, publicKey, this.getTBSCertList(), this.getSignature());
    }

    public static boolean verify(String crlPath, String certPath) throws FileNotFoundException, IOException, PKIException {
        if (crlPath != null && !"".equals(crlPath)) {
            try {
                FileInputStream fisCRL = new FileInputStream(crlPath);
                X509CRL crl = new X509CRL(fisCRL);
                fisCRL.close();
                FileInputStream fisCert = new FileInputStream(certPath);
                X509Cert cert = new X509Cert(fisCert);
                fisCert.close();
                boolean result = crl.verify(cert.getPublicKey());
                return result;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (PKIException e) {
                throw e;
            }
        }
        return false;
    }

    public String getSignatureAlgName() {
        return Mechanism.getSignatureAlgName(this.certList.getSignatureAlgorithm());
    }

    public String getSignatureAlgOID() {
        return this.certList.getSignatureAlgorithm().getAlgorithm().getId();
    }

    public byte[] getTBSCertList() throws PKIException {
        byte[] bTBSCertList = null;
        try {
            bTBSCertList = ASN1Parser.parseDERObj2Bytes(this.certList.getTBSCertList().toASN1Primitive());
        }
        catch (Exception e) {
            throw new PKIException(PKIException.TBSCRL_BYTES, PKIException.TBSCRL_BYTES_DES, e);
        }
        return bTBSCertList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certList == null ? 0 : this.certList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509CRL other = (X509CRL)obj;
        return !(this.certList == null ? other.certList != null : !this.certList.equals(other.certList));
    }
}

