/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.em.group.e10groupid;

import com.alibaba.fastjson.JSON;
import com.weaver.em.group.e10groupid.E10GroupIdUtil;
import com.weaver.em.group.e10groupid.GroupBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E10GroupIdUThread
extends Thread {
    private static final Logger Log = LoggerFactory.getLogger(E10GroupIdUThread.class);
    private int groupCount = this.getGroupCount();

    @Override
    public void run() {
        int pageNumber = this.getStart();
        List<GroupBean> groupBeanList = null;
        int pageSize = 100;
        while ((groupBeanList = this.getGroupListBean(pageSize, pageNumber)) != null && !this.isEnd(pageSize, pageNumber)) {
            Log.info("tranGroupStart start.size :{} ", (Object)(pageNumber * pageSize));
            if (groupBeanList != null && groupBeanList.size() > 0) {
                this.updateGroupBean(groupBeanList);
            }
            JiveGlobals.setProperty((String)"updatee10groupIdPage", (String)String.valueOf(pageNumber));
            ++pageNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroupBean(List<GroupBean> groupBeanList) {
        Log.info("updateGroupBean :{} ", (Object)JSON.toJSONString(groupBeanList));
        for (GroupBean groupBean : groupBeanList) {
            String createTime = groupBean.getCreateTime();
            String groupName = groupBean.getGroupName();
            String e10GroupId = E10GroupIdUtil.getE10GroupId(createTime, groupName);
            groupBean.setE10groupid(e10GroupId);
        }
        Log.info("updateGroupBean :{} ", (Object)JSON.toJSONString(groupBeanList));
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" update ofgroup set e10groupid = ? where groupName= ? ");
            for (GroupBean groupBean : groupBeanList) {
                pstmt.setString(1, groupBean.getE10groupid());
                pstmt.setString(2, groupBean.getGroupName());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
        }
        catch (SQLException e) {
            try {
                Log.error("updateGroupBean ,error :{}", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GroupBean> getGroupListBean(int pageSize, int pageNumber) {
        ArrayList<GroupBean> result = new ArrayList<GroupBean>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(this.getSQL(pageNumber, pageSize));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                GroupBean h = new GroupBean();
                String groupName = rs.getString("groupName");
                h.setGroupName(groupName);
                h.setCreateTime(rs.getString("createTime"));
                result.add(h);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getGroupListBean ,error :{} ,pageNumber :{} ,pageSize:{} ,e :{}", new Object[]{e.getMessage(), pageNumber, pageSize, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        Log.info("--------getGroupListBean ------ pageNumber :{} ,pageSize :{} ,result :{}  ", new Object[]{pageNumber, pageSize, result});
        return result;
    }

    private String getSQL(int pageNumber, int pageSize) {
        String sql = "  SELECT groupName,createUser,createTime FROM ofGroup ORDER BY groupName ";
        String sqlByPage = "";
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = " select ROW_NUMBER() OVER(ORDER BY groupName ) AS rn,groupName,createUser,createTime FROM ofGroup  ";
            sqlByPage = " SELECT * FROM (" + sql + ") AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sqlByPage = " SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
        } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
        } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
        }
        return sqlByPage;
    }

    private int getStart() {
        int start = JiveGlobals.getIntProperty((String)"updatee10groupIdPage", (int)0);
        return start;
    }

    private boolean isEnd(int pageSize, int pageNumber) {
        if ((pageSize - 1) * pageNumber >= this.groupCount) {
            JiveGlobals.setProperty((String)"updatee10groupIdPageEnd", (String)"true");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getGroupCount() {
        int groupCount = 0;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select count(1) as groupCount from ofgroup ");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupCount = rs.getInt("groupCount");
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getGroupCount ,error :{} ,e :{}", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return groupCount;
    }
}

