/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.em.group.e10groupid;

import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jivesoftware.util.JiveGlobals;

public class E10GroupIdUtil {
    private static final String E10_PROP = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "E10update.properties";
    private static int E10TeamId = 0;
    private static Map<Long, Long> idMap = new HashMap<Long, Long>();

    private static String getStamp(String createTime) {
        String value = String.valueOf(System.currentTimeMillis() / 1000L);
        if (createTime != null && createTime.isEmpty() && createTime.length() >= 10) {
            value = createTime.substring(0, 10);
        }
        return value;
    }

    public static String getE10GroupId(String createTime, String groupName) {
        String e9gid = groupName;
        long id = 0L;
        String dateTime = "1672502400000";
        try {
            BigInteger e9GidBigInt = new BigInteger(e9gid.replaceAll("-", ""), 16);
            BigInteger e9gidD = new BigInteger("10000000000000000");
            BigInteger[] e9GidDr = e9GidBigInt.divideAndRemainder(e9gidD);
            id = e9GidDr[1].longValue();
        }
        catch (Exception e9GidBigInt) {
            // empty catch block
        }
        long e10groupId = 0L;
        try {
            if (id == 0L) {
                id = E10GroupIdUtil.getId(e9gid);
                if (createTime != null && !createTime.isEmpty()) {
                    dateTime = createTime;
                }
                e10groupId = E10GroupIdUtil.MakeIdSec(E10TeamId, Long.parseLong(dateTime) / 1000L, id);
            } else {
                e10groupId = E10GroupIdUtil.makeGroupid(E10TeamId, Long.parseLong(dateTime) / 1000L, id);
            }
        }
        catch (Exception e) {
            return null;
        }
        return String.valueOf(e10groupId);
    }

    public static long MakeIdSec(int serverId, long tm, long inc) {
        if (serverId < 1) {
            serverId = 1;
        }
        if (serverId > 9999) {
            serverId = serverId % 9999 + 1;
        }
        if (tm < 1L) {
            tm = System.currentTimeMillis() / 1000L;
        }
        if (idMap.get(tm) != null) {
            inc = idMap.get(tm) + 1L;
            idMap.put(tm, inc);
        } else if ((inc %= 10000L) == 9999L) {
            idMap.put(tm, inc);
        }
        return tm * 1000000000L + (long)(serverId * 100000) + inc;
    }

    public static long makeGroupid(int serverId, long tm, long inc) {
        if (serverId < 1) {
            serverId = 1;
        }
        if (serverId > 9999) {
            serverId = serverId % 9999 + 1;
        }
        if (tm < 1L) {
            tm = System.currentTimeMillis() / 1000L;
        }
        return tm * 1000000000L + inc;
    }

    public static void main(String[] args) {
        System.out.println(E10GroupIdUtil.getE10GroupId(null, "75225dea-bf74-452f-91e5-76a88957cdae"));
    }

    private static long getId(String UUID) {
        Integer userId = UUID.toString().hashCode();
        userId = userId < 0 ? -userId.intValue() : userId;
        return userId.intValue();
    }

    public static boolean needUpdateE10GroupId() {
        int teamId;
        return !JiveGlobals.getBooleanProperty((String)"updatee10groupIdPageEnd", (boolean)false) && (teamId = E10GroupIdUtil.getTeamId()) != 0;
    }

    public static int getTeamId() {
        if (E10TeamId == 0) {
            return E10TeamId;
        }
        Properties properties = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(E10_PROP);
            properties.load(is);
            String etidStr = properties.getProperty("E10TeamId");
            if (etidStr != null && !etidStr.isEmpty()) {
                E10TeamId = Integer.parseInt(etidStr);
            }
        }
        catch (Exception e) {
            return 0;
        }
        return E10TeamId;
    }
}

