/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.emobile.groupinviter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weaver.emobile.groupinviter.GroupInviterUtil;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class GroupInviterIQHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(GroupInviterIQHandler.class);
    private String namespace = "http://weaver.com.cn/group/inviter";
    private IQHandlerInfo info = new IQHandlerInfo("query", this.namespace);

    public GroupInviterIQHandler() {
        super("GroupInviterIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        JID fromJID = packet.getFrom();
        if (fromJID == null) {
            Log.debug("invalid iq request, from is null, id:{}", (Object)packet.getID());
            return null;
        }
        long startTime = System.currentTimeMillis();
        String username = fromJID.getNode();
        Map<String, Object> result = new HashMap<String, String>();
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        String data = packet.getElement().elementText("query");
        JSONObject json = JSON.parseObject((String)data);
        if (IQ.Type.get.equals((Object)packet.getType())) {
            String method = null;
            if (json != null && json.containsKey((Object)"method")) {
                method = json.getString("method");
            }
            int pageSize = 10;
            if (json != null && json.containsKey((Object)"pageSize")) {
                pageSize = json.getIntValue("pageSize");
            }
            int pageNumber = 1;
            if (json != null && json.containsKey((Object)"pageNumber")) {
                pageNumber = json.getIntValue("pageNumber");
            }
            if ("getAll".equals(method)) {
                int orderBy = 1;
                if (json != null && json.containsKey((Object)"orderBy")) {
                    orderBy = json.getIntValue("orderBy");
                }
                GroupInviterUtil groupInviterUtil = GroupInviterUtil.getInstance();
                result = groupInviterUtil.getGetAll(username, pageSize, pageNumber, orderBy);
            } else if ("getReceive".equals(method)) {
                int orderBy = 1;
                if (json != null && json.containsKey((Object)"orderBy")) {
                    orderBy = json.getIntValue("orderBy");
                }
                GroupInviterUtil groupInviterUtil = GroupInviterUtil.getInstance();
                result = groupInviterUtil.getGetReceive(username, pageSize, pageNumber, orderBy);
            } else if ("getReceiveAndUntreated".equals(method)) {
                int orderBy = 1;
                if (json != null && json.containsKey((Object)"orderBy")) {
                    orderBy = json.getIntValue("orderBy");
                }
                GroupInviterUtil groupInviterUtil = GroupInviterUtil.getInstance();
                result = groupInviterUtil.getReceiveAndUntreated(username, pageSize, pageNumber, orderBy);
            } else if ("getInviterAndUntreated".equals(method)) {
                int orderBy = 1;
                if (json != null && json.containsKey((Object)"orderBy")) {
                    orderBy = json.getIntValue("orderBy");
                }
                GroupInviterUtil groupInviterUtil = GroupInviterUtil.getInstance();
                result = groupInviterUtil.getInviterAndUntreated(username, pageSize, pageNumber, orderBy);
            } else if ("getInviter".equals(method)) {
                int orderBy = 1;
                if (json != null && json.containsKey((Object)"orderBy")) {
                    orderBy = json.getIntValue("orderBy");
                }
                GroupInviterUtil groupInviterUtil = GroupInviterUtil.getInstance();
                result = groupInviterUtil.getInviter(username, pageSize, pageNumber, orderBy);
            }
        } else if (IQ.Type.set.equals((Object)packet.getType())) {
            String status = "1";
            if (json != null && json.containsKey((Object)"status")) {
                status = json.getString("status");
            }
            String groupId = "";
            if (json != null && json.containsKey((Object)"groupId")) {
                groupId = json.getString("groupId");
            }
            String inviter = "";
            if (json != null && json.containsKey((Object)"inviter")) {
                inviter = json.getString("inviter");
            }
            String userId = "";
            if (json != null && json.containsKey((Object)"userId")) {
                userId = json.getString("userId");
            }
            if (groupId != null && inviter != null && !groupId.isEmpty() && !inviter.isEmpty()) {
                GroupInviterUtil groupInviterUtil = GroupInviterUtil.getInstance();
                int code = groupInviterUtil.processInviter(username, status, groupId, inviter, userId);
                result.put("code", (String)((Object)Integer.valueOf(code)));
            } else {
                result.put("errmsg", "\u53c2\u6570\u4e0d\u6b63\u786e");
                result.put("code", (String)((Object)Integer.valueOf(403)));
            }
        }
        ele.addText(JSON.toJSONString(result).toString());
        long endTime = System.currentTimeMillis();
        Log.info("GroupInviterIQHandler.success:fromUserId:{},params:{},result:{},cost:{} ms", new Object[]{fromJID, json, JSON.toJSONString(result).toString(), endTime - startTime});
        return reply;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

