/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.emobile.groupinviter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.weaver.emobile.groupinviter.ConversationUtil;
import com.weaver.util.ServerInfo;
import com.weaver.util.ThreadPoolFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class GroupInviterUtil {
    private static final Logger Log = LoggerFactory.getLogger(GroupInviterUtil.class);
    private static final String configFilePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "GroupInviter.properties";
    private boolean groupInviterEnable = false;
    private int groupMemberSize = 0;
    private static GroupInviterUtil instance = null;

    public static GroupInviterUtil getInstance() {
        if (instance == null) {
            instance = new GroupInviterUtil();
        }
        return instance;
    }

    private GroupInviterUtil() {
        this.loadGroupInviterConfig();
        Log.info("GroupInviterUtil,groupInviterEnable:{},groupMemberSize:{}", (Object)this.groupInviterEnable, (Object)this.groupMemberSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInviterStatus(String userId, String groupId, String inviter) {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            stmt = con.prepareStatement("select status from ofgroupInvitationInfo where groupId = ? and inviter = ? and needProcess = ? and status in ('0','4','5')");
            stmt.setString(1, groupId);
            stmt.setString(2, inviter);
            stmt.setString(3, userId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                String status;
                String string = status = rs.getString("status");
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)stmt, (Connection)con);
                return string;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)stmt, (Connection)con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)stmt, (Connection)con);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int processInviter(String opeartor, String status, String groupId, String inviter, String userId) {
        int result = 200;
        if ("1".equals(status)) {
            boolean isJoinGroup = false;
            String statusIn = this.getInviterStatus(opeartor, groupId, inviter);
            if ("0".equals(statusIn)) {
                isJoinGroup = true;
                this.updateInviterStatus(status, inviter, groupId, userId, opeartor);
            } else {
                if ("4".equals(statusIn)) {
                    isJoinGroup = false;
                    boolean isGroupAdminOrManager = this.checkUserIsAdminOrManager(groupId, opeartor);
                    if (isGroupAdminOrManager) {
                        ArrayList<String> userIds = new ArrayList<String>();
                        userIds.add(userId);
                        this.updateInviterStatus("6", inviter, groupId, userId);
                        this.updateInviterStatus(status, inviter, groupId, userId, opeartor);
                        this.saveInvitationInfo(inviter, userIds, groupId, userIds, true, "0");
                        return 200;
                    }
                    this.updateInviterStatus("-1", inviter, groupId, userId, opeartor);
                    Log.error("updateInviterStatus : \u9080\u8bf7\u4eba\u4e0d\u662f\u7fa4\u4e3b\u6216\u8005\u7ba1\u7406\u5458 ,userId:{}", (Object)userId);
                    return 404;
                }
                if (!"5".equals(statusIn)) return 404;
                isJoinGroup = false;
                boolean isGroupAdminOrManager = this.checkUserIsAdminOrManager(groupId, opeartor);
                if (isGroupAdminOrManager) {
                    isJoinGroup = true;
                    this.updateInviterStatus("6", inviter, groupId, userId);
                    this.updateInviterStatus(status, inviter, groupId, userId, opeartor);
                } else {
                    this.updateInviterStatus("-1", inviter, groupId, userId, opeartor);
                    Log.error("updateInviterStatus : \u9080\u8bf7\u4eba\u4e0d\u662f\u7fa4\u4e3b\u6216\u8005\u7ba1\u7406\u5458 ,userId:{}", (Object)userId);
                    return 404;
                }
            }
            try {
                if ("0".equals(statusIn) && (userId == null || userId.isEmpty())) {
                    userId = opeartor;
                }
                Group group = GroupManager.getInstance().getGroup(groupId);
                boolean userIsGroupMember = false;
                Collection members = group.getAll();
                for (JID jid : members) {
                    if (!jid.getNode().equalsIgnoreCase(inviter)) continue;
                    userIsGroupMember = true;
                }
                User user = UserManager.getInstance().getUser(inviter);
                User name = UserManager.getInstance().getUser(userId);
                String operaName = UsernameUtil.getUserName(userId, user.getName());
                String userNames = UsernameUtil.getUserName(userId, name.getName());
                if (!userIsGroupMember) {
                    return 404;
                }
                group.getMembers().add(new JID(userId, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                String invite = LocaleUtils.getLocalizedString((String)"group.iq.invite", (String)"group");
                String invitePerson = LocaleUtils.getLocalizedString((String)"group.iq.invite.person", (String)"group");
                String content = operaName + invite + userNames + invitePerson;
                final User usertemp = user;
                final String extensiontemp = userId;
                String failedExtensionFinal = "";
                final Group grouptemp = group;
                final String finalContent = content;
                ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        Message infoMessage = new Message();
                        infoMessage.setID(StringUtils.randomString((int)8));
                        infoMessage.setType(Message.Type.chat);
                        infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                        infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                        DizMessage diz = new DizMessage(1, usertemp.getUID(), extensiontemp, "");
                        diz.setContent(finalContent);
                        infoMessage.setBody(diz.toString());
                        Log.info("createGroup,infoMessage:{}", (Object)infoMessage.toString());
                        GroupPlugin.groupPlugin.sendMessage(infoMessage);
                    }
                });
                return result;
            }
            catch (Exception e) {
                Log.error("updateInviterStatus : \u5904\u7406\u5f02\u5e38 ,userId:{},error :{} ", (Object)userId, (Object)e.getMessage());
                return 500;
            }
        } else {
            if (!"2".equals(status)) return result;
            String statusIn = this.getInviterStatus(opeartor, groupId, inviter);
            if ("0".equals(statusIn)) {
                this.updateInviterStatus(status, inviter, groupId, userId, opeartor);
                return result;
            } else {
                if (!"4".equals(statusIn) && !"5".equals(statusIn)) return 404;
                boolean isGroupAdminOrManager = this.checkUserIsAdminOrManager(groupId, opeartor);
                if (isGroupAdminOrManager) {
                    ArrayList<String> userIds = new ArrayList<String>();
                    userIds.add(userId);
                    this.updateInviterStatus("7", inviter, groupId, userId);
                    this.updateInviterStatus(status, inviter, groupId, userId, opeartor);
                    return 200;
                }
                this.updateInviterStatus("-1", inviter, groupId, userId, opeartor);
                Log.error("updateInviterStatus : \u9080\u8bf7\u4eba\u4e0d\u662f\u7fa4\u4e3b\u6216\u8005\u7ba1\u7406\u5458 ,userId:{}", (Object)userId);
                return 404;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getInviter(String userId, int pageSize, int pageNumber, int orderBy) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int totalCount = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String sqlBack = " inviter,groupId,createDate,status,userid,needProcess ";
            String sqlFrom = " ofgroupInvitationInfo ";
            String sqlWhere = " inviter = ? ";
            String sqlOrderBy = "";
            sqlOrderBy = orderBy == 0 ? " order by createDate desc " : " order by createDate ";
            String sqlCount = "select Count(1) as totalCount from " + sqlFrom + " where " + sqlWhere;
            String sql = "SELECT " + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + sqlOrderBy;
            String sqlByPage = "";
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = "SELECT  * FROM (SELECT ROW_NUMBER() OVER(" + sqlOrderBy + ")AS rn," + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + ")AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
            } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
            }
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sqlCount);
            pstmt.setString(1, userId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                totalCount = rs.getInt("totalCount");
                result.put("totalCount", totalCount);
                result.put("pageSize", pageSize);
                result.put("pageNumber", pageNumber);
            }
            if (totalCount > 0) {
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(sqlByPage);
                pstmt.setString(1, userId);
                rs = pstmt.executeQuery();
                ArrayList inviterDataList = new ArrayList();
                GroupManager groupManager = GroupManager.getInstance();
                while (rs.next()) {
                    HashMap<String, Object> inviterData = new HashMap<String, Object>();
                    String inviter = rs.getString("inviter");
                    String groupId = rs.getString("groupId");
                    String createDate = rs.getString("createDate");
                    String status = rs.getString("status");
                    String userid = rs.getString("userid");
                    String needProcess = rs.getString("needProcess");
                    try {
                        String groupIconUrl;
                        PersistableMap groupProp;
                        int groupMemberSize;
                        String groupName;
                        Group group = groupManager.getGroup(groupId);
                        boolean userIsGroupMember = false;
                        Collection members = group.getAll();
                        for (JID jid : members) {
                            if (!jid.getNode().equalsIgnoreCase(inviter)) continue;
                            userIsGroupMember = true;
                            break;
                        }
                        if (userIsGroupMember) {
                            groupName = group.getDescription();
                            groupMemberSize = members.size();
                            groupProp = group.getProperties();
                            groupIconUrl = "";
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            inviterData.put("inviter", inviter);
                            inviterData.put("groupName", groupName);
                            inviterData.put("groupId", groupId);
                            inviterData.put("createDate", createDate);
                            inviterData.put("groupMemberSize", groupMemberSize);
                            inviterData.put("groupIconUrl", groupIconUrl);
                            inviterData.put("status", status);
                            inviterData.put("userId", userid);
                            inviterData.put("needProcess", needProcess);
                        } else {
                            Log.info(" getInviter groupId :{} ,inviter :{} ,userId :{} ", new Object[]{groupId, inviter, userId});
                            this.updateInviterStatus("-1", inviter, groupId, userId);
                            groupName = group.getDescription();
                            groupMemberSize = members.size();
                            groupProp = group.getProperties();
                            groupIconUrl = "";
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            inviterData.put("inviter", inviter);
                            inviterData.put("groupName", groupName);
                            inviterData.put("groupId", groupId);
                            inviterData.put("createDate", createDate);
                            inviterData.put("groupMemberSize", groupMemberSize);
                            inviterData.put("groupIconUrl", groupIconUrl);
                            inviterData.put("userId", userid);
                            inviterData.put("status", "-1");
                            inviterData.put("needProcess", needProcess);
                        }
                        inviterDataList.add(inviterData);
                    }
                    catch (Exception e) {
                        Log.error("getInviter,error :{} groupId :{} ,inviter :{} ,userId :{} ", new Object[]{e.getMessage(), groupId, inviter, userId});
                    }
                }
                result.put("inviterData", inviterDataList);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("getInviter error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getInviterAndUntreated(String userId, int pageSize, int pageNumber, int orderBy) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int totalCount = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String sqlBack = " inviter,groupId,createDate,status,userid ";
            String sqlFrom = " ofgroupInvitationInfo ";
            String sqlWhere = " inviter = ? and status in ('0','4','5') ";
            String sqlOrderBy = "";
            sqlOrderBy = orderBy == 0 ? " order by createDate desc " : " order by createDate ";
            String sqlCount = "select Count(1) as totalCount from " + sqlFrom + " where " + sqlWhere;
            String sql = "SELECT " + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + sqlOrderBy;
            String sqlByPage = "";
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = "SELECT  * FROM (SELECT ROW_NUMBER() OVER(" + sqlOrderBy + ")AS rn," + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + ")AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
            } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
            }
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sqlCount);
            pstmt.setString(1, userId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                totalCount = rs.getInt("totalCount");
                result.put("totalCount", totalCount);
                result.put("pageSize", pageSize);
                result.put("pageNumber", pageNumber);
            }
            if (totalCount > 0) {
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(sqlByPage);
                pstmt.setString(1, userId);
                rs = pstmt.executeQuery();
                ArrayList inviterDataList = new ArrayList();
                GroupManager groupManager = GroupManager.getInstance();
                while (rs.next()) {
                    HashMap<String, Object> inviterData = new HashMap<String, Object>();
                    String inviter = rs.getString("inviter");
                    String groupId = rs.getString("groupId");
                    String createDate = rs.getString("createDate");
                    String status = rs.getString("status");
                    String userid = rs.getString("userid");
                    try {
                        String groupIconUrl;
                        PersistableMap groupProp;
                        int groupMemberSize;
                        String groupName;
                        Group group = groupManager.getGroup(groupId);
                        boolean userIsGroupMember = false;
                        Collection members = group.getAll();
                        for (JID jid : members) {
                            if (!jid.getNode().equalsIgnoreCase(inviter)) continue;
                            userIsGroupMember = true;
                        }
                        if (userIsGroupMember) {
                            groupName = group.getDescription();
                            groupMemberSize = members.size();
                            groupProp = group.getProperties();
                            groupIconUrl = "";
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            inviterData.put("inviter", inviter);
                            inviterData.put("groupName", groupName);
                            inviterData.put("groupId", groupId);
                            inviterData.put("createDate", createDate);
                            inviterData.put("groupMemberSize", groupMemberSize);
                            inviterData.put("groupIconUrl", groupIconUrl);
                            inviterData.put("status", status);
                            inviterData.put("userId", userid);
                        } else {
                            this.updateInviterStatus("-1", inviter, groupId, userId);
                            groupName = group.getDescription();
                            groupMemberSize = members.size();
                            groupProp = group.getProperties();
                            groupIconUrl = "";
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            inviterData.put("inviter", inviter);
                            inviterData.put("groupName", groupName);
                            inviterData.put("groupId", groupId);
                            inviterData.put("createDate", createDate);
                            inviterData.put("groupMemberSize", groupMemberSize);
                            inviterData.put("groupIconUrl", groupIconUrl);
                            inviterData.put("status", -1);
                            inviterData.put("userId", userid);
                        }
                        inviterDataList.add(inviterData);
                    }
                    catch (Exception exception) {}
                }
                result.put("inviterData", inviterDataList);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("getInviterAndUntreated error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getReceiveAndUntreated(String userId, int pageSize, int pageNumber, int orderBy) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int totalCount = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String sqlBack = " inviter,groupId,createDate,status,userid ";
            String sqlFrom = " ofgroupInvitationInfo ";
            String sqlWhere = " needProcess = ? and status in ('0','4','5') ";
            String sqlOrderBy = "";
            sqlOrderBy = orderBy == 0 ? " order by createDate desc " : " order by createDate ";
            String sqlCount = "select Count(1) as totalCount from " + sqlFrom + " where " + sqlWhere;
            String sql = "SELECT " + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + sqlOrderBy;
            String sqlByPage = "";
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = "SELECT  * FROM (SELECT ROW_NUMBER() OVER(" + sqlOrderBy + ")AS rn," + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + ")AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
            } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
            }
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sqlCount);
            pstmt.setString(1, userId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                totalCount = rs.getInt("totalCount");
                result.put("totalCount", totalCount);
                result.put("pageSize", pageSize);
                result.put("pageNumber", pageNumber);
            }
            if (totalCount > 0) {
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(sqlByPage);
                pstmt.setString(1, userId);
                rs = pstmt.executeQuery();
                ArrayList inviterDataList = new ArrayList();
                GroupManager groupManager = GroupManager.getInstance();
                while (rs.next()) {
                    HashMap<String, Object> inviterData = new HashMap<String, Object>();
                    String inviter = rs.getString("inviter");
                    String groupId = rs.getString("groupId");
                    String createDate = rs.getString("createDate");
                    String status = rs.getString("status");
                    String userid = rs.getString("userid");
                    try {
                        String groupIconUrl;
                        PersistableMap groupProp;
                        int groupMemberSize;
                        String groupName;
                        Group group = groupManager.getGroup(groupId);
                        boolean userIsGroupMember = false;
                        Collection members = group.getAll();
                        for (JID jid : members) {
                            if (!jid.getNode().equalsIgnoreCase(inviter)) continue;
                            userIsGroupMember = true;
                        }
                        if (userIsGroupMember) {
                            groupName = group.getDescription();
                            groupMemberSize = members.size();
                            groupProp = group.getProperties();
                            groupIconUrl = "";
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            inviterData.put("inviter", inviter);
                            inviterData.put("groupName", groupName);
                            inviterData.put("groupId", groupId);
                            inviterData.put("createDate", createDate);
                            inviterData.put("groupMemberSize", groupMemberSize);
                            inviterData.put("groupIconUrl", groupIconUrl);
                            inviterData.put("status", status);
                            inviterData.put("userId", userid);
                        } else {
                            this.updateInviterStatus("-1", inviter, groupId, userId);
                            groupName = group.getDescription();
                            groupMemberSize = members.size();
                            groupProp = group.getProperties();
                            groupIconUrl = "";
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            inviterData.put("inviter", inviter);
                            inviterData.put("groupName", groupName);
                            inviterData.put("groupId", groupId);
                            inviterData.put("createDate", createDate);
                            inviterData.put("groupMemberSize", groupMemberSize);
                            inviterData.put("groupIconUrl", groupIconUrl);
                            inviterData.put("status", -1);
                            inviterData.put("userId", userid);
                        }
                        inviterDataList.add(inviterData);
                    }
                    catch (Exception exception) {}
                }
                result.put("inviterData", inviterDataList);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("getReceiveAndUntreated error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getGetReceive(String userId, int pageSize, int pageNumber, int orderBy) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int totalCount = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String sqlBack = " inviter,groupId,createDate,status,userid,needProcess ";
            String sqlFrom = " ofgroupInvitationInfo ";
            String sqlWhere = " needProcess = ? ";
            String sqlOrderBy = "";
            sqlOrderBy = orderBy == 0 ? " order by createDate desc " : " order by createDate ";
            String sqlCount = "select Count(1) as totalCount from " + sqlFrom + " where " + sqlWhere;
            String sql = "SELECT " + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + sqlOrderBy;
            String sqlByPage = "";
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = "SELECT  * FROM (SELECT ROW_NUMBER() OVER(" + sqlOrderBy + ")AS rn," + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + ")AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
            } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
            }
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sqlCount);
            pstmt.setString(1, userId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                totalCount = rs.getInt("totalCount");
                result.put("totalCount", totalCount);
                result.put("pageSize", pageSize);
                result.put("pageNumber", pageNumber);
            }
            if (totalCount > 0) {
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(sqlByPage);
                pstmt.setString(1, userId);
                rs = pstmt.executeQuery();
                ArrayList inviterDataList = new ArrayList();
                GroupManager groupManager = GroupManager.getInstance();
                while (rs.next()) {
                    HashMap<String, Object> inviterData = new HashMap<String, Object>();
                    String inviter = rs.getString("inviter");
                    String groupId = rs.getString("groupId");
                    String createDate = rs.getString("createDate");
                    String status = rs.getString("status");
                    String userid = rs.getString("userid");
                    String needProcess = rs.getString("needProcess");
                    try {
                        String groupIconUrl;
                        PersistableMap groupProp;
                        int groupMemberSize;
                        String groupName;
                        Group group = groupManager.getGroup(groupId);
                        boolean userIsGroupMember = false;
                        Collection members = group.getAll();
                        for (JID jid : members) {
                            if (!jid.getNode().equalsIgnoreCase(inviter)) continue;
                            userIsGroupMember = true;
                            break;
                        }
                        if (userIsGroupMember) {
                            groupName = group.getDescription();
                            groupMemberSize = members.size();
                            groupProp = group.getProperties();
                            groupIconUrl = "";
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            inviterData.put("inviter", inviter);
                            inviterData.put("groupName", groupName);
                            inviterData.put("groupId", groupId);
                            inviterData.put("createDate", createDate);
                            inviterData.put("groupMemberSize", groupMemberSize);
                            inviterData.put("groupIconUrl", groupIconUrl);
                            inviterData.put("status", status);
                            inviterData.put("userId", userid);
                            inviterData.put("needProcess", needProcess);
                        } else {
                            Log.info(" getGetReceive groupId :{} ,inviter :{} ,userId :{} ", new Object[]{groupId, inviter, userId});
                            this.updateInviterStatus("-1", inviter, groupId, userId);
                            groupName = group.getDescription();
                            groupMemberSize = members.size();
                            groupProp = group.getProperties();
                            groupIconUrl = "";
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            inviterData.put("inviter", inviter);
                            inviterData.put("groupName", groupName);
                            inviterData.put("groupId", groupId);
                            inviterData.put("createDate", createDate);
                            inviterData.put("groupMemberSize", groupMemberSize);
                            inviterData.put("groupIconUrl", groupIconUrl);
                            inviterData.put("userId", userid);
                            inviterData.put("status", -1);
                            inviterData.put("needProcess", needProcess);
                        }
                        inviterDataList.add(inviterData);
                    }
                    catch (Exception e) {
                        Log.error("getGetReceive error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
                    }
                }
                result.put("inviterData", inviterDataList);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("getGetReceive getGetReceive :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getGetAll(String userId, int pageSize, int pageNumber, int orderBy) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int totalCount = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String sqlBack = " inviter,groupId,createDate,status,userid ";
            String sqlFrom = " ofgroupInvitationInfo ";
            String sqlWhere = " userid = ? or needProcess = ?  ";
            String sqlOrderBy = "";
            sqlOrderBy = orderBy == 0 ? " order by createDate desc " : " order by createDate ";
            String sqlCount = "select Count(1) as totalCount from " + sqlFrom + " where " + sqlWhere;
            String sql = "SELECT " + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + sqlOrderBy;
            String sqlByPage = "";
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = "SELECT  * FROM (SELECT ROW_NUMBER() OVER(" + sqlOrderBy + ")AS rn," + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + ")AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
            } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
            }
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sqlCount);
            pstmt.setString(1, userId);
            pstmt.setString(2, userId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                totalCount = rs.getInt("totalCount");
                result.put("totalCount", totalCount);
                result.put("pageSize", pageSize);
                result.put("pageNumber", pageNumber);
            }
            if (totalCount > 0) {
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                pstmt = con.prepareStatement(sqlByPage);
                pstmt.setString(1, userId);
                pstmt.setString(2, userId);
                rs = pstmt.executeQuery();
                ArrayList inviterDataList = new ArrayList();
                GroupManager groupManager = GroupManager.getInstance();
                while (rs.next()) {
                    HashMap<String, Object> inviterData = new HashMap<String, Object>();
                    String inviter = rs.getString("inviter");
                    String groupId = rs.getString("groupId");
                    String createDate = rs.getString("createDate");
                    String status = rs.getString("status");
                    String userid = rs.getString("userid");
                    try {
                        String groupIconUrl;
                        PersistableMap groupProp;
                        int groupMemberSize;
                        String groupName;
                        Group group = groupManager.getGroup(groupId);
                        boolean userIsGroupMember = false;
                        Collection members = group.getAll();
                        for (JID jid : members) {
                            if (!jid.getNode().equalsIgnoreCase(inviter)) continue;
                            userIsGroupMember = true;
                        }
                        if (userIsGroupMember) {
                            groupName = group.getDescription();
                            groupMemberSize = members.size();
                            groupProp = group.getProperties();
                            groupIconUrl = "";
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            inviterData.put("inviter", inviter);
                            inviterData.put("groupName", groupName);
                            inviterData.put("groupId", groupId);
                            inviterData.put("createDate", createDate);
                            inviterData.put("groupMemberSize", groupMemberSize);
                            inviterData.put("groupIconUrl", groupIconUrl);
                            inviterData.put("status", status);
                            inviterData.put("userId", userid);
                        } else {
                            this.updateInviterStatus("-1", inviter, groupId, userId);
                            groupName = group.getDescription();
                            groupMemberSize = members.size();
                            groupProp = group.getProperties();
                            groupIconUrl = "";
                            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                            }
                            inviterData.put("inviter", inviter);
                            inviterData.put("groupName", groupName);
                            inviterData.put("groupId", groupId);
                            inviterData.put("createDate", createDate);
                            inviterData.put("groupMemberSize", groupMemberSize);
                            inviterData.put("groupIconUrl", groupIconUrl);
                            inviterData.put("status", -1);
                            inviterData.put("userId", userid);
                        }
                        inviterDataList.add(inviterData);
                    }
                    catch (Exception exception) {}
                }
                result.put("inviterData", inviterDataList);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("getAll error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInviterStatus(String status, String inviter, String groupId, String userId, String needProcess) {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = DbConnectionManager.getConnection();
            String sqlUpdate = " update ofgroupInvitationInfo set status = ? where userId = ? and inviter = ? and groupId = ? and needProcess =? ";
            stmt = con.prepareStatement(sqlUpdate);
            stmt.setString(1, status);
            stmt.setString(2, userId);
            stmt.setString(3, inviter);
            stmt.setString(4, groupId);
            stmt.setString(5, needProcess);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("updateInviterStatus , error :{} ,inviter :{} ,userId :{} ,status :{} ,groupId :{} ,e :{} ", new Object[]{e.getMessage(), inviter, userId, groupId, status, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(stmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)stmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)stmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInviterStatus(String status, String inviter, String groupId, String userId) {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = DbConnectionManager.getConnection();
            String sqlUpdate = " update ofgroupInvitationInfo set status = ? where userId = ? and inviter = ? and groupId = ? ";
            stmt = con.prepareStatement(sqlUpdate);
            stmt.setString(1, status);
            stmt.setString(2, userId);
            stmt.setString(3, inviter);
            stmt.setString(4, groupId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("updateInviterStatus , error :{} ,inviter :{} ,userId :{} ,status :{} ,groupId :{} ,e :{} ", new Object[]{e.getMessage(), inviter, userId, groupId, status, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(stmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)stmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)stmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInvitationInfo(String inviter, List<String> userIds, String groupId, List<String> processUserList, boolean proc, String status) {
        Log.info("saveInvitationInfo ,inviter :{} ,userIds:{},groupId:{},processUserList:{},proc:{},status:{}", new Object[]{inviter, userIds, groupId, processUserList, proc, status});
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = DbConnectionManager.getConnection();
            stmt = con.prepareStatement("insert into ofgroupInvitationInfo (inviter,userId,groupId,status,createDate,needProcess) values (?,?,?,?,?,?)");
            if (proc) {
                for (String userId : userIds) {
                    stmt.setString(1, inviter);
                    stmt.setString(2, userId);
                    stmt.setString(3, groupId);
                    stmt.setString(4, status);
                    stmt.setString(5, String.valueOf(System.currentTimeMillis()));
                    stmt.setString(6, userId);
                    stmt.addBatch();
                }
            } else {
                for (String userId : userIds) {
                    for (String needProcess : processUserList) {
                        stmt.setString(1, inviter);
                        stmt.setString(2, userId);
                        stmt.setString(3, groupId);
                        stmt.setString(4, status);
                        stmt.setString(5, String.valueOf(System.currentTimeMillis()));
                        stmt.setString(6, needProcess);
                        stmt.addBatch();
                    }
                }
            }
            stmt.executeBatch();
            stmt.clearBatch();
        }
        catch (SQLException e) {
            try {
                Log.error("saveInvitationInfo , error :{} ,inviter :{} ,userIds :{} ,groupId :{} ,e :{} ", new Object[]{e.getMessage(), inviter, userIds, groupId, e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(stmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)stmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)stmt, (Connection)con);
        this.sendMessage(inviter, userIds, groupId, processUserList, proc);
    }

    public List<String> getAdminOrManager(String groupId) {
        ArrayList<String> isGroupAdminOrManager = new ArrayList<String>();
        try {
            String groupManagers;
            Group group = GroupManager.getInstance().getGroup(groupId);
            Collection admins = group.getAdmins();
            for (JID jid : admins) {
                isGroupAdminOrManager.add(jid.getNode());
            }
            PersistableMap groupProp = group.getProperties();
            if (groupProp != null && groupProp.containsKey((Object)"groupManagers") && (groupManagers = (String)groupProp.get((Object)"groupManagers")) != null && !groupManagers.isEmpty()) {
                JSONArray groupManager = JSONArray.parseArray((String)groupManagers);
                for (int i = 0; i < groupManager.size(); ++i) {
                    String s = groupManager.getString(i).toLowerCase();
                    isGroupAdminOrManager.add(s);
                }
            }
        }
        catch (GroupNotFoundException e) {
            e.printStackTrace();
        }
        return isGroupAdminOrManager;
    }

    public boolean checkUserIsAdminOrManager(String groupId, String node) {
        boolean isGroupAdminOrManager;
        block4: {
            isGroupAdminOrManager = false;
            try {
                String groupManagers;
                PersistableMap groupProp;
                Group group = GroupManager.getInstance().getGroup(groupId);
                Collection admins = group.getAdmins();
                for (JID jid : admins) {
                    if (!jid.getNode().equalsIgnoreCase(node)) continue;
                    isGroupAdminOrManager = true;
                    break;
                }
                if (isGroupAdminOrManager || (groupProp = group.getProperties()) == null || !groupProp.containsKey((Object)"groupManagers") || (groupManagers = (String)groupProp.get((Object)"groupManagers")) == null || groupManagers.isEmpty()) break block4;
                JSONArray groupManager = JSONArray.parseArray((String)groupManagers);
                for (int i = 0; i < groupManager.size(); ++i) {
                    String s = groupManager.getString(i).toLowerCase();
                    if (!s.equalsIgnoreCase(node)) continue;
                    isGroupAdminOrManager = true;
                    break;
                }
            }
            catch (GroupNotFoundException e) {
                e.printStackTrace();
            }
        }
        return isGroupAdminOrManager;
    }

    private void sendMessage(String inviter, List<String> userIds, String groupId, List<String> processUserList, boolean proc) {
        HashMap<String, String> dizMessage = new HashMap<String, String>();
        dizMessage.put("no_db", "1");
        dizMessage.put("no_conv", "1");
        dizMessage.put("objectName", "FW:CMDMsg");
        dizMessage.put("groupId", groupId);
        dizMessage.put("inviter", inviter);
        for (String userId : userIds) {
            Message msg = new Message();
            msg.setID(StringUtils.randomString((int)8));
            msg.setType(Message.Type.chat);
            HashMap<String, String> map = new HashMap<String, String>(dizMessage);
            map.put("userId", userId);
            msg.setFrom(new JID("group_notice|" + ServerInfo.SYSTEM_UDID, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
            msg.setBody(JSON.toJSONString(map));
            String xmppid = StringUtils.randomString((int)8);
            msg.setID(xmppid);
            if (proc) {
                msg.setTo(new JID(userId, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                ConversationUtil.updateInviterCon(userId, inviter, userId, xmppid);
                Log.info("sendMessage,infoMessage:{}", (Object)msg.toString());
                GroupPlugin.groupPlugin.sendMessage(msg);
                continue;
            }
            for (String noticeProcessUserId : processUserList) {
                msg.setTo(new JID(noticeProcessUserId, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                ConversationUtil.updateInviterCon(userId, inviter, noticeProcessUserId, xmppid);
                Log.info("sendMessage,infoMessage:{}", (Object)msg.toString());
                GroupPlugin.groupPlugin.sendMessage(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroupInviterConfig() {
        InputStream is = null;
        try {
            File file = new File(configFilePath);
            if (!file.exists()) {
                return;
            }
            is = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            String groupInviterEnableStr = prop.getProperty("groupInviterEnable");
            if ("true".equals(groupInviterEnableStr)) {
                this.groupInviterEnable = true;
            }
            this.groupMemberSize = Integer.parseInt(prop.getProperty("groupMemberSize"));
        }
        catch (Exception e) {
            Log.error("loadGroupInviterConfig,loadGroupInviterConfig,error:{}", (Object)e.getMessage());
            this.groupInviterEnable = false;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static List<String> getGroupInviterUserIds() {
        String userids = JiveGlobals.getProperty((String)"group.joinGroup.inviter.users");
        if (userids == null || userids.isEmpty()) {
            return null;
        }
        if (!userids.contains(",")) {
            ArrayList<String> list = new ArrayList<String>();
            list.add((userids + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
            return list;
        }
        String[] userArr = userids.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < userArr.length; ++i) {
            list.add((userArr[i] + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
        }
        return list;
    }

    public boolean isGroupInviterEnable() {
        return this.groupInviterEnable;
    }

    public void setGroupInviterEnable(boolean groupInviterEnable) {
        this.groupInviterEnable = groupInviterEnable;
    }

    public int getGroupMemberSize() {
        return this.groupMemberSize;
    }

    public void setGroupMemberSize(int groupMemberSize) {
        this.groupMemberSize = groupMemberSize;
    }
}

