/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.em.group.e10groupid.E10GroupIdUThread;
import com.weaver.em.group.e10groupid.E10GroupIdUtil;
import com.weaver.emobile.groupinviter.GroupInviterIQHandler;
import com.weaver.util.ServerInfo;
import com.weaver.util.ThreadPoolFactory;
import com.weaver.util.TimerTaskUtil;
import com.weaver.util.cluster.ClusterPropBeanUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import org.dom4j.Element;
import org.jivesoftware.admin.AuthCheckFilter;
import org.jivesoftware.openfire.IQRouter;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.IQ.GroupFunIQHandle;
import org.jivesoftware.openfire.plugin.IQ.GroupIQHandle;
import org.jivesoftware.openfire.plugin.IQ.GroupNoticeIQHandler;
import org.jivesoftware.openfire.plugin.IQ.GroupTagIQHandler;
import org.jivesoftware.openfire.plugin.util.ProcessGroupMessageThread;
import org.jivesoftware.openfire.plugin.util.pinyinutil.GroupNameToPinyinThread;
import org.jivesoftware.openfire.plugin.util.pinyinutil.GroupTagToPinYinThread;
import org.jivesoftware.openfire.plugin.util.pinyinutil.UserNameToPinYinThread;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.ComponentManagerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class GroupPlugin
implements Plugin,
Component {
    private static final Logger Log = LoggerFactory.getLogger(GroupPlugin.class);
    public static GroupPlugin groupPlugin;
    private String serviceName = "group";
    private SessionManager sessionManager;
    private GroupManager groupManager;
    private ComponentManager componentManager;
    private PluginManager pluginManager;
    private UserManager userManager;
    private Timer timerTask;

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        Log.info("--group--initializePlugin--starting...");
        groupPlugin = this;
        this.pluginManager = manager;
        this.sessionManager = SessionManager.getInstance();
        this.groupManager = GroupManager.getInstance();
        this.userManager = UserManager.getInstance();
        this.componentManager = ComponentManagerFactory.getComponentManager();
        try {
            this.componentManager.addComponent(this.serviceName, (Component)this);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        GroupIQHandle giu = new GroupIQHandle();
        IQRouter iqRouter = XMPPServer.getInstance().getIQRouter();
        iqRouter.addHandler((IQHandler)giu);
        GroupFunIQHandle gfiu = new GroupFunIQHandle();
        iqRouter.addHandler((IQHandler)gfiu);
        GroupNoticeIQHandler groupNoticeIQHandler = new GroupNoticeIQHandler();
        iqRouter.addHandler((IQHandler)groupNoticeIQHandler);
        GroupTagIQHandler groupTagIQHandler = new GroupTagIQHandler();
        iqRouter.addHandler((IQHandler)groupTagIQHandler);
        GroupInviterIQHandler groupInviterIQHandler = new GroupInviterIQHandler();
        iqRouter.addHandler((IQHandler)groupInviterIQHandler);
        boolean isUseCluster = ClusterPropBeanUtil.isUseCluster;
        boolean isMaster = ClusterPropBeanUtil.isMaster;
        if (TimerTaskUtil.needRunTimerTaskUtil()) {
            Thread g;
            Log.info("GroupPlugin, start to create SocialHistoryMsgRightDeduplicationTimerTask, isUseCluster: {}, isMaster: {}", (Object)isUseCluster, (Object)isMaster);
            this.timerTask = new Timer();
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 3);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Date date = calendar.getTime();
            if (date.before(new Date())) {
                date = this.addDay(date, 1);
            }
            if (JiveGlobals.getBooleanProperty((String)"searchGroupBugUpdate", (boolean)true)) {
                JiveGlobals.deleteProperty((String)"GroupNameToPinyin");
                JiveGlobals.deleteProperty((String)"GroupTagToPinyin");
                JiveGlobals.deleteProperty((String)"UserNameToPinyin");
                JiveGlobals.setProperty((String)"searchGroupBugUpdate", (String)"false");
            }
            if (JiveGlobals.getBooleanProperty((String)"GroupNameToPinyin", (boolean)true)) {
                g = new GroupNameToPinyinThread();
                g.start();
            }
            if (JiveGlobals.getBooleanProperty((String)"GroupTagToPinyin", (boolean)true)) {
                g = new GroupTagToPinYinThread();
                g.start();
            }
            if (JiveGlobals.getBooleanProperty((String)"UserNameToPinyin", (boolean)true)) {
                g = new UserNameToPinYinThread();
                g.start();
            }
            if (E10GroupIdUtil.needUpdateE10GroupId()) {
                E10GroupIdUThread e = new E10GroupIdUThread();
                e.start();
            }
        }
        AuthCheckFilter.addExclude((String)"group/httpservice/api/group");
    }

    public void destroyPlugin() {
        if (null != this.timerTask) {
            this.timerTask.cancel();
        }
        if (this.componentManager != null) {
            try {
                this.componentManager.removeComponent(this.serviceName);
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.componentManager = null;
        this.userManager = null;
        this.pluginManager = null;
        this.sessionManager = null;
        this.groupManager = null;
    }

    private Date addDay(Date date, int num) {
        Calendar startDT = Calendar.getInstance();
        startDT.setTime(date);
        startDT.add(5, num);
        return startDT.getTime();
    }

    public void initialize(JID jid, ComponentManager componentManager) {
    }

    public void start() {
    }

    public void shutdown() {
    }

    public String getName() {
        return this.pluginManager.getName((Plugin)this);
    }

    public String getDescription() {
        return this.pluginManager.getDescription((Plugin)this);
    }

    public void processPacket(Packet packet) {
        boolean canProceed = false;
        Group group = null;
        String toNode = packet.getTo().getNode();
        String toResource = packet.getTo().getResource();
        boolean targetAll = "all".equals(toNode);
        boolean targetAllMessage = "all".equals(toResource);
        if (!targetAll) {
            try {
                if (toNode != null) {
                    group = this.groupManager.getGroup(toNode);
                    canProceed = true;
                }
            }
            catch (GroupNotFoundException e) {
                Log.error("group not found.packet:{}", (Object)packet.toString());
            }
        }
        if (packet instanceof Message) {
            Message message = (Message)packet;
            this.processMessage(message, targetAllMessage, group, canProceed);
        } else if (packet instanceof Presence) {
            Presence presence = (Presence)packet;
            this.processPresence(canProceed, presence);
        } else if (packet instanceof IQ) {
            IQ iq = (IQ)packet;
            if (IQ.Type.error == iq.getType() || IQ.Type.result == iq.getType()) {
                return;
            }
            this.processIQ(iq, targetAll, group, canProceed);
        }
    }

    private void processMessage(Message message, boolean targetAll, Group group, boolean canProceed) {
        block40: {
            ArrayList<JID> groupMembers;
            JID from;
            block44: {
                block45: {
                    block43: {
                        block38: {
                            ArrayList<JID> groupMembers2;
                            JID from2;
                            block41: {
                                block42: {
                                    block39: {
                                        if (message.getType() == Message.Type.headline) {
                                            try {
                                                this.componentManager.sendPacket((Component)this, (Packet)message);
                                            }
                                            catch (Exception e) {
                                                Log.error(e.getMessage(), (Throwable)e);
                                            }
                                            return;
                                        }
                                        if (!targetAll) break block38;
                                        if (group != null) break block39;
                                        Message error = new Message();
                                        if (message.getID() != null) {
                                            error.setID(message.getID());
                                        }
                                        error.setTo(message.getFrom());
                                        error.setFrom(message.getTo());
                                        error.setError(PacketError.Condition.not_allowed);
                                        error.setSubject("Error sending broadcast message");
                                        error.setBody("Address not valid: " + message.getTo());
                                        try {
                                            this.componentManager.sendPacket((Component)this, (Packet)error);
                                        }
                                        catch (Exception e) {
                                            Log.error(e.getMessage(), (Throwable)e);
                                        }
                                        break block40;
                                    }
                                    if (!canProceed) break block40;
                                    from2 = message.getFrom();
                                    groupMembers2 = new ArrayList<JID>();
                                    boolean hasGetUserFromMsg = false;
                                    try {
                                        String bodyMessage = message.getBody();
                                        JSONObject jsonObject = JSONObject.parseObject((String)bodyMessage);
                                        if (jsonObject != null && jsonObject.containsKey((Object)"to_users")) {
                                            String processMsgUsers = jsonObject.getString("to_users");
                                            if (!"-1".equals(processMsgUsers)) {
                                                JSONArray jsonArray = new JSONArray();
                                                if (processMsgUsers != null && processMsgUsers.contains("[") && processMsgUsers.contains("]")) {
                                                    jsonArray = JSONArray.parseArray((String)processMsgUsers);
                                                    if (jsonArray != null) {
                                                        for (int i = 0; i < jsonArray.size(); ++i) {
                                                            JID jid = new JID(jsonArray.getString(i) + "|" + ServerInfo.SYSTEM_UDID.toLowerCase(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                                                            groupMembers2.add(jid);
                                                        }
                                                    }
                                                    hasGetUserFromMsg = true;
                                                }
                                            } else if ("-1".equals(processMsgUsers)) {
                                                Log.warn("msg not need to process.message:{}", (Object)message.toString());
                                                return;
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        Log.error("processMessage,error:{}", (Object)e.getMessage());
                                    }
                                    if (!hasGetUserFromMsg) {
                                        Collection members = group.getAll();
                                        for (JID jid : members) {
                                            groupMembers2.add(jid);
                                        }
                                    }
                                    if (groupMembers2 == null || groupMembers2.size() <= 100) break block41;
                                    if (groupMembers2.size() >= 500) break block42;
                                    ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new ProcessGroupMessageThread(message, groupMembers2, from2, group));
                                    break block40;
                                }
                                ArrayList<JID> groupJIDs = new ArrayList();
                                for (int i = 0; i < groupMembers2.size(); ++i) {
                                    JID jid;
                                    jid = (JID)groupMembers2.get(i);
                                    groupJIDs.add(jid);
                                    if (i == 0 || i % 500 != 0) continue;
                                    ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new ProcessGroupMessageThread(message, (List<JID>)groupJIDs, from2, group));
                                    groupJIDs = new ArrayList<JID>();
                                }
                                if (groupJIDs == null || groupJIDs.size() <= 0) break block40;
                                ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new ProcessGroupMessageThread(message, (List<JID>)groupJIDs, from2, group));
                                break block40;
                            }
                            for (JID userJID : groupMembers2) {
                                JID userJid = new JID(userJID.getNode().toLowerCase(), from2.getDomain(), null, true);
                                Message newMessage = message.createCopy();
                                newMessage.setTo(userJid);
                                newMessage.setFrom(new JID("admin", "group." + from2.getDomain(), group.getName(), true));
                                try {
                                    this.componentManager.sendPacket((Component)this, (Packet)newMessage);
                                }
                                catch (Exception e) {
                                    Log.error(e.getMessage(), (Throwable)e);
                                }
                            }
                            break block40;
                        }
                        if (group != null) break block43;
                        Message error = new Message();
                        if (message.getID() != null) {
                            error.setID(message.getID());
                        }
                        error.setTo(message.getFrom());
                        error.setFrom(message.getTo());
                        error.setError(PacketError.Condition.not_allowed);
                        error.setSubject("Error sending broadcast message");
                        error.setBody("Address not valid: " + message.getTo());
                        try {
                            this.componentManager.sendPacket((Component)this, (Packet)error);
                        }
                        catch (Exception e) {
                            Log.error(e.getMessage(), (Throwable)e);
                        }
                        break block40;
                    }
                    if (!canProceed) break block40;
                    from = message.getFrom();
                    groupMembers = new ArrayList<JID>();
                    boolean hasGetUserFromMsg = false;
                    try {
                        String bodyMessage = message.getBody();
                        JSONObject jsonObject = JSONObject.parseObject((String)bodyMessage);
                        if (jsonObject != null && jsonObject.containsKey((Object)"to_users")) {
                            String processMsgUsers = jsonObject.getString("to_users");
                            if (!"-1".equals(processMsgUsers)) {
                                JSONArray jsonArray = JSONArray.parseArray((String)processMsgUsers);
                                if (jsonArray != null) {
                                    for (int i = 0; i < jsonArray.size(); ++i) {
                                        JID jid = new JID(jsonArray.getString(i) + "|" + ServerInfo.SYSTEM_UDID.toLowerCase(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                                        groupMembers.add(jid);
                                    }
                                }
                                hasGetUserFromMsg = true;
                                Log.info("done propcessGroup groupId:{},,to_users:{},groupMembers:{}", new Object[]{group.getName(), processMsgUsers, groupMembers.size()});
                            } else if ("-1".equals(processMsgUsers)) {
                                Log.warn("msg not need to process.message:{}", (Object)message.toString());
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.error("processMessage,error:{}", (Object)e.getMessage());
                    }
                    if (!hasGetUserFromMsg) {
                        Collection members = group.getAll();
                        for (JID jid : members) {
                            groupMembers.add(jid);
                        }
                    }
                    if (groupMembers == null || groupMembers.size() <= 100) break block44;
                    groupMembers.remove(from.asBareJID());
                    if (groupMembers.size() >= 500) break block45;
                    ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new ProcessGroupMessageThread(message, groupMembers, from, group));
                    break block40;
                }
                ArrayList<Object> groupJIDs = new ArrayList<JID>();
                for (int i = 0; i < groupMembers.size(); ++i) {
                    JID jid;
                    jid = (JID)groupMembers.get(i);
                    groupJIDs.add(jid);
                    if (i == 0 || i % 500 != 0) continue;
                    ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new ProcessGroupMessageThread(message, groupJIDs, from, group));
                    groupJIDs = new ArrayList();
                }
                if (groupJIDs == null || groupJIDs.size() <= 0) break block40;
                ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new ProcessGroupMessageThread(message, groupJIDs, from, group));
                break block40;
            }
            for (JID userJID : groupMembers) {
                if (from.getNode().equals(userJID.getNode())) continue;
                Message newMessage = message.createCopy();
                JID userJid = new JID(userJID.getNode().toLowerCase(), from.getDomain(), null, true);
                newMessage.setTo(userJid);
                newMessage.setFrom(new JID(from.getNode(), "group." + from.getDomain(), group.getName(), true));
                try {
                    this.componentManager.sendPacket((Component)this, (Packet)newMessage);
                }
                catch (Exception e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void processPresence(boolean canProceed, Presence presence) {
        try {
            if (Presence.Type.subscribe == presence.getType()) {
                Presence reply = new Presence();
                reply.setTo(presence.getFrom());
                reply.setFrom(presence.getTo());
                reply.setType(canProceed ? Presence.Type.subscribed : Presence.Type.unsubscribed);
                this.componentManager.sendPacket((Component)this, (Packet)reply);
            } else if (Presence.Type.unsubscribe == presence.getType()) {
                Presence reply = new Presence();
                reply.setTo(presence.getFrom());
                reply.setFrom(presence.getTo());
                reply.setType(Presence.Type.unsubscribed);
                this.componentManager.sendPacket((Component)this, (Packet)reply);
                if (!canProceed) {
                    reply = new Presence();
                    reply.setTo(presence.getFrom());
                    reply.setFrom(presence.getTo());
                    reply.setType(Presence.Type.unavailable);
                    this.componentManager.sendPacket((Component)this, (Packet)reply);
                }
            } else if (Presence.Type.probe == presence.getType()) {
                Presence reply = new Presence();
                reply.setTo(presence.getFrom());
                reply.setFrom(presence.getTo());
                if (!canProceed) {
                    reply.setError(PacketError.Condition.forbidden);
                }
                this.componentManager.sendPacket((Component)this, (Packet)reply);
            }
        }
        catch (ComponentException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void processIQ(IQ iq, boolean targetAll, Group group, boolean canProceed) {
        IQ reply = IQ.createResultIQ((IQ)iq);
        Element childElement = iq.getChildElement();
        String namespace = childElement.getNamespaceURI();
        Element childElementCopy = iq.getChildElement().createCopy();
        reply.setChildElement(childElementCopy);
        try {
            this.componentManager.sendPacket((Component)this, (Packet)reply);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        JiveGlobals.setProperty((String)"plugin.broadcast.serviceName", (String)serviceName);
    }

    public void setGlobalAllowedUsers(Collection<String> allowedUsers) {
        StringBuilder buf = new StringBuilder();
        for (String jid : allowedUsers) {
            buf.append(jid).append(",");
        }
        JiveGlobals.setProperty((String)"plugin.broadcast.allowedUsers", (String)buf.toString());
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }

    private void changeServiceName(String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("Service name cannot be null");
        }
        if (this.serviceName.equals(serviceName)) {
            return;
        }
        try {
            this.componentManager.removeComponent(this.serviceName);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.componentManager.addComponent(serviceName, (Component)this);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        this.serviceName = serviceName;
    }

    private List<JID> stringToList(String str) {
        ArrayList<JID> values = new ArrayList<JID>();
        StringTokenizer tokens = new StringTokenizer(str, ",");
        while (tokens.hasMoreTokens()) {
            String value = tokens.nextToken().trim();
            if (value.equals("")) continue;
            if (value.contains("@")) {
                values.add(new JID(value));
                continue;
            }
            values.add(XMPPServer.getInstance().createJID(value, null));
        }
        return values;
    }

    public void sendMessage(Message message) {
        try {
            this.componentManager.sendPacket((Component)this, (Packet)message);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }
}

