/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessAddGroupUser;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessAddGroupUsers;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessCancelManagers;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessChangeGroupAdmin;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessChangeGroupName;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessCreateGroup;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessDeleteGroup;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessDeleteGroupUsers;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessExitGroup;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessGetAllGroups;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessGetSecretChat;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessMaxGroupMember;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessQRCodeAddGroup;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessSeeHistoryMsg;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessSetDisableMsgRead;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessSetDisableWords;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessSetGroupIcon;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessSetManager;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessSetMsgAtAllUsers;
import org.jivesoftware.openfire.plugin.IQ.strategy.ProcessSetSecretGroupChat;
import org.jivesoftware.openfire.plugin.tag.GroupTagUtil;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class GroupIQHandle
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(GroupIQHandle.class);
    private String GROUP_XMLNS = "http://weaver.com.cn/group";
    private GroupManager groupManager;
    private UserManager userManager;
    private IQHandlerInfo info = new IQHandlerInfo("query", this.GROUP_XMLNS);
    private static Map<String, IQStrategy> handlerMap = new HashMap<String, IQStrategy>();

    public GroupIQHandle() {
        super("GroupIQHandle");
        this.groupManager = GroupManager.getInstance();
        this.userManager = UserManager.getInstance();
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        try {
            Map<String, Object> result = new HashMap<String, Object>();
            JID fromJID = packet.getFrom();
            IQ reply = IQ.createResultIQ((IQ)packet);
            Element elereply = reply.getElement();
            Element ele = elereply.addElement("query");
            String data = packet.getElement().elementText("query");
            String method = null;
            long startTime = System.currentTimeMillis();
            if (packet.getType().equals((Object)IQ.Type.get)) {
                this.processGet(result, fromJID, data);
            } else {
                JSONObject json = JSON.parseObject((String)data);
                method = (String)json.get((Object)"method");
                IQStrategy iqStrategy = handlerMap.get(method);
                result = iqStrategy.process(fromJID, json, result);
            }
            ele.addText(JSON.toJSONString(result).toString());
            long endTime = System.currentTimeMillis();
            if (null != method) {
                Log.info("method:{}.from:{},data:{},result:{},cost : {} ms ,Completed", new Object[]{method, fromJID, data, JSON.toJSONString(result).toString(), endTime - startTime});
            }
            return reply;
        }
        catch (Exception e) {
            Log.warn("GroupIQHandler,packet={},error={}", (Object)packet.toString(), (Object)e.getMessage());
            IQ error = IQ.createResultIQ((IQ)packet);
            error.setType(IQ.Type.error);
            return error;
        }
    }

    private Map<String, Object> processSet(Map<String, Object> result, JID fromJID, String data) {
        JSONObject json = JSON.parseObject((String)data);
        String method = (String)json.get((Object)"method");
        IQStrategy iqStrategy = handlerMap.get(method);
        result = iqStrategy.process(fromJID, json, result);
        return result;
    }

    private void processGet(Map<String, Object> result, JID fromJID, String data) throws GroupNotFoundException {
        block11: {
            JSONObject json = JSON.parseObject((String)data);
            String groupId = (String)json.get((Object)"groupId");
            boolean flushGroupInfoFromDb = false;
            if (JiveGlobals.getBooleanProperty((String)"flush.group.info", (boolean)false)) {
                flushGroupInfoFromDb = this.checkGroupNeedFlush(groupId);
            }
            Group group = this.groupManager.getGroup(groupId, flushGroupInfoFromDb);
            result.put("groupId", groupId);
            result.put("groupName", group.getDescription());
            Collection members = group.getMembers();
            ArrayList<String> mems = new ArrayList<String>();
            for (Object jid : members) {
                mems.add(jid.getNode().toLowerCase());
            }
            HashSet<String> adminis = new HashSet<String>();
            for (JID jid : group.getAdmins()) {
                mems.add(jid.getNode().toLowerCase());
                adminis.add(jid.getNode().toLowerCase());
            }
            this.getGroupProp(groupId, result, mems, adminis);
            String groupType = (String)result.get("groupType");
            result.put("members", mems);
            result.put("admins", adminis);
            String secretGroupType = null;
            if (result != null && result.containsKey("secretGroupType")) {
                secretGroupType = (String)result.get("secretGroupType");
            }
            if ("1".equals(secretGroupType)) {
                result.put("secretGroupTargetId", this.getSecretChatTargetId(GroupIQHandle.conNodeToID(fromJID.getNode()), groupId));
                return;
            }
            GroupTagUtil gtu = new GroupTagUtil();
            Set<String> groupTagValues = gtu.getGroupUserTag(groupId, fromJID.getNode());
            result.put("groupTagValues", groupTagValues);
            String xmppDomain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
            if (result.containsKey("deleteGroup") && "true".equals((String)result.get("deleteGroup"))) {
                for (String mem : mems) {
                    group.getMembers().remove(new JID(mem, xmppDomain, null));
                }
                for (String admin : adminis) {
                    group.getAdmins().remove(new JID(admin, xmppDomain, null));
                }
                mems = new ArrayList();
                adminis = new HashSet();
            }
            if ("0".equals(groupType) && !result.containsKey("deleteGroup") && adminis != null && adminis.size() > 1) {
                Log.info("group has more group admin.groupId:{},adminis:{}", (Object)groupId, adminis);
                for (String admin : adminis) {
                    group.getAdmins().remove(new JID(admin, xmppDomain, null, true));
                    group.getMembers().add(new JID(admin, xmppDomain, null, true));
                }
            }
            if (!"0".equals(groupType) || result.containsKey("deleteGroup") || adminis == null || adminis.size() != 0) break block11;
            Log.info("group not has group admin,groupId :{} ", (Object)groupId);
            Iterator iterator = mems.iterator();
            if (iterator.hasNext()) {
                String member = (String)iterator.next();
                group.getMembers().remove(new JID(member, xmppDomain, null, true));
                group.getAdmins().add(new JID(member, xmppDomain, null, true));
                mems.remove(member);
                adminis.add(member);
            }
        }
    }

    private boolean checkGroupNeedFlush(String groupName) {
        try {
            RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
            if (redisPoolMgr != null) {
                String str = redisPoolMgr.get("groupflush:" + groupName);
                if (str != null && !str.isEmpty()) {
                    return false;
                }
                int expire = JiveGlobals.getIntProperty((String)"groupflushExpire", (int)3600);
                redisPoolMgr.setex("groupflush:" + groupName, groupName, expire);
            }
        }
        catch (Exception e) {
            Log.error("checkGroupNeedFlush ,error :{} ,groupName:{},e:{}", new Object[]{e.getMessage(), groupName, e});
        }
        return true;
    }

    private String getSecretChatTargetId(String userId, String groupId) {
        String targetId = userId;
        try {
            Group group = GroupManager.getInstance().getGroup(groupId);
            Collection members = group.getAll();
            for (JID jid : members) {
                String node = jid.getNode();
                String nodeUserId = GroupIQHandle.conNodeToID(node);
                if (nodeUserId.equals(userId)) continue;
                targetId = nodeUserId;
                break;
            }
        }
        catch (Exception e) {
            Log.error("getSecretChatTargetId ,error ,userId :{},groupId:{},error:{},e:{}", new Object[]{userId, groupId, e.getMessage(), e});
        }
        return targetId;
    }

    private static String conNodeToID(String node) {
        if (node.startsWith("push|")) {
            return "-1";
        }
        int i = node.indexOf("|");
        if (i > 0) {
            return node.substring(0, i);
        }
        if (i == 0) {
            return "-1";
        }
        return node;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    private void getGroupProp(String groupId, Map<String, Object> result, List<String> mems, Set<String> admins) {
        Group group = null;
        try {
            String msg_at_all_users;
            group = this.groupManager.getGroup(groupId);
            PersistableMap groupPropMap = group.getProperties();
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupIconUrl")) {
                String imageUrl = (String)groupPropMap.get((Object)"groupIconUrl");
                result.put("groupIconUrl", imageUrl);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"isDisableMsgRead")) {
                String isDisableMsgRead = (String)groupPropMap.get((Object)"isDisableMsgRead");
                if (!"true".equals(isDisableMsgRead)) {
                    isDisableMsgRead = "false";
                }
                result.put("isDisableMsgRead", isDisableMsgRead);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"isDisableWords")) {
                String isDisableWords = (String)groupPropMap.get((Object)"isDisableWords");
                if (!"true".equals(isDisableWords)) {
                    isDisableWords = "false";
                }
                result.put("isDisableWords", isDisableWords);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"isDisableAddUser")) {
                String isDisableAddUser = (String)groupPropMap.get((Object)"isDisableAddUser");
                result.put("isDisableAddUser", isDisableAddUser);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"createUser")) {
                String createUser = (String)groupPropMap.get((Object)"createUser");
                result.put("createUser", createUser);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupManagers")) {
                String groupManagers = (String)groupPropMap.get((Object)"groupManagers");
                if (groupManagers != null && !groupManagers.isEmpty()) {
                    JSONArray groupManager = JSONArray.parseArray((String)groupManagers);
                    boolean groupManagerRemove = false;
                    for (int i = 0; i < groupManager.size(); ++i) {
                        String s = groupManager.getString(i).toLowerCase();
                        if (mems.contains(s) && !admins.contains(s)) continue;
                        groupManager.remove((Object)s);
                        Log.error("groupManagers is not member or is admin :{} ", (Object)s);
                        groupManagerRemove = true;
                    }
                    result.put("groupManagers", groupManager.toString());
                } else {
                    result.put("groupManagers", groupManagers);
                }
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"msg_at_all_users") && (msg_at_all_users = (String)groupPropMap.get((Object)"msg_at_all_users")) != null && !msg_at_all_users.isEmpty()) {
                result.put("msg_at_all_users", msg_at_all_users);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"deleteGroup")) {
                String deleteGroup = (String)groupPropMap.get((Object)"deleteGroup");
                result.put("deleteGroup", deleteGroup);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"createtime")) {
                String createtime = (String)groupPropMap.get((Object)"createtime");
                result.put("createtime", createtime);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupIconType")) {
                String groupIconType = (String)groupPropMap.get((Object)"groupIconType");
                result.put("groupIconType", groupIconType);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupIconUserIds")) {
                String groupIconUserIds = (String)groupPropMap.get((Object)"groupIconUserIds");
                result.put("groupIconUserIds", groupIconUserIds);
            }
            if (groupPropMap != null && groupPropMap.containsKey((Object)"seeHistoryMsg")) {
                String seeHistoryMsg = (String)groupPropMap.get((Object)"seeHistoryMsg");
                result.put("seeHistoryMsg", seeHistoryMsg);
            }
            String isDRCodeAddGroupUser = "true";
            if (groupPropMap != null && groupPropMap.containsKey((Object)"isDRCodeAddGroupUser")) {
                isDRCodeAddGroupUser = (String)groupPropMap.get((Object)"isDRCodeAddGroupUser");
            }
            result.put("isDRCodeAddGroupUser", isDRCodeAddGroupUser);
            String isCommonMembersAddGroupUser = "true";
            if (groupPropMap != null && groupPropMap.containsKey((Object)"isCommonMembersAddGroupUser")) {
                isCommonMembersAddGroupUser = (String)groupPropMap.get((Object)"isCommonMembersAddGroupUser");
            }
            result.put("isCommonMembersAddGroupUser", isCommonMembersAddGroupUser);
            String groupType = "0";
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupType")) {
                groupType = (String)groupPropMap.get((Object)"groupType");
            }
            result.put("groupType", groupType);
            String maxGroupMember = "-1";
            if (groupPropMap != null && groupPropMap.containsKey((Object)"maxGroupMember")) {
                maxGroupMember = (String)groupPropMap.get((Object)"maxGroupMember");
            }
            result.put("maxGroupMember", maxGroupMember);
            String secretGroupType = "0";
            if (groupPropMap != null && groupPropMap.containsKey((Object)"secretGroupType")) {
                secretGroupType = (String)groupPropMap.get((Object)"secretGroupType");
            }
            result.put("secretGroupType", secretGroupType);
        }
        catch (GroupNotFoundException e) {
            Log.error("getGroupIcon error.group is not found.groupId:{},e:{}", (Object)groupId, (Object)e.getMessage());
        }
    }

    static {
        handlerMap.put("addGroupUsers", new ProcessAddGroupUsers());
        handlerMap.put("cancelManagers", new ProcessCancelManagers());
        handlerMap.put("changeGroupAdmin", new ProcessChangeGroupAdmin());
        handlerMap.put("changeGroupName", new ProcessChangeGroupName());
        handlerMap.put("createGroup", new ProcessCreateGroup());
        handlerMap.put("deleteGroup", new ProcessDeleteGroup());
        handlerMap.put("deleteGroupUsers", new ProcessDeleteGroupUsers());
        handlerMap.put("exitGroup", new ProcessExitGroup());
        handlerMap.put("getAllGroups", new ProcessGetAllGroups());
        handlerMap.put("seeHistoryMsg", new ProcessSeeHistoryMsg());
        handlerMap.put("setDisableMsgRead", new ProcessSetDisableMsgRead());
        handlerMap.put("setDisableWords", new ProcessSetDisableWords());
        handlerMap.put("setGroupIcon", new ProcessSetGroupIcon());
        handlerMap.put("setManager", new ProcessSetManager());
        handlerMap.put("setCommonMembersAddGroupUser", new ProcessAddGroupUser());
        handlerMap.put("setQRCodeAddGroupUser", new ProcessQRCodeAddGroup());
        handlerMap.put("setMaxGroupMember", new ProcessMaxGroupMember());
        handlerMap.put("getSecretChat", new ProcessGetSecretChat());
        handlerMap.put("setSecretGroupChat", new ProcessSetSecretGroupChat());
        handlerMap.put("setMsgAtAllUser", new ProcessSetMsgAtAllUsers());
    }
}

