/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.util.GroupDatabaseUtil;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class GroupNoticeIQHandler
extends IQHandler {
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/group/notice");
    private static final String GROUP_NOTICE_XMLNS = "http://weaver.com.cn/group/notice";
    private static final Logger Log = LoggerFactory.getLogger(GroupNoticeIQHandler.class);

    public GroupNoticeIQHandler() {
        super(GroupNoticeIQHandler.class.getName());
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JID fromJID = packet.getFrom();
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        if (fromJID == null) {
            Log.error("GroupNoticeIQHandler,fromJID is null,packet={}", (Object)packet.toString());
        } else {
            JSONObject json = JSON.parseObject((String)packet.getElement().elementText("query"));
            String method = (String)json.get((Object)"method");
            if (IQ.Type.get.equals((Object)packet.getType())) {
                if ("getGroupNoticeList".equals(method)) {
                    String groupId = json.getString("groupId");
                    GroupDatabaseUtil groupDatabaseUtil = new GroupDatabaseUtil();
                    result.put("groupNoticeList", groupDatabaseUtil.getGroupNoticeList(groupId));
                }
            } else if (IQ.Type.set.equals((Object)packet.getType())) {
                if ("saveGroupNotice".equals(method)) {
                    JSONObject data = JSON.parseObject((String)json.get((Object)"data").toString());
                    GroupDatabaseUtil groupDatabaseUtil = new GroupDatabaseUtil();
                    SimpleDateFormat SDF_ALL_NOW = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String groupId = data.getString("groupId");
                    String content = data.getString("content");
                    String sendId = GroupNoticeIQHandler.conNodeToID(fromJID.getNode());
                    String date = SDF_ALL_NOW.format(new Date());
                    if (!this.checkUserIsAdmin(fromJID, groupId)) {
                        result.put("error", "\u975e\u7fa4\u4e3b\u548c\u7ba1\u7406\u5458\u4e0d\u80fd\u53d1\u9001\u7fa4\u516c\u544a\uff01");
                    } else {
                        long noticeId = groupDatabaseUtil.saveGroupNotice(groupId, content, sendId, date);
                        result.put("success", noticeId);
                    }
                } else if ("updateGroupNotice".equals(method)) {
                    JSONObject data = JSON.parseObject((String)json.get((Object)"data").toString());
                    String groupId = data.getString("groupId");
                    String content = data.getString("content");
                    String sendId = GroupNoticeIQHandler.conNodeToID(fromJID.getNode());
                    String noticeId = data.getString("noticeId");
                    GroupDatabaseUtil groupDatabaseUtil = new GroupDatabaseUtil();
                    if (!this.checkUserIsAdmin(fromJID, groupId)) {
                        result.put("error", "\u975e\u7fa4\u4e3b\u548c\u7ba1\u7406\u5458\u4e0d\u80fd\u4fee\u6539\u7fa4\u516c\u544a\uff01");
                    } else {
                        groupDatabaseUtil.updateGroupNotice(groupId, content, sendId, noticeId);
                        result.put("success", noticeId);
                    }
                } else if ("deleteGroupNotice".equals(method)) {
                    JSONObject data = JSON.parseObject((String)json.get((Object)"data").toString());
                    String groupId = data.getString("groupId");
                    String noticeId = data.getString("noticeId");
                    GroupDatabaseUtil groupDatabaseUtil = new GroupDatabaseUtil();
                    if (!this.checkUserIsAdmin(fromJID, groupId)) {
                        result.put("error", "\u975e\u7fa4\u4e3b\u548c\u7ba1\u7406\u5458\u4e0d\u80fd\u5220\u9664\u7fa4\u516c\u544a\uff01");
                    } else {
                        groupDatabaseUtil.deleteGroupNotice(groupId, noticeId);
                        result.put("success", noticeId);
                    }
                }
            }
            ele.addText(JSON.toJSONString(result).toString());
            Log.info("GroupNoticeIQHandler\uff0cmethod:{}.from:{},Completed", (Object)method, (Object)fromJID);
        }
        return reply;
    }

    private static String conNodeToID(String node) {
        if (node.startsWith("push|")) {
            return "-1";
        }
        int i = node.indexOf("|");
        if (i > 0) {
            return node.substring(0, i);
        }
        if (i == 0) {
            return "-1";
        }
        return node;
    }

    private boolean checkUserIsAdmin(JID fromJID, String groupId) {
        Group group = null;
        PersistableMap groupProp = null;
        if (groupId != null) {
            try {
                group = GroupManager.getInstance().getGroup(groupId);
            }
            catch (GroupNotFoundException e) {
                return false;
            }
        }
        Collection admins = group.getAdmins();
        for (JID admin : admins) {
            if (!fromJID.getNode().equals(admin.getNode())) continue;
            return true;
        }
        groupProp = group.getProperties();
        if (groupProp != null && groupProp.containsKey((Object)"groupManagers")) {
            String groupManagers = (String)groupProp.get((Object)"groupManagers");
            JSONArray groupManagerArray = JSON.parseArray((String)groupManagers);
            if (groupManagerArray == null) {
                groupManagerArray = new JSONArray();
            }
            for (int i = 0; i < groupManagerArray.size(); ++i) {
                if (!fromJID.getNode().equals(groupManagerArray.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

