/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.plugin.tag.GroupTagUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class GroupTagIQHandler
extends IQHandler {
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://weaver.com.cn/group/tag");
    private static final Logger Log = LoggerFactory.getLogger(GroupTagIQHandler.class);
    private static final String NAMESPACE = "http://weaver.com.cn/group/tag";

    public GroupTagIQHandler() {
        super("GroupTagIQHandler");
    }

    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        JID fromJID = packet.getFrom();
        if (fromJID == null) {
            Log.warn("GroupTagIQHandler from is null .packet :{}", (Object)packet.toString());
            return null;
        }
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element elereply = reply.getElement();
        Element ele = elereply.addElement("query");
        JSONObject json = JSON.parseObject((String)packet.getElement().elementText("query"));
        if (IQ.Type.set.equals((Object)packet.getType())) {
            String method = null;
            if (json != null && json.containsKey((Object)"method")) {
                method = json.getString("method");
            }
            if (method == null) {
                Log.error("GroupTagIQHandler,mehtod is null ,packet :{}", (Object)packet.toString());
                return null;
            }
            if ("setTagValue".equals(method)) {
                String groupName = null;
                if (json != null && json.containsKey((Object)"groupId")) {
                    groupName = json.getString("groupId");
                }
                String tagValue = null;
                if (json != null && json.containsKey((Object)"tagValue")) {
                    tagValue = json.getString("tagValue");
                }
                if (groupName == null || groupName.isEmpty() || tagValue == null || tagValue.isEmpty()) {
                    Log.error("GroupTagIQHandler,setTagValue,groupName is null or tagValue is null ,packet :{} ", (Object)packet.toString());
                    return null;
                }
                GroupTagUtil gtu = new GroupTagUtil();
                gtu.addGroupUserTag(groupName, fromJID.getNode(), tagValue);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("groupId", groupName);
                map.put("tagValue", tagValue);
                ele.addText(JSON.toJSONString(map).toString());
                Log.info("setTagValues :{} ,fromJID:{}", (Object)JSON.toJSONString(map), (Object)fromJID);
                return reply;
            }
            if ("setTagValues".equals(method)) {
                String groupName = null;
                if (json != null && json.containsKey((Object)"groupId")) {
                    groupName = json.getString("groupId");
                }
                String tagValues = null;
                if (json != null && json.containsKey((Object)"tagValues")) {
                    tagValues = json.getString("tagValues");
                }
                if (groupName == null || groupName.isEmpty()) {
                    Log.error("GroupTagIQHandler,setTagValues,groupName is null,packet :{} ", (Object)packet.toString());
                    return null;
                }
                String[] tagValue = null;
                if (tagValues != null) {
                    tagValue = tagValues.split(",");
                }
                if (tagValue == null || tagValue.length == 0) {
                    GroupTagUtil gtu = new GroupTagUtil();
                    Log.info("GroupTagIQHandler,setTagValues,tagValues is null now deleteGroupTag");
                    gtu.delGroupTag(groupName, fromJID.getNode());
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("groupId", groupName);
                    map.put("tagValues", tagValues);
                    ele.addText(JSON.toJSONString(map).toString());
                    return reply;
                }
                GroupTagUtil gtu = new GroupTagUtil();
                gtu.setGroupTags(groupName, fromJID.getNode(), tagValue);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("groupId", groupName);
                map.put("tagValues", tagValues);
                ele.addText(JSON.toJSONString(map).toString());
                Log.info("setTagValues :{} ,fromJID:{}", (Object)JSON.toJSONString(map), (Object)fromJID);
                return reply;
            }
            if ("deleteGroupTag".equals(method)) {
                String groupName = null;
                if (json != null && json.containsKey((Object)"groupId")) {
                    groupName = json.getString("groupId");
                }
                String tagValue = null;
                if (json != null && json.containsKey((Object)"tagValue")) {
                    tagValue = json.getString("tagValue");
                }
                if (groupName == null || tagValue == null) {
                    Log.error("GroupTagIQHandler,deleteGroupTag,groupName is null or tagValue is null ,packet :{} ", (Object)packet.toString());
                    return null;
                }
                GroupTagUtil gtu = new GroupTagUtil();
                gtu.delGroupUserTag(groupName, fromJID.getNode(), tagValue);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("groupId", groupName);
                map.put("tagValue", tagValue);
                ele.addText(JSON.toJSONString(map).toString());
                Log.info("deleteGroupTag :{} ,fromJID:{}", (Object)JSON.toJSONString(map), (Object)fromJID);
                return reply;
            }
            if ("deleteTag".equals(method)) {
                String tagValue = null;
                if (json != null && json.containsKey((Object)"tagValue")) {
                    tagValue = json.getString("tagValue");
                }
                if (tagValue == null) {
                    Log.error("GroupTagIQHandler,deleteTag,groupName is null or tagValue is null ,packet :{} ", (Object)packet.toString());
                    return null;
                }
                GroupTagUtil gtu = new GroupTagUtil();
                gtu.delGroupTag(fromJID.getNode(), tagValue);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tagValue", tagValue);
                ele.addText(JSON.toJSONString(map).toString());
                Log.info("deleteGroupTag :{} ,fromJID:{}", (Object)JSON.toJSONString(map), (Object)fromJID);
                return reply;
            }
            if ("delAllTags".equals(method)) {
                GroupTagUtil gtu = new GroupTagUtil();
                gtu.delAllTags(fromJID.getNode());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("success", "0");
                ele.addText(JSON.toJSONString(map).toString());
                Log.info("delAllTags :{} ,fromJID:{}", (Object)JSON.toJSONString(map), (Object)fromJID);
                return reply;
            }
            if ("delGroupAllTags".equals(method)) {
                String groupName = null;
                if (json != null && json.containsKey((Object)"groupId")) {
                    groupName = json.getString("groupId");
                }
                if (groupName == null) {
                    Log.error("GroupTagIQHandler,delGroupAllTags,groupName is null ,packet:{}", (Object)packet.toString());
                    return null;
                }
                GroupTagUtil gtu = new GroupTagUtil();
                gtu.delGroupAllTags(groupName, fromJID.getNode());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("groupId", groupName);
                ele.addText(JSON.toJSONString(map).toString());
                Log.info("delGroupAllTags :{} ,fromJID:{}", (Object)JSON.toJSONString(map), (Object)fromJID);
                return reply;
            }
            if ("searchGroupTag".equals(method)) {
                GroupTagUtil gtu = new GroupTagUtil();
                String groupTag = null;
                if (json != null && json.containsKey((Object)"groupTag")) {
                    groupTag = json.getString("groupTag");
                }
                Map<Object, Object> map = new HashMap();
                map = gtu.searchGroupTag(fromJID.getNode(), groupTag);
                ele.addText(JSON.toJSONString(map).toString());
                Log.info("searchGroupTag :{} ,fromJID:{},groupTag:{}", new Object[]{JSON.toJSONString(map), fromJID, groupTag});
                return reply;
            }
        } else if (IQ.Type.get.equals((Object)packet.getType())) {
            String groupName = null;
            if (json != null && json.containsKey((Object)"groupId")) {
                groupName = json.getString("groupId");
            }
            GroupTagUtil gtu = new GroupTagUtil();
            Set<String> tagValues = null;
            tagValues = groupName != null ? gtu.getGroupUserTag(groupName, fromJID.getNode()) : gtu.getUserTag(fromJID.getNode());
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            map.put("tagValues", tagValues);
            ele.addText(JSON.toJSONString(map).toString());
            Log.info("getTagValues :{} ,fromJID:{}", (Object)JSON.toJSONString(map), (Object)fromJID);
            return reply;
        }
        return null;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

