/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.emobile.groupinviter.GroupInviterUtil;
import com.weaver.util.ThreadPoolFactory;
import com.weaver.util.emservertutil.FriendUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.GroupDatabaseUtil;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessAddGroupUsers
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessAddGroupUsers.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        JSONArray members = json.getJSONArray("members");
        String groupId = (String)json.get((Object)"groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "addGroupUsers", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        String shareCoder = null;
        if (json.containsKey((Object)"shareCoder")) {
            shareCoder = json.getString("shareCoder");
        }
        ArrayList<String> mems = new ArrayList<String>();
        for (Object obj : members.toArray()) {
            String username = (String)obj;
            mems.add(username);
        }
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        Group group = null;
        try {
            group = GroupManager.getInstance().getGroup(groupId);
            PersistableMap groupPropMap = group.getProperties();
            int maxM = -1;
            if (groupPropMap != null && groupPropMap.containsKey((Object)"maxGroupMember")) {
                maxM = Integer.parseInt((String)groupPropMap.get((Object)"maxGroupMember"));
            }
            if (maxM == -1 && JiveGlobals.getIntProperty((String)"maxGroupMembers", (int)2000) < group.getAll().size() + mems.size()) {
                Log.error("addGroupUser error groupMembers more than maxGroupMembers more than maxGroupMembers . groupId :{} ,maxGroupMembers :{} ,nowGroupMembers :{} ,newGroupMembers :{} ", new Object[]{groupId, JiveGlobals.getIntProperty((String)"maxGroupMembers", (int)2000), group.getAll().size(), mems.size()});
                result.put("code", "403");
                result.put("errorMsg", "group members is too more ");
                return result;
            }
            if (maxM != -1 && maxM < group.getAll().size() + mems.size()) {
                Log.error("addGroupUser error groupMembers more than maxGroupMembers . groupId :{} ,maxM :{} ,nowGroupMembers :{} ,newGroupMembers :{} ", new Object[]{groupId, maxM, group.getAll().size(), mems.size()});
                result.put("code", "403");
                result.put("errorMsg", "group members is too more ");
                return result;
            }
        }
        catch (Exception e) {
            Log.error("addGroupUsers e :{} ", (Throwable)e);
        }
        GroupInviterUtil groupInviterUtil = GroupInviterUtil.getInstance();
        if (groupInviterUtil.isGroupInviterEnable() && !JiveGlobals.getBooleanProperty((String)"groupInviterUserEnable", (boolean)false)) {
            int inviterMembers = groupInviterUtil.getGroupMemberSize();
            if (inviterMembers == 0) {
                groupInviterUtil.saveInvitationInfo(fromJID.getNode(), mems, groupId, mems, true, "0");
                result.put("inviterMems", mems);
                result.put("groupId", groupId);
            } else {
                int memsSize = mems.size();
                int oldGroupMembersSize = group.getAll().size();
                if (oldGroupMembersSize + memsSize < inviterMembers) {
                    this.addGroupUsers(fromJID.getNode(), groupId, mems, content, shareCoder);
                    result.put("groupId", groupId);
                    result.put("members", mems);
                } else if (oldGroupMembersSize >= inviterMembers) {
                    groupInviterUtil.saveInvitationInfo(fromJID.getNode(), mems, groupId, mems, true, "0");
                    result.put("groupId", groupId);
                    result.put("inviterMems", mems);
                } else {
                    ArrayList<String> newMems = new ArrayList<String>();
                    ArrayList<String> inviterMems = new ArrayList<String>();
                    for (String mem : mems) {
                        if (newMems.size() + oldGroupMembersSize < inviterMembers) {
                            newMems.add(mem);
                            continue;
                        }
                        inviterMems.add(mem);
                    }
                    if (newMems.size() > 0) {
                        this.addGroupUsers(fromJID.getNode(), groupId, newMems, content, shareCoder);
                        result.put("groupId", groupId);
                        result.put("members", newMems);
                    }
                    if (inviterMems.size() > 0) {
                        groupInviterUtil.saveInvitationInfo(fromJID.getNode(), inviterMems, groupId, inviterMems, true, "0");
                        result.put("groupId", groupId);
                        result.put("inviterMems", inviterMems);
                    }
                }
            }
        } else if (JiveGlobals.getBooleanProperty((String)"groupInviterUserEnable", (boolean)false)) {
            List<String> list = GroupInviterUtil.getGroupInviterUserIds();
            if (list == null || list.size() == 0) {
                this.addGroupUsers(fromJID.getNode(), groupId, mems, content, shareCoder);
                result.put("groupId", groupId);
                result.put("members", mems);
            }
            ArrayList<String> newMems = new ArrayList<String>();
            ArrayList<String> inviterMems = new ArrayList<String>();
            for (String mem : mems) {
                if (list.contains(mem)) {
                    inviterMems.add(mem);
                    continue;
                }
                newMems.add(mem);
            }
            this.addGroupUsers(fromJID.getNode(), groupId, newMems, content, shareCoder);
            result.put("groupId", groupId);
            result.put("members", newMems);
            if (inviterMems.size() > 0) {
                groupInviterUtil.saveInvitationInfo(fromJID.getNode(), inviterMems, groupId, inviterMems, true, "0");
                result.put("groupId", groupId);
                result.put("inviterMems", inviterMems);
            }
        } else if (JiveGlobals.getBooleanProperty((String)"groupCheckFirend", (boolean)false)) {
            boolean isAdminOrManager = groupInviterUtil.checkUserIsAdminOrManager(groupId, fromJID.getNode());
            ArrayList<String> adminOrManagerList = new ArrayList();
            if (!isAdminOrManager) {
                adminOrManagerList = groupInviterUtil.getAdminOrManager(groupId);
            }
            List notFriendList = FriendUtil.checkFirend((String)fromJID.getNode(), mems);
            Log.info("fromJID :{} ,mems :{} ,notFriendList :{} ", new Object[]{fromJID, mems, notFriendList});
            ArrayList<String> friendList = new ArrayList<String>(mems);
            if (notFriendList != null && notFriendList.size() > 0) {
                for (String userId : notFriendList) {
                    friendList.remove(userId);
                }
                if (isAdminOrManager) {
                    groupInviterUtil.saveInvitationInfo(fromJID.getNode(), notFriendList, groupId, notFriendList, true, "0");
                    result.put("inviterMems", notFriendList);
                } else {
                    groupInviterUtil.saveInvitationInfo(fromJID.getNode(), notFriendList, groupId, adminOrManagerList, false, "4");
                    result.put("inviterMems", notFriendList);
                }
            }
            if (friendList != null && friendList.size() > 0) {
                if (isAdminOrManager) {
                    this.addGroupUsers(fromJID.getNode(), groupId, friendList, content, shareCoder);
                    result.put("groupId", groupId);
                    result.put("members", friendList);
                } else {
                    groupInviterUtil.saveInvitationInfo(fromJID.getNode(), friendList, groupId, adminOrManagerList, false, "5");
                    result.put("inviterMems", mems);
                }
            }
        } else {
            this.addGroupUsers(fromJID.getNode(), groupId, mems, content, shareCoder);
            result.put("groupId", groupId);
            result.put("members", mems);
        }
        return result;
    }

    private void addGroupUsers(String operater, String groupName, List<String> users, String content, String shareCoder) {
        try {
            final Group group = this.groupManager.getGroup(groupName);
            User user = null;
            String extension = "";
            String failedExtension = "";
            String operaName = "";
            String userNames = "";
            String groupAdmin = null;
            HashMap<String, Boolean> userMap = new HashMap<String, Boolean>();
            for (String username : users) {
                try {
                    user = this.userManager.getUser(username);
                    userNames = userNames + UsernameUtil.getUserName(operaName, user.getName()) + ",";
                    if (user == null) continue;
                    Collection groupMembers = group.getMembers();
                    Collection groupAdmins = group.getAdmins();
                    for (JID jid : groupAdmins) {
                        groupAdmin = jid.getNode();
                    }
                    JID jid = new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                    if (groupMembers == null || groupMembers.contains(jid) || groupAdmins.contains(jid)) continue;
                    boolean needDelete = groupMembers.add(jid);
                    userMap.put(username, needDelete);
                    extension = extension + user.getUID() + ",";
                }
                catch (UserNotFoundException e) {
                    JID jid = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                    group.getMembers().add(jid);
                }
            }
            try {
                user = this.userManager.getUser(operater);
                operaName = UsernameUtil.getUserName(operater, user.getName());
            }
            catch (UserNotFoundException e) {
                Log.error("addGroupUsers,user is {} not found.", (Object)operater);
                return;
            }
            if ("".equals(extension)) {
                Log.info("addGroupUsers.User not found.or User is already group user.groupName:{},users:{}", (Object)groupName, users);
                return;
            }
            if (extension.endsWith(",")) {
                extension = extension.substring(0, extension.length() - 1);
            }
            if (failedExtension.endsWith(",")) {
                failedExtension = failedExtension.substring(0, failedExtension.length() - 1);
            }
            if (content == null || content.isEmpty()) {
                if (shareCoder != null && !shareCoder.isEmpty()) {
                    String shareUserName = "";
                    String operaUserName = "";
                    try {
                        User shareCoderUser = this.userManager.getUser(shareCoder);
                        shareUserName = shareCoderUser.getName();
                        User opearUser = this.userManager.getUser(users.get(0));
                        operaUserName = opearUser.getName();
                    }
                    catch (UserNotFoundException e) {
                        Log.error("shareCoder is not a user.shareCoder:{}", (Object)shareCoder);
                    }
                    String tongguo = LocaleUtils.getLocalizedString((String)"group.iq.tongguo", (String)"group");
                    String shareCoderGroup = LocaleUtils.getLocalizedString((String)"group.iq.shareCoder", (String)"group");
                    content = operaUserName + tongguo + shareUserName + shareCoderGroup;
                } else {
                    if (userNames.endsWith(",")) {
                        userNames = userNames.substring(0, userNames.length() - 1);
                    }
                    String invite = LocaleUtils.getLocalizedString((String)"group.iq.invite", (String)"group");
                    String invitePerson = LocaleUtils.getLocalizedString((String)"group.iq.invite.person", (String)"group");
                    String invitePersons = LocaleUtils.getLocalizedString((String)"group.iq.invite.persons", (String)"group");
                    content = users.size() > 10 ? operaName + invite + users.size() + invitePersons : operaName + invite + userNames + invitePerson;
                }
            }
            PersistableMap groupProp = group.getProperties();
            int seeHisotryMsg = 0;
            if (groupProp != null && groupProp.containsKey((Object)"seeHistoryMsg")) {
                seeHisotryMsg = Integer.parseInt((String)groupProp.get((Object)"seeHistoryMsg"));
            }
            if (seeHisotryMsg != 0) {
                GroupDatabaseUtil gdb = new GroupDatabaseUtil();
                gdb.seeHistoryMsg(groupName, userMap, seeHisotryMsg, operater, groupAdmin);
            }
            final String extensionFinal = extension;
            final String failedExtensionFinal = failedExtension;
            final User userFinal = user;
            final String finalContent = content;
            final String sharecoder = shareCoder;
            ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    Message infoMessage = new Message();
                    infoMessage.setID(StringUtils.randomString((int)8));
                    infoMessage.setType(Message.Type.chat);
                    infoMessage.setFrom(new JID(userFinal.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    infoMessage.setTo(new JID(group.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                    DizMessage diz = null;
                    diz = sharecoder == null || sharecoder.isEmpty() ? new DizMessage(1, userFinal.getUID(), extensionFinal, failedExtensionFinal) : new DizMessage(12, sharecoder, extensionFinal, failedExtensionFinal);
                    diz.setContent(finalContent);
                    infoMessage.setBody(diz.toString());
                    Log.info("addGroupUsers,infoMessage:{}", (Object)infoMessage.toString());
                    GroupPlugin.groupPlugin.sendMessage(infoMessage);
                }
            });
        }
        catch (GroupNotFoundException e) {
            Log.error("addGroupUsers,group {} not found.", (Object)groupName);
        }
    }
}

