/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.util.ThreadPoolFactory;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessCancelManagers
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessCancelManagers.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        int cancel;
        String groupId = (String)json.get((Object)"groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "cancelManager", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        JSONArray managers = json.getJSONArray("groupManagers");
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        if (0 == (cancel = this.cancelManager(fromJID, groupId, managers, content))) {
            result.put("groupId", groupId);
            result.put("groupManagers", managers);
        } else {
            result.put("error", "cancel error");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int cancelManager(JID operater, String groupId, JSONArray managers, String content) {
        JSONArray managersArray;
        JSONArray groupManagerArray;
        PersistableMap groupPropMap;
        Group group = null;
        User user = null;
        String operaterName = "";
        String managersName = "";
        try {
            String groupManager;
            group = this.groupManager.getGroup(groupId);
            user = this.userManager.getUser(operater.getNode());
            operaterName = UsernameUtil.getUserName(operater.getNode(), user.getName());
            GroupManager.lockGroup((String)groupId);
            groupPropMap = group.getProperties();
            if (groupPropMap != null && groupPropMap.containsKey((Object)"groupManagers")) {
                groupManager = ((String)groupPropMap.get((Object)"groupManagers")).toLowerCase();
                if (groupManager == null) {
                    Log.warn("group:{} no managers.can not to cancel manager.", (Object)groupId);
                    return 4;
                }
            } else {
                Log.warn("cancelManager.group :{} has not managers .can not to cancel.manager:{},operater:{}", new Object[]{groupId, managers, operater});
                return 1;
            }
            groupManagerArray = JSON.parseArray((String)groupManager);
            managersArray = managers;
        }
        catch (GroupNotFoundException e) {
            Log.error("setGroupManager.group is not found.groupId:{},operater:{},managers:{}", new Object[]{groupId, operater, managers});
            return 2;
        }
        catch (UserNotFoundException e) {
            Log.error("setGroupManager.operater is not found.groupId:{},operater:{},managers:{}", new Object[]{groupId, operater, managers});
            return 3;
        }
        for (int i = 0; i < managersArray.size(); ++i) {
            String manager = managersArray.getString(i).toLowerCase();
            managersName = managersName + UsernameUtil.getUserName(operater.getNode(), this.userManager.getUser(manager).getName()) + ",";
            if (groupManagerArray.contains((Object)manager)) {
                groupManagerArray.remove((Object)manager);
                Log.info("group:{},cancelManager:{}", (Object)group, (Object)manager);
                continue;
            }
            Log.warn("user:{},is not group:{}, manager.can not to cancel", (Object)manager, (Object)groupId);
        }
        groupPropMap.put((Object)"groupManagers", (Object)groupManagerArray.toString());
        GroupManager.unlockGroup((String)groupId);
        if (content == null || content.isEmpty()) {
            if (managersName.endsWith(",")) {
                managersName = managersName.substring(0, managersName.length() - 1);
            }
            if (managers.size() > 4) {
                String etc = LocaleUtils.getLocalizedString((String)"group.iq.etc", (String)"group");
                String people = LocaleUtils.getLocalizedString((String)"group.iq.delete.people", (String)"group");
                String delete = LocaleUtils.getLocalizedString((String)"group.iq.deletejiang", (String)"group");
                String concelManager = LocaleUtils.getLocalizedString((String)"group.iq.concelManager", (String)"group");
                content = operaterName + delete + managersName.substring(0, managersName.indexOf(",", managersName.indexOf(",") + 1)) + etc + managers.size() + people + concelManager;
            } else {
                String delete = LocaleUtils.getLocalizedString((String)"group.iq.deletejiang", (String)"group");
                String concelManager = LocaleUtils.getLocalizedString((String)"group.iq.concelManager", (String)"group");
                content = operaterName + delete + managersName + concelManager;
            }
            Log.info("content:{}", (Object)content);
        }
        final Group grouptemp = group;
        final User usertemp = user;
        final String extensiontemp = managers.toString();
        final String finalContent = content;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                Message infoMessage = new Message();
                infoMessage.setID(StringUtils.randomString((int)8));
                infoMessage.setType(Message.Type.chat);
                infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                DizMessage diz = new DizMessage(9, usertemp.getUID(), extensiontemp);
                diz.setContent(finalContent);
                infoMessage.setBody(diz.toString());
                Log.info("cancel manager infoMessage:{}", (Object)infoMessage.toString());
                GroupPlugin.groupPlugin.sendMessage(infoMessage);
            }
        });
        return 0;
    }
}

