/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.ThreadPoolFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessChangeGroupAdmin
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessChangeGroupAdmin.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        String groupId = (String)json.get((Object)"groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "changeGroupAdmin", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        String newadminId = (String)json.get((Object)"admins");
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        Group group = this.changeGroupAdmin(fromJID.getNode(), groupId, newadminId.toLowerCase(), content);
        result.put("members", group.getMembers());
        result.put("admins", group.getAdmins());
        return result;
    }

    private Group changeGroupAdmin(String operater, String groupName, String admins, String content) {
        String extension = "";
        String operateName = null;
        String adminsName = null;
        try {
            JSONArray groupManagerArray;
            PersistableMap groupPropMap;
            User user;
            Group group;
            block10: {
                ArrayList<JID> adminList;
                block8: {
                    RedisPoolMgr redisPoolMgr;
                    block9: {
                        group = this.groupManager.getGroup(groupName, true);
                        User userAdmins = this.userManager.getUser(admins);
                        adminsName = UsernameUtil.getUserName(operater, userAdmins.getName());
                        user = this.userManager.getUser(operater);
                        operateName = UsernameUtil.getUserName(operater, user.getName());
                        GroupManager.lockGroup((String)groupName);
                        groupPropMap = group.getProperties();
                        String groupManagers = "";
                        groupManagerArray = null;
                        if (groupPropMap != null && groupPropMap.containsKey((Object)"groupManagers") && (groupManagerArray = JSON.parseArray((String)(groupManagers = (String)groupPropMap.get((Object)"groupManagers")))).contains((Object)userAdmins.getUID())) {
                            groupManagerArray.remove((Object)userAdmins.getUID());
                        }
                        adminList = new ArrayList<JID>();
                        for (JID adminuser : group.getAdmins()) {
                            adminList.add(adminuser);
                        }
                        if (!this.changeGroupAdmin(operater, admins, groupName)) break block8;
                        redisPoolMgr = RedisPoolMgr.getInstance();
                        if (!JiveGlobals.getBooleanProperty((String)"flush.group.info", (boolean)false)) break block9;
                        if (redisPoolMgr != null) {
                            redisPoolMgr.del("groupflush:" + groupName);
                        }
                        break block10;
                    }
                    if (redisPoolMgr == null) break block10;
                    HashSet<String> redisGroupCache = new HashSet<String>();
                    redisGroupCache.add("sgroup:desc:" + groupName);
                    redisGroupCache.add("sgroup:prop:" + groupName);
                    redisGroupCache.add("sgroup:admins:" + groupName);
                    redisGroupCache.add("sgroup:members:" + groupName);
                    redisPoolMgr.batchDel(redisGroupCache);
                    break block10;
                }
                group.getMembers().remove(new JID(admins, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                group.getAdmins().add(new JID(admins, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                for (JID jid : adminList) {
                    group.getAdmins().remove(jid);
                    group.getMembers().add(jid);
                }
            }
            GroupManager.unlockGroup((String)groupName);
            groupPropMap.put((Object)"groupManagers", (Object)(groupManagerArray != null ? groupManagerArray.toString() : "[]"));
            if (content == null || content.isEmpty()) {
                String changeGroupName = LocaleUtils.getLocalizedString((String)"group.iq.changeGroupName", (String)"group");
                content = operateName + changeGroupName + adminsName;
            }
            final String tempextension = new JID(admins, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true).toString();
            final String finalContent = content;
            ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    Message infoMessage = new Message();
                    infoMessage.setID(StringUtils.randomString((int)8));
                    infoMessage.setType(Message.Type.chat);
                    infoMessage.setFrom(new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    infoMessage.setTo(new JID(group.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                    DizMessage diz = new DizMessage(6, user.getUID(), tempextension);
                    diz.setContent(finalContent);
                    infoMessage.setBody(diz.toString());
                    Log.info("changeGroupAdmin,infoMessage:{}", (Object)infoMessage.toString());
                    GroupPlugin.groupPlugin.sendMessage(infoMessage);
                }
            });
            return group;
        }
        catch (GroupNotFoundException e) {
            Log.error("changeGroupAdmin,group {} not found.", (Object)groupName);
        }
        catch (UserNotFoundException e) {
            Log.error("changeGroupAdmin,user {} not found.", (Object)operater);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeGroupAdmin(String members, String admins, String groupId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" update ofgroupuser set administrator = ? where groupName = ? and username = ? ");
            pstmt.setString(1, "1");
            pstmt.setString(2, groupId);
            pstmt.setString(3, admins);
            pstmt.addBatch();
            pstmt.setString(1, "0");
            pstmt.setString(2, groupId);
            pstmt.setString(3, members);
            pstmt.addBatch();
            pstmt.executeBatch();
            pstmt.clearBatch();
        }
        catch (Exception e) {
            boolean bl;
            try {
                Log.error("changeGroupadmin ,error :{} ,e :{} ,members :{} ,admins :{} ,groupName :{} ", new Object[]{e.getMessage(), e, members, admins, groupId});
                bl = false;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            return bl;
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        return true;
    }
}

