/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSONObject;
import com.weaver.util.ThreadPoolFactory;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessChangeGroupName
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessChangeGroupName.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        String groupId = (String)json.get((Object)"groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "changeGroupName", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        String groupName = (String)json.get((Object)"groupName");
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        Group group = this.changeGroupName(fromJID.getNode(), groupId, groupName, content);
        result.put("groupId", group.getName());
        result.put("groupName", group.getDescription());
        return result;
    }

    private Group changeGroupName(String operater, String groupName, String des, String content) {
        try {
            final Group group = this.groupManager.getGroup(groupName, true);
            group.setDescription(des);
            final User user = this.userManager.getUser(operater);
            String operaterName = UsernameUtil.getUserName(operater, user.getName());
            if (content == null || content.isEmpty()) {
                String updateGroupName = LocaleUtils.getLocalizedString((String)"group.iq.updateGroupName", (String)"group");
                content = operaterName + updateGroupName;
            }
            final String finalContent = content;
            ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    String extension = group.getDescription();
                    Message infoMessage = new Message();
                    infoMessage.setID(StringUtils.randomString((int)8));
                    infoMessage.setType(Message.Type.chat);
                    infoMessage.setFrom(new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    infoMessage.setTo(new JID(group.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                    DizMessage diz = new DizMessage(3, user.getUID(), extension);
                    diz.setContent(finalContent);
                    infoMessage.setBody(diz.toString());
                    GroupPlugin.groupPlugin.sendMessage(infoMessage);
                }
            });
            return group;
        }
        catch (GroupNotFoundException e) {
            Log.error("changeGroupName,group {} not found.", (Object)groupName);
        }
        catch (UserNotFoundException e) {
            Log.error("changeGroupName,user {} not found.", (Object)operater);
        }
        return null;
    }
}

