/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.emobile.groupinviter.GroupInviterUtil;
import com.weaver.util.ServerInfo;
import com.weaver.util.ThreadPoolFactory;
import com.weaver.util.emservertutil.FriendUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.CreateGroupCountUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessCreateGroup
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessCreateGroup.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        JSONArray members = json.getJSONArray("members");
        String groupid = UUID.randomUUID().toString().toLowerCase();
        String groupName = (String)json.get((Object)"groupName");
        ArrayList<String> mems = new ArrayList<String>();
        int count = 0;
        String tempGroupName = "";
        for (Object obj : members.toArray()) {
            String username = (String)obj;
            if (mems.contains(username)) continue;
            mems.add(username.toLowerCase());
            if (!StringUtils.isBlank((CharSequence)groupName) || count > 5) continue;
            if (count < 5) {
                try {
                    tempGroupName = tempGroupName + UsernameUtil.getUserName(fromJID.getNode(), UserManager.getInstance().getUser(username).getName());
                }
                catch (UserNotFoundException userNotFoundException) {
                    // empty catch block
                }
                if (count < 4) {
                    tempGroupName = tempGroupName + ",";
                }
            } else {
                tempGroupName = tempGroupName + "...";
            }
            ++count;
        }
        if (StringUtils.isBlank((CharSequence)groupName)) {
            if (tempGroupName.endsWith(",")) {
                tempGroupName = tempGroupName.substring(0, tempGroupName.length() - 1);
            }
            groupName = tempGroupName;
        }
        ArrayList<String> adminis = new ArrayList<String>();
        adminis.add(fromJID.getNode());
        if (!CreateGroupCountUtil.checkUserCreateGroupCount(fromJID.getNode())) {
            result.put("code", "403");
            result.put("errorMsg", "create group to more");
            Log.error("{} crateGroup to more today", (Object)fromJID.getNode());
            return result;
        }
        if (mems != null && mems.contains(fromJID.getNode())) {
            mems.remove(fromJID.getNode());
        }
        String groupIconUrl = null;
        if (json != null && json.containsKey((Object)"groupIconUrl")) {
            groupIconUrl = json.getString("groupIconUrl");
        }
        String groupIconType = "1";
        if (json != null && json.containsKey((Object)"groupIconType")) {
            groupIconType = json.getString("groupIconType");
        }
        String groupIconUserIds = null;
        if (json != null && json.containsKey((Object)"groupIconUserIds")) {
            groupIconUserIds = json.getString("groupIconUserIds");
        }
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        String seeHistoryMsg = "0";
        if (json != null && json.containsKey((Object)"seeHistoryMsg")) {
            seeHistoryMsg = json.getString("seeHistoryMsg");
        }
        String isDisableWords = "false";
        if (json != null && json.containsKey((Object)"isDisableWords")) {
            isDisableWords = json.getString("isDisableWords");
        }
        String isDisableMsgRead = "false";
        if (json != null && json.containsKey((Object)"isDisableMsgRead")) {
            isDisableMsgRead = json.getString("isDisableMsgRead");
        }
        String isDRCodeAddGroupUser = "true";
        if (json != null && json.containsKey((Object)"isDRCodeAddGroupUser")) {
            isDRCodeAddGroupUser = json.getString("isDRCodeAddGroupUser");
        }
        String isCommonMembersAddGroupUser = "true";
        if (json != null && json.containsKey((Object)"isCommonMembersAddGroupUser")) {
            isCommonMembersAddGroupUser = json.getString("isCommonMembersAddGroupUser");
        }
        String secretGroupType = "0";
        if (json != null && json.containsKey((Object)"secretGroupType") && !"0".equals(secretGroupType = json.getString("secretGroupType")) && !"1".equals(secretGroupType) && !"2".equals(secretGroupType)) {
            secretGroupType = "0";
        }
        String maxGroupMember = "-1";
        try {
            int maxM;
            if (json != null && json.containsKey((Object)"maxGroupMember")) {
                maxGroupMember = json.getString("maxGroupMember");
            }
            if ((maxM = Integer.parseInt(maxGroupMember)) == -1 && JiveGlobals.getIntProperty((String)"maxGroupMembers", (int)2000) < mems.size() + adminis.size()) {
                Log.error("addGroupUser error groupMembers more than maxGroupMembers more than maxGroupMembers . groupId :{} ,maxGroupMembers :{} ,nowGroupMembers :{} ,newGroupMembers :{} ", (Object)groupid, (Object)JiveGlobals.getIntProperty((String)"maxGroupMembers", (int)2000));
                result.put("code", "403");
                result.put("errorMsg", "members too more");
                return result;
            }
            if (maxM != -1 && maxM < mems.size() + adminis.size()) {
                Log.error("createGroup error groupMembers more than maxGroupMembers . groupId :{} ,maxM :{} ,newGroupMembers :{} ", (Object)groupid, (Object)mems.size());
                result.put("code", "403");
                result.put("errorMsg", "members too more");
                return result;
            }
        }
        catch (Exception e) {
            Log.error("createGroup ,error :{}", (Throwable)e);
        }
        try {
            List<String> oMems = this.getListForGroupMember();
            if (oMems != null && oMems.size() > 0) {
                for (String mem : oMems) {
                    if (mems.contains(mem) || adminis.contains(mem)) continue;
                    if (UserManager.getInstance().isRegisteredUser(mem)) {
                        mems.add(mem);
                        continue;
                    }
                    Log.warn("getListForGroupMember,user is ont registerdUser :{}", (Object)mem);
                }
            }
        }
        catch (Exception e) {
            Log.error("add group mems error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        GroupInviterUtil groupInviterUtil = GroupInviterUtil.getInstance();
        if (groupInviterUtil.isGroupInviterEnable() && !JiveGlobals.getBooleanProperty((String)"groupCheckFirend", (boolean)false)) {
            if (mems != null && mems.size() > groupInviterUtil.getGroupMemberSize()) {
                if (groupInviterUtil.getGroupMemberSize() == 0) {
                    this.createGroup(groupid, groupName, adminis, groupIconUrl, groupIconType, groupIconUserIds, seeHistoryMsg, isDisableWords, isDisableMsgRead, isDRCodeAddGroupUser, isCommonMembersAddGroupUser, maxGroupMember, secretGroupType);
                    groupInviterUtil.saveInvitationInfo(fromJID.getNode(), mems, groupid, mems, true, "0");
                    result.put("groupId", groupid);
                    result.put("groupName", groupName);
                    result.put("admins", adminis);
                    result.put("inviterMems", mems);
                } else {
                    ArrayList<String> newMems = new ArrayList<String>();
                    ArrayList<String> inviterMems = new ArrayList<String>();
                    for (String mem : mems) {
                        if (newMems.size() < groupInviterUtil.getGroupMemberSize()) {
                            newMems.add(mem);
                            continue;
                        }
                        inviterMems.add(mem);
                    }
                    this.createGroup(groupid, groupName, newMems, adminis, groupIconUrl, groupIconType, groupIconUserIds, content, seeHistoryMsg, isDisableWords, isDisableMsgRead, isDRCodeAddGroupUser, isCommonMembersAddGroupUser, maxGroupMember, secretGroupType);
                    result.put("groupId", groupid);
                    result.put("groupName", groupName);
                    result.put("members", newMems);
                    result.put("admins", adminis);
                    result.put("inviterMems", inviterMems);
                    groupInviterUtil.saveInvitationInfo(fromJID.getNode(), inviterMems, groupid, inviterMems, true, "0");
                }
            } else {
                this.createGroup(groupid, groupName, mems, adminis, groupIconUrl, groupIconType, groupIconUserIds, content, seeHistoryMsg, isDisableWords, isDisableMsgRead, isDRCodeAddGroupUser, isCommonMembersAddGroupUser, maxGroupMember, secretGroupType);
                result.put("groupId", groupid);
                result.put("groupName", groupName);
                result.put("members", mems);
                result.put("admins", adminis);
            }
        } else if (JiveGlobals.getBooleanProperty((String)"groupInviterUserEnable", (boolean)false)) {
            List<String> list = GroupInviterUtil.getGroupInviterUserIds();
            if (list == null || list.size() == 0) {
                this.createGroup(groupid, groupName, mems, adminis, groupIconUrl, groupIconType, groupIconUserIds, content, seeHistoryMsg, isDisableWords, isDisableMsgRead, isDRCodeAddGroupUser, isCommonMembersAddGroupUser, maxGroupMember, secretGroupType);
                result.put("groupId", groupid);
                result.put("groupName", groupName);
                result.put("members", mems);
                result.put("admins", adminis);
            } else {
                ArrayList<String> newMems = new ArrayList<String>();
                ArrayList<String> inviterMems = new ArrayList<String>();
                for (String mem : mems) {
                    if (list.contains(mem)) {
                        inviterMems.add(mem);
                        continue;
                    }
                    newMems.add(mem);
                }
                this.createGroup(groupid, groupName, newMems, adminis, groupIconUrl, groupIconType, groupIconUserIds, content, seeHistoryMsg, isDisableWords, isDisableMsgRead, isDRCodeAddGroupUser, isCommonMembersAddGroupUser, maxGroupMember, secretGroupType);
                result.put("groupId", groupid);
                result.put("groupName", groupName);
                result.put("members", newMems);
                result.put("admins", adminis);
                if (inviterMems != null && inviterMems.size() > 0) {
                    groupInviterUtil.saveInvitationInfo(fromJID.getNode(), inviterMems, groupid, inviterMems, true, "0");
                    result.put("inviterMems", inviterMems);
                }
            }
        } else if (JiveGlobals.getBooleanProperty((String)"groupCheckFirend", (boolean)false)) {
            List notFriendList = FriendUtil.checkFirend((String)fromJID.getNode(), mems);
            ArrayList<String> friendList = new ArrayList<String>(mems);
            if (notFriendList != null && notFriendList.size() > 0) {
                for (String userId : notFriendList) {
                    friendList.remove(userId);
                }
            }
            if (friendList != null && friendList.size() > 0) {
                this.createGroup(groupid, groupName, friendList, adminis, groupIconUrl, groupIconType, groupIconUserIds, content, seeHistoryMsg, isDisableWords, isDisableMsgRead, isDRCodeAddGroupUser, isCommonMembersAddGroupUser, maxGroupMember, secretGroupType);
                result.put("groupId", groupid);
                result.put("groupName", groupName);
                result.put("members", mems);
                result.put("admins", adminis);
            } else {
                this.createGroup(groupid, groupName, adminis, groupIconUrl, groupIconType, groupIconUserIds, seeHistoryMsg, isDisableWords, isDisableMsgRead, isDRCodeAddGroupUser, isCommonMembersAddGroupUser, maxGroupMember, secretGroupType);
                result.put("groupId", groupid);
                result.put("groupName", groupName);
                result.put("admins", adminis);
                result.put("inviterMems", mems);
            }
            if (notFriendList != null && notFriendList.size() > 0) {
                groupInviterUtil.saveInvitationInfo(fromJID.getNode(), notFriendList, groupid, notFriendList, true, "0");
                result.put("inviterMems", notFriendList);
            }
        } else {
            this.createGroup(groupid, groupName, mems, adminis, groupIconUrl, groupIconType, groupIconUserIds, content, seeHistoryMsg, isDisableWords, isDisableMsgRead, isDRCodeAddGroupUser, isCommonMembersAddGroupUser, maxGroupMember, secretGroupType);
            result.put("groupId", groupid);
            result.put("groupName", groupName);
            result.put("members", mems);
            result.put("admins", adminis);
        }
        CreateGroupCountUtil.setCurrCount(fromJID.getNode());
        return result;
    }

    private void createGroup(String groupName, String description, List<String> admins, String groupIconUrl, String groupIconType, String groupIconUserIds, String seeHistoryMsg, String isDisableWords, String isDisableMsgRead, String isDRCodeAddGroupUser, String isCommonMembersAddGroupUser, String maxGroupMember, String secretGroupType) {
        GroupManager groupManager = GroupManager.getInstance();
        User user = null;
        String userName = null;
        try {
            Group group = groupManager.createGroup(groupName, description);
            for (String string : admins) {
                try {
                    user = this.userManager.getUser(string);
                    userName = UsernameUtil.getUserName(string, user.getName());
                    if (user == null) continue;
                    group.getAdmins().add(new JID(string, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                }
                catch (UserNotFoundException e) {
                    Log.error("createGroup,user {} not found.", (Object)string);
                }
            }
            PersistableMap groupPropMap = group.getProperties();
            for (String admin : admins) {
                groupPropMap.put((Object)"createUser", (Object)admin);
            }
            groupPropMap.put((Object)"createtime", (Object)String.valueOf(System.currentTimeMillis()));
            if (groupIconUrl != null) {
                groupPropMap.put((Object)"groupIconUrl", (Object)groupIconUrl);
            }
            groupPropMap.put((Object)"groupIconType", (Object)groupIconType);
            groupPropMap.put((Object)"seeHistoryMsg", (Object)seeHistoryMsg);
            if (groupIconUserIds != null && !groupIconUserIds.isEmpty()) {
                groupPropMap.put((Object)"groupIconUserIds", (Object)groupIconUserIds);
            }
            groupPropMap.put((Object)"isDisableWords", (Object)isDisableWords);
            groupPropMap.put((Object)"isDisableMsgRead", (Object)isDisableMsgRead);
            groupPropMap.put((Object)"isDRCodeAddGroupUser", (Object)isDRCodeAddGroupUser);
            groupPropMap.put((Object)"isCommonMembersAddGroupUser", (Object)isCommonMembersAddGroupUser);
            groupPropMap.put((Object)"maxGroupMember", (Object)maxGroupMember);
            groupPropMap.put((Object)"secretGroupType", (Object)secretGroupType);
            final User user2 = user;
            String extensiontemp = "";
            String failedExtensionFinal = "";
            final Group grouptemp = group;
            final String finalContent = userName + "\u521b\u5efa\u4e86\u7fa4\u7ec4";
            ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    Message infoMessage = new Message();
                    infoMessage.setID(org.jivesoftware.util.StringUtils.randomString((int)8));
                    infoMessage.setType(Message.Type.chat);
                    infoMessage.setFrom(new JID(user2.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                    DizMessage diz = new DizMessage(1, user2.getUID(), "", "");
                    diz.setContent(finalContent);
                    infoMessage.setBody(diz.toString());
                    Log.info("createGroup,infoMessage:{}", (Object)infoMessage.toString());
                    GroupPlugin.groupPlugin.sendMessage(infoMessage);
                }
            });
        }
        catch (GroupAlreadyExistsException e) {
            e.printStackTrace();
        }
    }

    private List<String> getListForGroupMember() {
        ArrayList<String> list = new ArrayList<String>();
        FileInputStream is = null;
        try {
            String filePath = JiveGlobals.getHomeDirectory() + File.separator + "conf" + File.separator + "groupDefaultMembers.properties";
            File file = new File(filePath);
            is = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            String groupDefaultMembers = prop.getProperty("groupDefaultMembers");
            if (groupDefaultMembers == null || groupDefaultMembers.isEmpty()) {
                return null;
            }
            if (!groupDefaultMembers.contains(",")) {
                list.add((groupDefaultMembers + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
            } else {
                String[] temp = groupDefaultMembers.split(",");
                for (int i = 0; i < temp.length; ++i) {
                    list.add((temp[i] + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
                }
            }
        }
        catch (Exception e) {
            Log.error("getListForGroupMember,error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
            return null;
        }
        return list;
    }

    private Group createGroup(String groupName, String description, List<String> users, List<String> admins, String groupIconUrl, String groupIconType, String groupIconUserIds, String content, String seeHistoryMsg, String isDisableWords, String isDisableMsgRead, String isDRCodeAddGroupUser, String isCommonMembersAddGroupUser, String maxGroupMember, String secretGroupType) {
        try {
            Group group = this.groupManager.createGroup(groupName, description);
            User user = null;
            String extension = "";
            String failedExtension = "";
            String userNames = "";
            String operaName = "";
            String xmppDomain = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
            HashSet<JID> mems = new HashSet<JID>();
            for (String string : users) {
                try {
                    user = this.userManager.getUser(string);
                    userNames = userNames + UsernameUtil.getUserName(admins.get(0), user.getName()) + ",";
                    if (user == null) continue;
                    extension = extension + user.getUID() + ",";
                    JID jid = new JID(user.getUID(), xmppDomain, null, true);
                    mems.add(jid);
                }
                catch (UserNotFoundException e) {
                    JID jid = new JID(string, xmppDomain, null, true);
                    mems.add(jid);
                }
            }
            group.getMembers().addAll(mems);
            for (String string : admins) {
                try {
                    user = this.userManager.getUser(string);
                    operaName = UsernameUtil.getUserName(string, user.getName());
                    if (user == null) continue;
                    group.getAdmins().add(new JID(string, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    extension.replaceAll(string + ",", "");
                }
                catch (UserNotFoundException e) {
                    Log.error("createGroup,user {} not found.", (Object)string);
                }
            }
            PersistableMap groupPropMap = group.getProperties();
            for (String admin : admins) {
                groupPropMap.put((Object)"createUser", (Object)admin);
            }
            groupPropMap.put((Object)"createtime", (Object)String.valueOf(System.currentTimeMillis()));
            if (groupIconUrl != null) {
                groupPropMap.put((Object)"groupIconUrl", (Object)groupIconUrl);
            }
            groupPropMap.put((Object)"groupIconType", (Object)groupIconType);
            groupPropMap.put((Object)"seeHistoryMsg", (Object)seeHistoryMsg);
            if (groupIconUserIds != null && !groupIconUserIds.isEmpty()) {
                groupPropMap.put((Object)"groupIconUserIds", (Object)groupIconUserIds);
            }
            groupPropMap.put((Object)"isDisableWords", (Object)isDisableWords);
            groupPropMap.put((Object)"isDisableMsgRead", (Object)isDisableMsgRead);
            groupPropMap.put((Object)"isDRCodeAddGroupUser", (Object)isDRCodeAddGroupUser);
            groupPropMap.put((Object)"isCommonMembersAddGroupUser", (Object)isCommonMembersAddGroupUser);
            groupPropMap.put((Object)"maxGroupMember", (Object)maxGroupMember);
            groupPropMap.put((Object)"secretGroupType", (Object)secretGroupType);
            if (extension.endsWith(",")) {
                extension = extension.substring(0, extension.length() - 1);
            }
            if (content == null || content.isEmpty()) {
                String string = LocaleUtils.getLocalizedString((String)"group.iq.invite", (String)"group");
                String invitePerson = LocaleUtils.getLocalizedString((String)"group.iq.invite.person", (String)"group");
                String invitePersons = LocaleUtils.getLocalizedString((String)"group.iq.invite.persons", (String)"group");
                if (mems.size() > 10) {
                    content = operaName + string + mems.size() + invitePersons;
                } else {
                    if (userNames.endsWith(",")) {
                        userNames = userNames.substring(0, userNames.length() - 1);
                    }
                    content = operaName + string + userNames + invitePerson;
                }
            }
            if (failedExtension.endsWith(",")) {
                failedExtension = failedExtension.substring(0, failedExtension.length() - 1);
            }
            final User user2 = user;
            final String extensiontemp = extension;
            final String failedExtensionFinal = failedExtension;
            final Group grouptemp = group;
            final String finalContent = content;
            ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    Message infoMessage = new Message();
                    infoMessage.setID(org.jivesoftware.util.StringUtils.randomString((int)8));
                    infoMessage.setType(Message.Type.chat);
                    infoMessage.setFrom(new JID(user2.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                    DizMessage diz = new DizMessage(1, user2.getUID(), extensiontemp, failedExtensionFinal);
                    diz.setContent(finalContent);
                    infoMessage.setBody(diz.toString());
                    Log.info("createGroup,infoMessage:{}", (Object)infoMessage.toString());
                    GroupPlugin.groupPlugin.sendMessage(infoMessage);
                }
            });
            return group;
        }
        catch (GroupAlreadyExistsException e) {
            Log.error("createGroup,group is exist:{}", (Object)groupName);
            return null;
        }
    }
}

