/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSONObject;
import com.weaver.util.ThreadPoolFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.tag.GroupTagUtil;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessDeleteGroup
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessDeleteGroup.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        String groupId = json.getString("groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "deleteGroup", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        this.deleteGroup(fromJID, groupId, content);
        result.put("groupId", groupId);
        return result;
    }

    private void deleteGroup(JID fromJID, String groupId, String content) {
        Group group = null;
        User user = null;
        String operaName = null;
        try {
            group = this.groupManager.getGroup(groupId);
            user = this.userManager.getUser(fromJID.getNode());
            operaName = UsernameUtil.getUserName(fromJID.getNode(), user.getName());
        }
        catch (GroupNotFoundException e) {
            Log.error("deleteGroup.fromJID :{} .groupID:{}.group is not found .", (Object)fromJID.toString(), (Object)groupId);
            return;
        }
        catch (UserNotFoundException e) {
            Log.error("deleteGroup .fromJID :{} .groupID :{} .user is not found .", (Object)fromJID.toString(), (Object)groupId);
        }
        PersistableMap groupPropMap = group.getProperties();
        groupPropMap.put((Object)"deleteGroup", (Object)"true");
        groupPropMap.put((Object)"dissolution_time", (Object)String.valueOf(System.currentTimeMillis()));
        ArrayList<String> userList = new ArrayList<String>();
        Collection jids = group.getAll();
        for (JID jid : jids) {
            userList.add(jid.getNode());
        }
        GroupTagUtil gtu = new GroupTagUtil();
        gtu.delGroupTags(groupId, userList);
        if (content == null || content.isEmpty()) {
            String deleteGroup = LocaleUtils.getLocalizedString((String)"group.iq.deleteGroup", (String)"group");
            content = operaName + deleteGroup;
        }
        final Group grouptemp = group;
        final User usertemp = user;
        String extensiontemp = "deleteGroup";
        final String finalContent = content;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                Message infoMessage = new Message();
                infoMessage.setID(StringUtils.randomString((int)8));
                infoMessage.setType(Message.Type.chat);
                infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                DizMessage diz = new DizMessage(10, usertemp.getUID(), "deleteGroup");
                diz.setContent(finalContent);
                infoMessage.setBody(diz.toString());
                Log.info("deleteGroup infoMessage:{}", (Object)infoMessage.toString());
                GroupPlugin.groupPlugin.sendMessage(infoMessage);
                try {
                    Collection admins = grouptemp.getAdmins();
                    Collection members = grouptemp.getMembers();
                    ArrayList<JID> adminsList = new ArrayList<JID>();
                    for (JID jid : admins) {
                        adminsList.add(jid);
                    }
                    ArrayList<JID> membersList = new ArrayList<JID>();
                    for (JID jid : members) {
                        membersList.add(jid);
                    }
                    for (JID jid : adminsList) {
                        grouptemp.getAdmins().remove(jid);
                    }
                    for (JID jid : membersList) {
                        grouptemp.getMembers().remove(jid);
                    }
                }
                catch (Exception e) {
                    Log.error("delete Group.delete groupMembers error:{},groupId:{}", (Object)e.getMessage(), (Object)grouptemp.getName());
                }
            }
        });
    }
}

