/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.util.GroupNoticeUtil;
import com.weaver.util.ThreadPoolFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.tag.GroupTagUtil;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessDeleteGroupUsers
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessDeleteGroupUsers.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        JSONArray members = json.getJSONArray("members");
        String groupId = (String)json.get((Object)"groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "deleteGroupUsers", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
        }
        ArrayList<String> mems = new ArrayList<String>();
        for (Object obj : members.toArray()) {
            String username = (String)obj;
            mems.add(username.toLowerCase());
        }
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        this.deleteGroupUsers(fromJID.getNode(), groupId, mems, content);
        result.put("groupId", groupId);
        result.put("members", mems);
        return result;
    }

    private void deleteGroupUsers(String operater, String groupId, List<String> users, String content) {
        try {
            JID jid;
            Group group = this.groupManager.getGroup(groupId, true);
            User user = null;
            StringJoiner extension = new StringJoiner(",");
            ArrayList<String> userNamesList = new ArrayList<String>();
            String operaterName = "";
            PersistableMap groupProp = group.getProperties();
            String groupManagers = null;
            if (groupProp != null && groupProp.containsKey((Object)"groupManagers")) {
                groupManagers = (String)groupProp.get((Object)"groupManagers");
            }
            JSONArray jsonManagers = null;
            if (groupManagers != null) {
                jsonManagers = JSON.parseArray(groupManagers);
            }
            boolean needRemoveManager = false;
            ArrayList<JID> userlist = new ArrayList<JID>();
            for (String username : users) {
                try {
                    user = this.userManager.getUser(username);
                    userNamesList.add(UsernameUtil.getUserName(operater, user.getName()));
                    if (jsonManagers != null && jsonManagers.contains((Object)username)) {
                        jsonManagers.remove((Object)username);
                        Log.info("user:{},is group manager.not delete from group:{}", (Object)username, (Object)groupId);
                        needRemoveManager = true;
                    }
                    if (user == null) continue;
                    JID jid2 = new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                    Collection groupMembers = group.getMembers();
                    Collection groupAdmins = group.getAdmins();
                    if (groupMembers == null || !groupMembers.contains(jid2) && !groupAdmins.contains(jid2)) continue;
                    userlist.add(jid2);
                    extension.add(user.getUID());
                }
                catch (UserNotFoundException e) {
                    Log.error("deleteGroupUsers,user {} not found.", (Object)username);
                }
            }
            if (needRemoveManager) {
                groupProp.put((Object)"groupManagers", (Object)jsonManagers.toString());
            }
            try {
                user = this.userManager.getUser(operater);
                operaterName = UsernameUtil.getUserName(operater, user.getName());
            }
            catch (UserNotFoundException e) {
                Log.error("deteleGroupUsers,user {} not found.", (Object)operater);
            }
            if (userlist.size() <= 0 || "".equals(extension)) {
                Log.info("deleteGroupUsers.user not found.or user is not group member.groupName:{},users:{}", (Object)groupId, users);
                return;
            }
            if (content == null || content.isEmpty()) {
                StringBuilder contentSbld = new StringBuilder();
                contentSbld.append(operaterName);
                contentSbld.append(LocaleUtils.getLocalizedString((String)"group.iq.deletejiang", (String)"group"));
                if (userNamesList.size() > 4) {
                    contentSbld.append((String)userNamesList.get(0));
                    contentSbld.append(LocaleUtils.getLocalizedString((String)"group.iq.etc", (String)"group"));
                    contentSbld.append(userNamesList.size());
                    contentSbld.append(LocaleUtils.getLocalizedString((String)"group.iq.delete.people", (String)"group"));
                } else {
                    contentSbld.append(String.join((CharSequence)",", userNamesList));
                }
                contentSbld.append(LocaleUtils.getLocalizedString((String)"group.iq.delete.group", (String)"group"));
                content = contentSbld.toString();
            }
            GroupTagUtil gtu = new GroupTagUtil();
            gtu.delUserGroupTags(groupId, users);
            final User usertemp = user;
            final String extensiontemp = extension.toString();
            final Group grouptemp = group;
            final ArrayList<JID> userlisttemp = userlist;
            final String finalContent = content;
            Iterator iterator = userlisttemp.iterator();
            while (iterator.hasNext()) {
                jid = (JID)iterator.next();
                grouptemp.getMembers().remove(jid);
                grouptemp.getAdmins().remove(jid);
            }
            if (grouptemp.getAdmins().size() == 0 && grouptemp.getMembers().size() > 0 && (iterator = grouptemp.getMembers().iterator()).hasNext()) {
                jid = (JID)iterator.next();
                grouptemp.getMembers().remove(jid);
                grouptemp.getAdmins().add(jid);
            }
            ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    String show_userIds;
                    Message infoMessage = new Message();
                    infoMessage.setID(StringUtils.randomString((int)8));
                    infoMessage.setType(Message.Type.chat);
                    infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                    DizMessage diz = new DizMessage(4, usertemp.getUID(), extensiontemp);
                    diz.setContent(finalContent);
                    int groupKickOutNotice = JiveGlobals.getIntProperty((String)"groupKickOutNotice", (int)1);
                    if (GroupNoticeUtil.checkGroupJudgtActiveDay((String)grouptemp.getName())) {
                        if (0 == groupKickOutNotice) {
                            diz.setShow_userIds("-1");
                            diz.setNo_conv("1");
                            diz.setNo_db("1");
                        } else if (1 == groupKickOutNotice) {
                            show_userIds = GroupNoticeUtil.getAdminAndManagerIds((String)grouptemp.getName());
                            diz.setShow_userIds(show_userIds);
                            diz.setTo_users(show_userIds);
                        } else if (2 == groupKickOutNotice) {
                            diz.setShow_userIds("0");
                        }
                    } else {
                        diz.setNo_conv("1");
                        if (0 == groupKickOutNotice) {
                            diz.setShow_userIds("-1");
                            diz.setNo_db("1");
                        } else if (1 == groupKickOutNotice) {
                            show_userIds = GroupNoticeUtil.getAdminAndManagerIds((String)grouptemp.getName());
                            diz.setShow_userIds("-1");
                            diz.setTo_users(show_userIds);
                        } else if (2 == groupKickOutNotice) {
                            diz.setShow_userIds("-1");
                        }
                    }
                    infoMessage.setBody(diz.toString());
                    GroupPlugin.groupPlugin.sendMessage(infoMessage);
                    for (JID userJID : userlisttemp) {
                        Message newMessage = infoMessage.createCopy();
                        newMessage.setTo(userJID);
                        newMessage.setFrom(new JID("admin", "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), grouptemp.getName(), true));
                        GroupPlugin.groupPlugin.sendMessage(newMessage);
                    }
                }
            });
        }
        catch (GroupNotFoundException e) {
            Log.error("deleteGroupUsers,group {} not fount.", (Object)groupId);
        }
    }
}

