/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.util.GroupNoticeUtil;
import com.weaver.util.ThreadPoolFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.tag.GroupTagUtil;
import org.jivesoftware.openfire.plugin.util.GroupDatabaseUtil;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessExitGroup
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessExitGroup.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        String groupId = (String)json.get((Object)"groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "exitGroup", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        this.exitGroup(fromJID.getNode(), groupId, content);
        result.put("groupId", groupId);
        return result;
    }

    public void exitGroup(String operater, String groupName, String content) {
        try {
            Object jid;
            Group group = this.groupManager.getGroup(groupName, true);
            User user = null;
            PersistableMap groupProp = group.getProperties();
            String groupManagers = null;
            if (groupProp != null && groupProp.containsKey((Object)"groupManagers")) {
                groupManagers = (String)groupProp.get((Object)"groupManagers");
            }
            JSONArray jsonManagers = null;
            if (groupManagers != null) {
                jsonManagers = JSON.parseArray(groupManagers);
            }
            boolean needRemoveManager = false;
            String operaterName = null;
            try {
                user = this.userManager.getUser(operater);
                operaterName = UsernameUtil.getUserName(operater, user.getName());
            }
            catch (UserNotFoundException e) {
                Log.error("exitGroup,user {} not found.", (Object)operater);
                return;
            }
            if (jsonManagers != null && jsonManagers.contains((Object)operater)) {
                Log.info("exitGroup.user is manager:{},group:{}", (Object)operater, (Object)groupName);
                jsonManagers.remove((Object)operater);
                needRemoveManager = true;
            }
            if (user != null) {
                jid = new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                if (group.getMembers().contains(jid) || group.getAdmins().contains(jid)) {
                    group.getMembers().remove(new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    group.getAdmins().remove(new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                } else {
                    Log.warn("exitGroup.user is not group member or admin.user:{},groupName:{}", (Object)operater, (Object)groupName);
                    return;
                }
            }
            if (group.getAdmins().size() == 0 && group.getMembers().size() > 0 && (jid = group.getMembers().iterator()).hasNext()) {
                JID memJid = (JID)jid.next();
                group.getMembers().remove(memJid);
                group.getAdmins().add(memJid);
            }
            if (needRemoveManager) {
                groupProp.put((Object)"groupManagers", (Object)jsonManagers.toString());
            }
            GroupDatabaseUtil gdb = new GroupDatabaseUtil();
            ArrayList<String> users = new ArrayList<String>();
            users.add(operater);
            gdb.deleteConversationByExitGroup(groupName, users);
            GroupTagUtil gtu = new GroupTagUtil();
            gtu.delUserGroupTags(groupName, users);
            if (content == null || content.isEmpty()) {
                String exitGroup = LocaleUtils.getLocalizedString((String)"group.iq.exitGroup", (String)"group");
                content = operaterName + exitGroup;
            }
            final User usertemp = user;
            final Group grouptemp = group;
            final String finalContent = content;
            ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    String show_userIds;
                    String extension = usertemp.getUID();
                    Message infoMessage = new Message();
                    infoMessage.setID(StringUtils.randomString((int)8));
                    infoMessage.setType(Message.Type.chat);
                    infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                    DizMessage diz = new DizMessage(2, usertemp.getUID(), extension);
                    diz.setContent(finalContent);
                    Collection admins = grouptemp.getAdmins();
                    StringBuilder adminsArray = new StringBuilder("");
                    for (JID admin : admins) {
                        adminsArray.append(admin.getNode());
                        adminsArray.append(",");
                    }
                    int groupSignOutNotice = JiveGlobals.getIntProperty((String)"groupSignOutNotice", (int)1);
                    if (GroupNoticeUtil.checkGroupJudgtActiveDay((String)grouptemp.getName())) {
                        if (0 == groupSignOutNotice) {
                            diz.setShow_userIds("-1");
                            diz.setNo_conv("1");
                            diz.setNo_db("1");
                        } else if (1 == groupSignOutNotice) {
                            show_userIds = GroupNoticeUtil.getAdminAndManagerIds((String)grouptemp.getName());
                            diz.setShow_userIds(show_userIds);
                            diz.setTo_users(show_userIds);
                        } else if (2 == groupSignOutNotice) {
                            diz.setShow_userIds("0");
                        }
                    } else {
                        diz.setNo_conv("1");
                        if (0 == groupSignOutNotice) {
                            diz.setShow_userIds("-1");
                            diz.setNo_conv("1");
                            diz.setNo_db("1");
                        } else if (1 == groupSignOutNotice) {
                            show_userIds = GroupNoticeUtil.getAdminAndManagerIds((String)grouptemp.getName());
                            diz.setShow_userIds("-1");
                            diz.setTo_users(show_userIds);
                        } else if (2 == groupSignOutNotice) {
                            diz.setShow_userIds("-1");
                        }
                    }
                    if (adminsArray.length() > 1) {
                        diz.setAdmins(adminsArray.toString().substring(0, adminsArray.toString().length() - 1));
                    }
                    infoMessage.setBody(diz.toString());
                    GroupPlugin.groupPlugin.sendMessage(infoMessage);
                }
            });
        }
        catch (GroupNotFoundException e) {
            Log.error("exitGroup,group {} not found.", (Object)groupName);
        }
    }
}

