/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.ServerInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.UUID;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class ProcessGetSecretChat
implements IQStrategy {
    private static final String SECRET_GROUP_CHAT_REDIS_KEY = "secret:group:chat:";
    private static final int SECRET_GROUP_CHAT_REDIS_EXECPIRE = 1296000;
    private static final Logger Log = LoggerFactory.getLogger(ProcessGetSecretChat.class);

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        String username = fromJID.getNode();
        String userId = ProcessGetSecretChat.conNodeToID(username);
        String targetId = "";
        if (json != null && json.containsKey((Object)"targetId")) {
            targetId = json.getString("targetId");
        }
        String converId = this.genaralSessionID(userId, targetId);
        String groupId = this.getGroupByGroupId(converId);
        boolean needCreateGroup = false;
        if (groupId == null || groupId.isEmpty()) {
            needCreateGroup = true;
            groupId = UUID.randomUUID().toString().toLowerCase();
        }
        if (needCreateGroup) {
            String groupName = null;
            try {
                User user = UserManager.getInstance().getUser(fromJID.getNode());
                User userT = UserManager.getInstance().getUser((targetId + "|" + ServerInfo.SYSTEM_UDID).toLowerCase());
                groupName = UsernameUtil.getUserName(fromJID.getNode(), user.getName()) + "\u4e0e" + UsernameUtil.getUserName(fromJID.getNode(), userT.getName()) + "\u7684\u52a0\u5bc6\u4f1a\u8bdd";
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.createGroup(userId, targetId, converId, groupId, groupName);
        }
        result.put("groupId", groupId);
        result.put("targetId", targetId);
        return result;
    }

    private void createGroup(String userId, String targetId, String converId, String groupId, String groupName) {
        this.recordUserGroup2Db(userId, targetId, converId, groupId, groupName);
        try {
            Group group = GroupManager.getInstance().createGroup(groupId, groupName);
            group.getMembers().add(new JID(userId + "|" + ServerInfo.SYSTEM_UDID, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
            group.getMembers().add(new JID(targetId + "|" + ServerInfo.SYSTEM_UDID, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
            PersistableMap prop = group.getProperties();
            if (prop != null) {
                prop.put((Object)"secretGroupType", (Object)"1");
            }
        }
        catch (Exception e) {
            Log.error("ProcessGetSecretChat ,createGroup,userId:{},targetId:{},converId:{},groupId:{},groupName:{},userId,targetId,converId,groupId,groupName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordUserGroup2Db(String userId, String targetId, String converId, String groupId, String groupName) {
        String sql = " insert into ofSecretGroupChat (userId,targetId,converId,groupId,groupName,createTime) values (?,?,?,?,?,?)";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, userId);
            pstmt.setString(2, targetId);
            pstmt.setString(3, converId);
            pstmt.setString(4, groupId);
            pstmt.setString(5, groupName);
            pstmt.setString(6, String.valueOf(System.currentTimeMillis()));
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error("recordUserGroup2Db,userId:{},targetId:{},converId:{},groupId:{},groupName:{},error:{},e:{}", new Object[]{userId, targetId, converId, groupId, groupName, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroupByGroupId(String groupId) {
        RedisPoolMgr redisPoolMgr;
        String group;
        block8: {
            block9: {
                String value;
                group = null;
                redisPoolMgr = RedisPoolMgr.getInstance();
                if (redisPoolMgr != null && (value = redisPoolMgr.get(SECRET_GROUP_CHAT_REDIS_KEY + groupId)) != null && !value.isEmpty()) {
                    group = value;
                }
                if (group != null && !group.isEmpty()) break block9;
                Connection con = null;
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    con = DbConnectionManager.getConnection();
                    pstmt = con.prepareStatement(" select groupId from ofSecretGroupChat where converId = ? ");
                    pstmt.setString(1, groupId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        group = rs.getString("groupId");
                    }
                }
                catch (SQLException e) {
                    try {
                        Log.error("getGroupByGroupId,error,groupId :{},errorMsg :{} ,e :{} ", new Object[]{groupId, e.getMessage(), e});
                    }
                    catch (Throwable throwable) {
                        DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                        throw throwable;
                    }
                    DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                    break block8;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
                break block8;
            }
            return group;
        }
        if (group == null || group.isEmpty()) {
            return null;
        }
        if (redisPoolMgr != null) {
            redisPoolMgr.set(SECRET_GROUP_CHAT_REDIS_KEY + groupId, group, 1296000);
        }
        return group;
    }

    private String genaralSessionID(String str1, String str2) {
        if (str1.compareToIgnoreCase(str2) >= 0) {
            return str2 + "-" + str1;
        }
        return str1 + "-" + str2;
    }

    private static String conNodeToID(String username) {
        int i = username.indexOf("|");
        if (i > 0) {
            return username.substring(0, i);
        }
        if (i == 0) {
            return "-1";
        }
        return username;
    }
}

