/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSONObject;
import com.weaver.util.ThreadPoolFactory;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessMaxGroupMember
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessMaxGroupMember.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        String maxGroupMember = json.getString("maxGroupMember");
        String groupId = json.getString("groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "maxGroupMember", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        this.setMaxGroupMember(maxGroupMember, groupId, fromJID);
        result.put("groupId", groupId);
        result.put("maxGroupMember", maxGroupMember);
        return result;
    }

    private void setMaxGroupMember(String maxGroupMember, String groupName, JID fromJID) {
        Group group = null;
        User user = null;
        try {
            group = this.groupManager.getGroup(groupName);
            user = this.userManager.getUser(fromJID.getNode());
        }
        catch (GroupNotFoundException e) {
            Log.error("setMaxGroupMember,group is not found.groupName:{},maxGroupMember:{},fromJID:{}", new Object[]{groupName, maxGroupMember, fromJID});
            return;
        }
        catch (UserNotFoundException e) {
            Log.error("setMaxGroupMember,user is not found.groupName:{},maxGroupMember:{},fromJID:{},content:{}", new Object[]{groupName, maxGroupMember, fromJID});
            return;
        }
        PersistableMap groupPropMap = group.getProperties();
        groupPropMap.put((Object)"maxGroupMember", (Object)maxGroupMember);
        final Group grouptemp = group;
        final User usertemp = user;
        final String extensiontemp = maxGroupMember;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                Message infoMessage = new Message();
                infoMessage.setID(StringUtils.randomString((int)8));
                infoMessage.setType(Message.Type.chat);
                infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                DizMessage diz = new DizMessage(20, usertemp.getUID(), extensiontemp);
                diz.setNo_db("1");
                diz.setNo_conv("1");
                infoMessage.setBody(diz.toString());
                Log.info("setMaxGroupMember infoMessage:{}", (Object)infoMessage.toString());
                GroupPlugin.groupPlugin.sendMessage(infoMessage);
            }
        });
    }
}

