/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSONObject;
import com.weaver.util.ThreadPoolFactory;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessSeeHistoryMsg
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessSeeHistoryMsg.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        String groupId = json.getString("groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "seeHistoryMsg", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        String setValue = json.getString("value");
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        this.seeHistoryMsg(groupId, setValue, fromJID, content);
        result.put("groupId", groupId);
        result.put("value", setValue);
        return result;
    }

    private void seeHistoryMsg(String groupId, String setValue, JID fromJID, String content) {
        Group group = null;
        User user = null;
        String operaName = null;
        try {
            group = this.groupManager.getGroup(groupId);
            user = this.userManager.getUser(fromJID.getNode());
            operaName = user.getName();
        }
        catch (GroupNotFoundException e) {
            Log.error("seeHistoryMsg .error .group is not found .groupId:{},seeValue:{},fromJID:{}", new Object[]{groupId, setValue, fromJID});
            return;
        }
        catch (UserNotFoundException e) {
            Log.error("seeHistoryMsg .error .user is not found .groupId:{},seeValue:{},fromJID:{}", new Object[]{groupId, setValue, fromJID});
            return;
        }
        PersistableMap groupPropMap = group.getProperties();
        groupPropMap.put((Object)"seeHistoryMsg", (Object)setValue);
        if (content == null || content.isEmpty()) {
            String seeHistoryMsg = LocaleUtils.getLocalizedString((String)"group.iq.seeHistoryMsg", (String)"group");
            content = operaName + seeHistoryMsg;
        }
        final Group grouptemp = group;
        final User usertemp = user;
        final String extensiontemp = String.valueOf(setValue);
        final String finalContent = content;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                Message infoMessage = new Message();
                infoMessage.setID(StringUtils.randomString((int)8));
                infoMessage.setType(Message.Type.chat);
                infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                DizMessage diz = new DizMessage(11, usertemp.getUID(), extensiontemp);
                diz.setContent(finalContent);
                diz.setNo_conv("1");
                diz.setNo_db("1");
                infoMessage.setBody(diz.toString());
                Log.info("seeHistoryMsg infoMessage:{}", (Object)infoMessage.toString());
                GroupPlugin.groupPlugin.sendMessage(infoMessage);
            }
        });
    }
}

