/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSONObject;
import com.weaver.util.ThreadPoolFactory;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessSetDisableWords
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessSetDisableWords.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        String isDisableWords = json.getString("isDisableWords");
        String groupId = json.getString("groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "setDisableWords", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        String content = json.getString("content");
        this.setDisableWords(isDisableWords, groupId, fromJID, content);
        result.put("groupId", groupId);
        result.put("isDisableWords", isDisableWords);
        return result;
    }

    private void setDisableWords(String isDisableWords, String groupName, JID fromJID, String content) {
        Group group = null;
        User user = null;
        try {
            group = this.groupManager.getGroup(groupName);
            user = this.userManager.getUser(fromJID.getNode());
        }
        catch (GroupNotFoundException e) {
            Log.error("setDisableWords,group is not found.groupName:{},isDisableWords:{},fromJID:{},content:{}", new Object[]{groupName, isDisableWords, fromJID, content});
            return;
        }
        catch (UserNotFoundException e) {
            Log.error("setDisableWords,user is not found.groupName:{},isDisableWords:{},fromJID:{},content:{}", new Object[]{groupName, isDisableWords, fromJID, content});
            return;
        }
        PersistableMap groupPropMap = group.getProperties();
        groupPropMap.put((Object)"isDisableWords", (Object)isDisableWords);
        if (content == null || content.isEmpty()) {
            content = "true".equals(isDisableWords) ? UsernameUtil.getUserName(fromJID.getNode(), user.getName()) + LocaleUtils.getLocalizedString((String)"group.iq.Words", (String)"group") : UsernameUtil.getUserName(fromJID.getNode(), user.getName()) + LocaleUtils.getLocalizedString((String)"group.iq.disableWords", (String)"group");
        }
        final Group grouptemp = group;
        final User usertemp = user;
        final String extensiontemp = isDisableWords;
        final String finalContent = content;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                Message infoMessage = new Message();
                infoMessage.setID(StringUtils.randomString((int)8));
                infoMessage.setType(Message.Type.chat);
                infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                DizMessage diz = new DizMessage(13, usertemp.getUID(), extensiontemp);
                diz.setContent(finalContent);
                infoMessage.setBody(diz.toString());
                Log.info("setDisableWords infoMessage:{}", (Object)infoMessage.toString());
                GroupPlugin.groupPlugin.sendMessage(infoMessage);
            }
        });
    }
}

