/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSONObject;
import com.weaver.util.ThreadPoolFactory;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessSetGroupIcon
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessSetGroupIcon.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        int temp;
        String groupId = (String)json.get((Object)"groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "setGroupIcon", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        String url = (String)json.get((Object)"groupIconUrl");
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        if ((temp = this.setGroupIcon(fromJID, groupId, url, content)) == 0) {
            result.put("groupId", groupId);
            result.put("groupIconUrl", url);
        } else if (temp == 1) {
            result.put("error", "group not found");
        } else if (temp == 2) {
            result.put("error", "error in service");
        } else if (temp == 3) {
            result.put("error", "user is not admin");
        }
        return result;
    }

    private int setGroupIcon(JID operater, String groupId, String imageUrl, String content) {
        Group group = null;
        User user = null;
        String operaterName = "";
        try {
            group = this.groupManager.getGroup(groupId, true);
            user = this.userManager.getUser(operater.getNode());
            operaterName = UsernameUtil.getUserName(operater.getNode(), user.getName());
        }
        catch (UserNotFoundException e) {
            return 2;
        }
        catch (GroupNotFoundException e1) {
            return 1;
        }
        PersistableMap groupPropMap = group.getProperties();
        groupPropMap.put((Object)"groupIconUrl", (Object)imageUrl);
        groupPropMap.put((Object)"groupIconType", (Object)"2");
        if (content == null || content.isEmpty()) {
            String updategroupicon = LocaleUtils.getLocalizedString((String)"group.iq.updategroupicon", (String)"group");
            content = operaterName + updategroupicon;
        }
        final Group grouptemp = group;
        final User usertemp = user;
        final String extensiontemp = imageUrl;
        final String finalContent = content;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                Message infoMessage = new Message();
                infoMessage.setID(StringUtils.randomString((int)8));
                infoMessage.setType(Message.Type.chat);
                infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                DizMessage diz = new DizMessage(7, usertemp.getUID(), extensiontemp);
                diz.setContent(finalContent);
                infoMessage.setBody(diz.toString());
                GroupPlugin.groupPlugin.sendMessage(infoMessage);
            }
        });
        return 0;
    }
}

