/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.IQ.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weaver.util.ThreadPoolFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.IQ.strategy.IQStrategy;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.util.GroupPropUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessSetManager
implements IQStrategy {
    private static final Logger Log = LoggerFactory.getLogger(ProcessSetManager.class);
    private GroupManager groupManager = GroupManager.getInstance();
    private UserManager userManager = UserManager.getInstance();

    @Override
    public Map<String, Object> process(JID fromJID, JSONObject json, Map<String, Object> result) {
        int setResult;
        String groupId = json.getString("groupId");
        boolean propUpdate = GroupPropUtil.checkPropUpdate(fromJID.getNode(), groupId, "setGroupManager", "client");
        if (!propUpdate) {
            result.put("error", "not allowed to change.");
            return result;
        }
        JSONArray managers = json.getJSONArray("groupManagers");
        String content = null;
        if (json != null && json.containsKey((Object)"content")) {
            content = json.getString("content");
        }
        if ((setResult = this.setGroupManager(fromJID, groupId, managers, content)) == 0) {
            result.put("groupId", groupId);
            result.put("groupManagers", managers);
        } else {
            result.put("error", "set error");
        }
        return result;
    }

    private int setGroupManager(JID operater, String groupId, JSONArray managersArray, String content) {
        String managersName;
        String operaterName;
        User user;
        Group group;
        block23: {
            group = null;
            user = null;
            operaterName = "";
            managersName = "";
            try {
                group = this.groupManager.getGroup(groupId);
                user = this.userManager.getUser(operater.getNode());
                operaterName = UsernameUtil.getUserName(operater.getNode(), user.getName());
                Collection members = group.getMembers();
                ArrayList<String> member = new ArrayList<String>();
                for (JID jid : members) {
                    member.add(jid.getNode());
                }
                Collection admins = group.getAdmins();
                ArrayList<String> admin = new ArrayList<String>();
                for (JID jid : admins) {
                    admin.add(jid.getNode());
                }
                PersistableMap groupPropMap = group.getProperties();
                GroupManager.lockGroup((String)groupId);
                if (groupPropMap != null && groupPropMap.containsKey((Object)"groupManagers")) {
                    String groupManager = (String)groupPropMap.get((Object)"groupManagers");
                    if (groupManager != null) {
                        JSONArray groupManagerArray = JSON.parseArray((String)groupManager);
                        if (groupManagerArray == null) {
                            groupManagerArray = new JSONArray();
                        }
                        for (int i = 0; i < managersArray.size(); ++i) {
                            String manager;
                            block22: {
                                manager = managersArray.getString(i).toLowerCase();
                                try {
                                    this.userManager.getUser(manager);
                                    managersName = managersName + UsernameUtil.getUserName(operater.getNode(), this.userManager.getUser(manager).getName()) + ",";
                                    if (!member.contains(manager)) {
                                        Log.warn("manager is not group member .can not to set to manager.group:{},manager:{}", (Object)group, (Object)manager);
                                        continue;
                                    }
                                    if (admin.contains(manager)) {
                                        Log.warn("manager is group admins.can not to set to manager.group:{},manager:{}", (Object)group, (Object)manager);
                                    }
                                    break block22;
                                }
                                catch (Exception e) {
                                    Log.warn("manager is not a user.manager:{}", (Object)manager);
                                }
                                continue;
                            }
                            if (groupManagerArray != null && groupManagerArray.contains((Object)manager)) {
                                Log.warn("setGroupManager.userid :{} is manager already.", (Object)manager);
                                continue;
                            }
                            Log.info("setGroupManager .userid :{} success.", (Object)manager);
                            groupManagerArray.add((Object)manager);
                        }
                        groupPropMap.put((Object)"groupManagers", (Object)groupManagerArray.toString().toLowerCase());
                        break block23;
                    }
                    Log.info("group :{}  has not manager.now set group managers :{} .", (Object)groupId, (Object)managersArray);
                    groupPropMap.put((Object)"groupManagers", (Object)managersArray.toString());
                    break block23;
                }
                Log.info("groupPropMap is null . or groupPropMap not contains groupManagers .");
                for (int i = 0; i < managersArray.size(); ++i) {
                    String manager = managersArray.getString(i).toLowerCase();
                    try {
                        managersName = UsernameUtil.getUserName(operater.getNode(), this.userManager.getUser(manager).getName()) + ",";
                        continue;
                    }
                    catch (UserNotFoundException e) {
                        Log.info("setGroupManager.error user :{} not found .", (Object)manager);
                    }
                }
                if (groupPropMap == null) {
                    Log.error("get groupPropMap is null.can not set managers. groupId:{},managers:{}", (Object)groupId, (Object)managersArray);
                    return 1;
                }
                Log.info("group :{},managers:{},update success.", (Object)groupId, (Object)managersArray);
                groupPropMap.put((Object)"groupManagers", (Object)managersArray.toString().toLowerCase());
            }
            catch (GroupNotFoundException e) {
                Log.error("setGroupManager.group is not found.groupId:{},operater:{},managers:{}", new Object[]{groupId, operater, managersArray});
                return 2;
            }
            catch (UserNotFoundException e) {
                Log.error("setGroupManager.operater is not found.groupId:{},operater:{},managers:{}", new Object[]{groupId, operater, managersArray});
                return 3;
            }
        }
        GroupManager.unlockGroup((String)groupId);
        if (content == null || content.isEmpty()) {
            if (managersName.endsWith(",")) {
                managersName = managersName.substring(0, managersName.length() - 1);
            }
            if (managersArray.size() > 4) {
                String etc = LocaleUtils.getLocalizedString((String)"group.iq.etc", (String)"group");
                String people = LocaleUtils.getLocalizedString((String)"group.iq.delete.people", (String)"group");
                String delete = LocaleUtils.getLocalizedString((String)"group.iq.deletejiang", (String)"group");
                String setManager = LocaleUtils.getLocalizedString((String)"group.iq.setManager", (String)"group");
                content = operaterName + delete + managersName.substring(0, managersName.indexOf(",", managersName.indexOf(",") + 1)) + etc + managersArray.size() + people + setManager;
            } else {
                String delete = LocaleUtils.getLocalizedString((String)"group.iq.deletejiang", (String)"group");
                String setManager = LocaleUtils.getLocalizedString((String)"group.iq.setManager", (String)"group");
                content = operaterName + delete + managersName + setManager;
            }
        }
        final Group grouptemp = group;
        final User usertemp = user;
        final String extensiontemp = managersArray.toString();
        final String finalContent = content;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                Message infoMessage = new Message();
                infoMessage.setID(StringUtils.randomString((int)8));
                infoMessage.setType(Message.Type.chat);
                infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                DizMessage diz = new DizMessage(8, usertemp.getUID(), extensiontemp);
                diz.setContent(finalContent);
                infoMessage.setBody(diz.toString());
                Log.info("set group manager infoMessage:{}", (Object)infoMessage.toString());
                GroupPlugin.groupPlugin.sendMessage(infoMessage);
            }
        });
        return 0;
    }
}

