/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.plugin.bean.GroupMessage;
import org.jivesoftware.openfire.plugin.tag.GroupTagUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class GroupCommonLogic {
    private static final Logger Log = LoggerFactory.getLogger(GroupCommonLogic.class);

    public static Map<String, Object> searchGroupList(List<GroupMessage> groupsCollection, String queryGroupName, String groupType, Integer pageSize, Integer pageNumber, String userId, String groupAdmin, Long createTimeStart, Long createTimeEnd, String createUserItem, List<String> groupUsers, String tagValue) {
        Log.info("searchGroupList,groupsCollection:{},queryGroupName:{},groupType:{},pageSize:{},pageNumber:{},userId:{},groupAdmin:{},createTimeStart:{},createTimeEnd:{},createUserItem:{},groupUsers:{}", new Object[]{groupsCollection, queryGroupName, groupType, pageSize, pageNumber, userId, groupAdmin, createTimeStart, createTimeEnd, createUserItem, groupUsers});
        Iterator<GroupMessage> iterator = groupsCollection.iterator();
        List<GroupMessage> groups = new ArrayList<GroupMessage>();
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        String realUserId = GroupCommonLogic.getRealIdByNode(userId);
        HashMap<String, String> mapContainedMember = new HashMap<String, String>();
        while (iterator.hasNext()) {
            PersistableMap groupProperties;
            GroupMessage groupMessage = iterator.next();
            Group group = groupMessage.getGroup();
            if (StringUtils.isBlank((CharSequence)group.getDescription()) || (groupProperties = group.getProperties()) != null && groupProperties.containsKey((Object)"deleteGroup") && "true".equals(groupProperties.get((Object)"deleteGroup"))) continue;
            if (StringUtils.isNotBlank((CharSequence)queryGroupName) && !group.getDescription().toLowerCase().contains(queryGroupName.toLowerCase())) {
                Collection members = group.getAll();
                Boolean isContain = false;
                for (JID jid : members) {
                    String userName = jid.getNode();
                    try {
                        User user = UserManager.getInstance().getUser(userName);
                        if (null == user || !StringUtils.isNotBlank((CharSequence)user.getName()) || !user.getName().contains(queryGroupName)) continue;
                        isContain = true;
                        mapContainedMember.put(group.getName(), user.getName());
                        break;
                    }
                    catch (UserNotFoundException user) {
                    }
                }
                if (!isContain.booleanValue()) continue;
            }
            if (groupUsers != null && groupUsers.size() > 0) {
                Collection groupMembers = group.getAll();
                Log.info("groupMembers :{},groupName:{} ", (Object)groupMembers, (Object)group.getName());
                if (groupUsers.size() != groupMembers.size()) continue;
                Boolean isGroup = true;
                for (JID jid : groupMembers) {
                    String groupUserNode = jid.getNode();
                    Log.info("groupUsers:{},groupUserNode:{}", groupUsers, (Object)groupUserNode);
                    if (groupUsers.indexOf(groupUserNode) >= 0) continue;
                    isGroup = false;
                    break;
                }
                if (!isGroup.booleanValue()) continue;
            }
            if (groupAdmin != null) {
                Collection admins = group.getAdmins();
                boolean isAdmin = false;
                if (admins != null) {
                    for (JID jid : admins) {
                        if (!groupAdmin.equalsIgnoreCase(jid.getNode())) continue;
                        isAdmin = true;
                    }
                }
                if (!isAdmin) continue;
            }
            if (StringUtils.isNotBlank((CharSequence)groupType) || StringUtils.isNotBlank((CharSequence)createUserItem) || createTimeStart != null && createTimeStart > 0L || createTimeEnd != null && createTimeEnd > 0L) {
                GroupTagUtil gtu;
                Set<String> groupTagValues;
                String createUser = null;
                if (groupProperties != null && groupProperties.containsKey((Object)"createUser")) {
                    createUser = (String)groupProperties.get((Object)"createUser");
                }
                if (createUser == null && (createUserItem != null && !createUserItem.isEmpty() || groupType != null && !groupType.isEmpty()) || createUser != null && createUserItem != null && !createUserItem.isEmpty() && !createUserItem.equalsIgnoreCase(createUser) || groupType != null && !groupType.isEmpty() && createUser != null && (!"1".equals(groupType) ? "2".equals(groupType) && createUser.equalsIgnoreCase(userId) : !createUser.equalsIgnoreCase(userId))) continue;
                if (createTimeStart != null && createTimeStart > 0L || createTimeEnd != null && createTimeEnd > 0L) {
                    String createtime = null;
                    if (groupProperties != null && groupProperties.containsKey((Object)"createtime")) {
                        createtime = (String)groupProperties.get((Object)"createtime");
                    }
                    Long createTimeStemp = null;
                    try {
                        if (createtime == null) continue;
                        createTimeStemp = Long.valueOf(createtime);
                    }
                    catch (Exception e) {
                        Log.error("createTime error:{} ,createtime :{} ", (Object)e.getMessage(), (Object)createtime);
                    }
                    if (createTimeStemp != null && (createTimeStart != null && createTimeStart > 0L && createTimeStemp < createTimeStart || createTimeEnd != null && createTimeEnd > 0L && createTimeStemp > createTimeEnd)) continue;
                }
                if (tagValue != null && ((groupTagValues = (gtu = new GroupTagUtil()).getGroupUserTag(group.getName(), userId)) == null || groupTagValues.isEmpty() || !groupTagValues.contains(tagValue))) continue;
            }
            groups.add(groupMessage);
        }
        mapResult.put("totalCount", groups.size());
        if (pageSize != null && pageNumber != null) {
            Integer startIndex = pageSize * (pageNumber - 1);
            Integer endIndex = pageSize * pageNumber;
            if (startIndex > groups.size() - 1) {
                groups.clear();
            } else {
                groups = endIndex > groups.size() ? groups.subList(startIndex, groups.size()) : groups.subList(startIndex, endIndex);
            }
        }
        ArrayList list = new ArrayList();
        for (GroupMessage group : groups) {
            HashMap<String, String> map = new HashMap<String, String>();
            Group g = group.getGroup();
            String groupName = g.getDescription();
            String groupId = g.getName();
            int groupMemberSize = g.getAll().size();
            map.put("groupName", groupName);
            map.put("groupId", groupId);
            map.put("groupMemberSize", String.valueOf(groupMemberSize));
            map.put("msgContent", group.getMsgContent());
            map.put("lasttime", group.getLasttime());
            if (mapContainedMember.containsKey(groupId)) {
                map.put("groupContainMember", (String)mapContainedMember.get(groupId));
            } else {
                map.put("groupContainMember", "");
            }
            PersistableMap groupProp = g.getProperties();
            String groupIconUrl = "";
            if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
            }
            map.put("groupIconUrl", groupIconUrl);
            list.add(map);
        }
        mapResult.put("groupList", list);
        return mapResult;
    }

    private static String getRealIdByNode(String username) {
        if (username.startsWith("push|")) {
            return "-1";
        }
        int i = username.indexOf("|");
        if (i > 0) {
            return username.substring(0, i);
        }
        if (i == 0) {
            return "-1";
        }
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean searchMsgInGroup(String groupId, String userId, String groupMsg) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean msgImGroup = false;
        try {
            con = DbConnectionManager.getConnection();
            String sql = "select a.msgid from historyMsg a LEFT JOIN Social_historyMsgRight b on a.msgid = b.msgid where a.groupId = ? and b.userid = ? and className in ('RC:TxtMsg','FW:attachmentMsg','FW:CustomShareMsg') ";
            sql = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) ? sql + " AND upper(dbms_lob.substr(a.msgContent)) LIKE upper('%" + groupMsg + "%')" : (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType() == DbConnectionManager.DatabaseType.ob || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) ? sql + " AND upper(msgContent) LIKE upper('%" + groupMsg + "%')" : sql + " AND msgContent LIKE '%" + groupMsg + "%'");
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, groupId);
            pstmt.setString(2, userId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                msgImGroup = true;
            }
        }
        catch (SQLException e) {
            try {
                Log.error("searchMsgInGroup,groupId:{},userId:{},groupMsg:{},error:{}", new Object[]{groupId, userId, groupMsg, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return msgImGroup;
    }
}

