/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.searchMsg;

import com.alibaba.fastjson.JSON;
import com.weaver.util.WeiSouPropertiesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.searchMsg.SearchGroupMsgDbUtil;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weaver.fullsearch.interfaces.service.MegSearch;

public class SearchGroupMsgUtil {
    private static final Logger logger = LoggerFactory.getLogger(SearchGroupMsgUtil.class);

    public static Map<String, Object> searchGroupMsg(Integer pageSize, Integer pageNumber, String keyword, String userNode) {
        Map<String, Object> result = new HashMap<String, Object>();
        String userId = SearchGroupMsgUtil.getRealIdByNode(userNode);
        WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
        boolean weiSouEnable = w.isWeiSouEnable();
        boolean msgSearchValidate = false;
        if (weiSouEnable) {
            msgSearchValidate = MegSearch.searchValidate((String)"MSGSEARCH");
        }
        if (weiSouEnable && msgSearchValidate) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("schemaType", "MSGSEARCH");
            if (StringUtils.isNotBlank((CharSequence)keyword)) {
                paramMap.put("keyword", keyword);
            }
            paramMap.put("pageNumber", pageNumber);
            paramMap.put("pageSize", pageSize);
            paramMap.put("targetType", "2");
            paramMap.put("userid", userId);
            String msgType = "RC:TxtMsg,FW:attachmentMsg,FW:CustomShareMsg";
            paramMap.put("Classname", msgType);
            paramMap.put("searchType", "group");
            HashMap<String, String> sortMap = new HashMap<String, String>();
            sortMap.put("ID", "false");
            HashMap<String, Integer> aggMap = new HashMap<String, Integer>();
            aggMap.put("groupId", 1);
            MegSearch.searchValidate((String)"MSGSEARCH");
            Map weiSouMap = MegSearch.search(paramMap, sortMap, aggMap);
            result = SearchGroupMsgUtil.convertWeiSouToClient(weiSouMap, pageNumber, pageSize, userId);
        } else {
            if (weiSouEnable && !msgSearchValidate) {
                logger.info("==============GroupMsgSearch\u5fae\u641c\u5df2\u5f00\u542f\uff0c\u5fae\u641c\u7d22\u5f15\u4e0d\u53ef\u7528\u3002===================");
            }
            if (JiveGlobals.getBooleanProperty((String)"searchChatMsg", (boolean)true)) {
                SearchGroupMsgDbUtil searchGroupMsgDbUtil = new SearchGroupMsgDbUtil();
                result = searchGroupMsgDbUtil.searchChatId(pageNumber, pageSize, keyword, userId);
            } else {
                result = new HashMap();
            }
        }
        return result;
    }

    private static Map<String, Object> convertWeiSouToClient(Map<String, Object> weiSouMap, Integer pageNumber, Integer pageSize, String userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList groups = new ArrayList();
        List listResult = (List)weiSouMap.get("result");
        if (null != listResult) {
            GroupManager groupManager = GroupManager.getInstance();
            for (int i = 0; i < listResult.size(); ++i) {
                Map mapWei = (Map)listResult.get(i);
                String targetId = mapWei.get("targetid") == null ? "" : mapWei.get("targetid").toString();
                String targetType = mapWei.get("targetType") == null ? "" : mapWei.get("targetType").toString();
                String msgCount = mapWei.get("msgCount") == null ? "" : mapWei.get("msgCount").toString();
                String groupName = "";
                String groupIconUrl = "";
                String groupType = "0";
                Group group = null;
                HashMap<String, String> groupInfo = new HashMap<String, String>();
                if (!targetType.equals("2")) continue;
                try {
                    group = groupManager.getGroup(targetId);
                    if (group == null) continue;
                    groupName = group.getDescription();
                    PersistableMap groupProp = group.getProperties();
                    if (groupProp != null && groupProp.containsKey((Object)"groupIconUrl")) {
                        groupIconUrl = (String)groupProp.get((Object)"groupIconUrl");
                    }
                    if (groupProp != null && groupProp.containsKey((Object)"groupType")) {
                        groupType = (String)groupProp.get((Object)"groupType");
                    }
                    String secretGroupType = "0";
                    if (groupProp != null && groupProp.containsKey((Object)"secretGroupType")) {
                        secretGroupType = (String)groupProp.get((Object)"secretGroupType");
                    }
                    if ("1".equals(secretGroupType)) continue;
                    groupInfo.put("groupId", targetId);
                    groupInfo.put("groupName", groupName);
                    groupInfo.put("groupIconUrl", groupIconUrl);
                    groupInfo.put("msgCount", msgCount);
                    groupInfo.put("groupType", groupType);
                    groupInfo.put("secretGroupType", secretGroupType);
                    groups.add(groupInfo);
                    continue;
                }
                catch (Exception e) {
                    logger.error("convertWeiSouToClient .group not found.mapWei:{}", (Object)JSON.toJSONString((Object)mapWei).toString());
                }
            }
        }
        result.put("pageNumber", pageNumber);
        result.put("pageSize", pageSize);
        result.put("totalCount", weiSouMap.get("count"));
        result.put("allGroups", groups);
        return result;
    }

    private static String getRealIdByNode(String username) {
        if (username.startsWith("push|")) {
            return "-1";
        }
        int i = username.indexOf("|");
        if (i > 0) {
            return username.substring(0, i);
        }
        if (i == 0) {
            return "-1";
        }
        return username;
    }
}

