/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.tag;

import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.pinyin.ChineseToPinyinUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.tag.GroupTagBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupTagUtil {
    private static final Logger Log = LoggerFactory.getLogger(GroupTagUtil.class);
    private static final String GROUP_USER_TAG_KEY = "group:user:tag:";
    private static final int GROUP_USER_TAG_KEY_EXPIRE = 2592000;
    private static final String GROUP_TAG_KEY = "group:tag:";
    private static final String ADD_GROUP_USER_TAG = " insert into ofgrouptag (groupName,username,tagValue,updateTime,searchTagValue) values(?,?,?,?,?) ";
    private static final String DEL_GROUP_USER_TAG = " delete from ofgrouptag where groupName = ? and username = ? and tagValue = ? ";
    private static final String DEL_GROUP_TAG = " delete from ofgrouptag where username = ? and tarValue = ? ";
    private static final String GET_GROUP_USER_TAG = " select groupName,username,tagValue from ofgrouptag where username = ? and tagValue = ? order by updateTime desc";
    private static final String GET_USER_GROUP_TAG = " select groupName,username,tagValue from ofgrouptag where groupName = ? and username = ? order by updateTime desc";
    private static final String GET_USER_TAG = "select distinct tagValue from ofgrouptag where username = ?  ";
    private static final String DEL_USER_GROUP_TAGS = " delete from ofgrouptag where groupName = ? and username = ? ";
    private static final String DEL_GROUP_TAGS = " delete from ofgrouptag where groupName = ? ";
    private static final String DEL_GROUP_ALLTAGS = "delete from ofgrouptag where groupName = ? and username = ? ";
    private static final String DELETE_ALLTAGS = "delete from ofgrouptag where username = ? ";
    private static final String GET_USER_TAG_ALLGROUPS = "select distinct groupName from ofgrouptag where username = ? ";
    private static final String SEARCHGROUPTAG = " select a.groupName as groupId,b.description as groupName,a.tagValue as tagValue  from ofgroupTag a left join ofgroup b on a.groupName = b.groupName left join ofgroupuser c on a.groupName = c.groupName  where (b.deleteGroup is null or b.deleteGroup = 'false') and (c.username = ? and (c.isdel is null or c.isdel = '0') )and a.username = ? and a.tagValue like ? ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> searchGroupTag(String username, String groupTag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> tagValues = new ArrayList<String>();
        ArrayList tagGroupList = new ArrayList();
        ArrayList<Object> listB = new ArrayList<Object>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(SEARCHGROUPTAG);
            pstmt.setString(1, username);
            pstmt.setString(2, username);
            pstmt.setString(3, "%" + groupTag + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String tagValue = rs.getString("tagValue");
                String groupId = rs.getString("groupId");
                String groupName = rs.getString("groupName");
                GroupTagBean gtb = new GroupTagBean();
                gtb.setGroupId(groupId);
                gtb.setGroupName(groupName);
                gtb.setTagValue(tagValue);
                if (tagValue != null && !tagValues.contains(tagValue)) {
                    tagValues.add(tagValue);
                }
                listB.add(gtb);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (Exception e) {
            Log.error("searchGroupTag error.username:{},groupTag:{},error:{}", new Object[]{username, groupTag, e.getMessage()});
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        if (tagValues != null && tagValues.size() > 0) {
            for (String tagValue : tagValues) {
                ArrayList gList = new ArrayList();
                for (GroupTagBean groupTagBean : listB) {
                    String tagV = groupTagBean.getTagValue();
                    if (!tagValue.equals(tagV)) continue;
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("groupId", groupTagBean.getGroupId());
                    m.put("groupName", groupTagBean.getGroupName());
                    gList.add(m);
                }
                HashMap mL = new HashMap();
                mL.put(tagValue, gList);
                tagGroupList.add(mL);
            }
        }
        map.put("tagValues", tagValues);
        map.put("tagGroupList", tagGroupList);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupTags(String groupName, String username, String[] tagValues) {
        Log.info("setGroupTags,groupName:{},username:{},tagValues:{}", new Object[]{groupName, username, tagValues});
        Connection con = null;
        PreparedStatement pstmt = null;
        long timeStr = System.currentTimeMillis();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DEL_USER_GROUP_TAGS);
            pstmt.setString(1, groupName);
            pstmt.setString(2, username);
            pstmt.execute();
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(ADD_GROUP_USER_TAG);
            for (String tagValue : tagValues) {
                pstmt.setString(1, groupName);
                pstmt.setString(2, username);
                pstmt.setString(3, tagValue);
                pstmt.setString(4, String.valueOf(timeStr));
                pstmt.setString(5, this.getSearchName(tagValue));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
        }
        catch (Exception e) {
            try {
                Log.error("setGroupTags,groupName:{},username:{},tagValues:{},error:{}", new Object[]{groupName, username, tagValues, e.getMessage()});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            redisPoolMgr.del(GROUP_USER_TAG_KEY + groupName + username);
            redisPoolMgr.del(GROUP_TAG_KEY + username);
            for (String tagValue : tagValues) {
                redisPoolMgr.zadd(GROUP_USER_TAG_KEY + groupName + username, timeStr, tagValue, 2592000);
            }
        }
    }

    private String getSearchName(String tagValue) {
        try {
            String str = ChineseToPinyinUtil.toPinyinAndFirst((String)tagValue);
            return tagValue + "^" + str;
        }
        catch (Exception exception) {
            return tagValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delAllTags(String username) {
        RedisPoolMgr redisPoolMgr;
        Log.info("delAllTags,username :{} ", (Object)username);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> groupIds = new ArrayList<String>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_USER_TAG_ALLGROUPS);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupIds.add(rs.getString("groupName"));
            }
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(DELETE_ALLTAGS);
            pstmt.setString(1, username);
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                Log.error("delAllTags,error:{},username :{} ", (Object)e.getMessage(), (Object)username);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        if (groupIds != null && groupIds.size() > 0 && (redisPoolMgr = RedisPoolMgr.getInstance()) != null) {
            for (String groupName : groupIds) {
                redisPoolMgr.del(GROUP_USER_TAG_KEY + groupName + username);
            }
            redisPoolMgr.del(GROUP_TAG_KEY + username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delGroupAllTags(String groupName, String username) {
        Log.info("delGroupAllTags,groupName:{},username:{}", (Object)groupName, (Object)username);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DEL_GROUP_ALLTAGS);
            pstmt.setString(1, groupName);
            pstmt.setString(2, username);
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                Log.error("delGroupAllTags,error:{},groupName:{},username:{}", new Object[]{e.getMessage(), groupName, username});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            redisPoolMgr.del(GROUP_USER_TAG_KEY + groupName + username);
            redisPoolMgr.del(GROUP_TAG_KEY + username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delGroupTags(String groupName, List<String> userList) {
        Log.info("delGroupTags,groupName:{},userList:{}", (Object)groupName, userList);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DEL_GROUP_TAGS);
            pstmt.setString(1, groupName);
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                Log.error("delGroupTags,error:{},groupName:{},userList:{}", new Object[]{e.getMessage(), groupName, userList});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            for (String username : userList) {
                redisPoolMgr.del(GROUP_USER_TAG_KEY + groupName + username);
                redisPoolMgr.del(GROUP_TAG_KEY + username);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delUserGroupTags(String groupName, List<String> userList) {
        Log.info("delUserGroupTags,groupName:{},userList:{}", (Object)groupName, userList);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DEL_USER_GROUP_TAGS);
            for (String username : userList) {
                pstmt.setString(1, groupName);
                pstmt.setString(2, username);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
        }
        catch (Exception e) {
            try {
                Log.error("delUserGroupTags,error:{},groupName:{},userList:{}", new Object[]{e.getMessage(), groupName, userList});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            for (String username : userList) {
                redisPoolMgr.del(GROUP_USER_TAG_KEY + groupName + username);
                redisPoolMgr.del(GROUP_TAG_KEY + username);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getGroupUserTag(String groupName, String username) {
        Set userGroupTag = null;
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            userGroupTag = redisPoolMgr.zrange(GROUP_USER_TAG_KEY + groupName + username, 0L, -1L);
        }
        if (userGroupTag != null && userGroupTag.size() > 0) {
            if (userGroupTag.contains(GROUP_USER_TAG_KEY + groupName + username)) {
                userGroupTag.remove(GROUP_USER_TAG_KEY + groupName + username);
            }
            return userGroupTag;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_USER_GROUP_TAG);
            pstmt.setString(1, groupName);
            pstmt.setString(2, username);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                userGroupTag.add(rs.getString("tagValue"));
            }
        }
        catch (Exception e) {
            try {
                Log.error("getGroupUserTag,error:{},groupName:{},username:{}", new Object[]{e.getMessage(), groupName, username});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        long timeStr = System.currentTimeMillis();
        if (redisPoolMgr != null) {
            if (userGroupTag != null && userGroupTag.size() > 0) {
                for (String tagValue : userGroupTag) {
                    redisPoolMgr.zadd(GROUP_USER_TAG_KEY + groupName + username, timeStr, tagValue, 2592000);
                }
            } else {
                redisPoolMgr.zadd(GROUP_USER_TAG_KEY + groupName + username, timeStr, GROUP_USER_TAG_KEY + groupName + username, 2592000);
            }
        }
        return userGroupTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUserTag(String username) {
        HashSet<String> userTag = new HashSet();
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            userTag = redisPoolMgr.zrange(GROUP_TAG_KEY + username, 0L, -1L);
        }
        if (userTag != null && userTag.size() > 0) {
            if (userTag.contains(GROUP_TAG_KEY + username)) {
                userTag.remove(GROUP_TAG_KEY + username);
            }
            return userTag;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_USER_TAG);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                userTag.add(rs.getString("tagValue"));
            }
        }
        catch (Exception e) {
            try {
                Log.error("getUserTag,error :{} ,username :{}", (Object)e.getMessage(), (Object)username);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        long timeStr = System.currentTimeMillis();
        if (userTag != null && userTag.size() > 0) {
            if (redisPoolMgr != null) {
                for (String member : userTag) {
                    redisPoolMgr.zadd(GROUP_TAG_KEY + username, timeStr, member, 2592000);
                }
            }
        } else if (redisPoolMgr != null) {
            redisPoolMgr.zadd(GROUP_TAG_KEY + username, timeStr, GROUP_TAG_KEY + username, 2592000);
        }
        return userTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delGroupTag(String username, String tagValue) {
        Log.info("delGroupTag,username:{},tagVale:{}", (Object)username, (Object)tagValue);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        HashSet<String> needDelRedisGroups = new HashSet<String>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_GROUP_USER_TAG);
            pstmt.setString(1, username);
            pstmt.setString(2, tagValue);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                needDelRedisGroups.add(rs.getString("groupName"));
            }
            DbConnectionManager.closeStatement((Statement)pstmt);
            pstmt = con.prepareStatement(DEL_GROUP_TAG);
            pstmt.setString(1, username);
            pstmt.setString(2, tagValue);
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                Log.error("delGroupTag.error:{},username:{},tagValue:{}", new Object[]{e.getMessage(), username, tagValue});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        if (needDelRedisGroups != null && needDelRedisGroups.size() > 0) {
            HashSet<String> membersSet = new HashSet<String>();
            membersSet.add(tagValue);
            RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
            if (redisPoolMgr != null) {
                for (String groupName : needDelRedisGroups) {
                    redisPoolMgr.batchZrem(GROUP_USER_TAG_KEY + groupName + username, membersSet);
                }
                redisPoolMgr.del(GROUP_TAG_KEY + username);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delGroupUserTag(String groupName, String username, String tagValue) {
        Log.info("delGroupUserTag,groupName :{},username :{} ,tagValue:{}", new Object[]{groupName, username, tagValue});
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DEL_GROUP_USER_TAG);
            pstmt.setString(1, groupName);
            pstmt.setString(2, username);
            pstmt.setString(3, tagValue);
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                Log.error("delGroupUserTag,error:{},groupName :{},username :{} ,tagValue:{}", new Object[]{e.getMessage(), groupName, username, tagValue});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            HashSet<String> membersSet = new HashSet<String>();
            membersSet.add(tagValue);
            redisPoolMgr.batchZrem(GROUP_USER_TAG_KEY + groupName + username, membersSet);
            redisPoolMgr.del(GROUP_TAG_KEY + username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupUserTag(String groupName, String username, String tagValue) {
        Log.info("addGroupUserTag,,groupName:{},username:{},tagValue:{}", new Object[]{groupName, username, tagValue});
        Connection con = null;
        PreparedStatement pstmt = null;
        long timeStr = System.currentTimeMillis();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(ADD_GROUP_USER_TAG);
            pstmt.setString(1, groupName);
            pstmt.setString(2, username);
            pstmt.setString(3, tagValue);
            pstmt.setString(4, String.valueOf(timeStr));
            pstmt.setString(5, this.getSearchName(tagValue));
            pstmt.execute();
        }
        catch (Exception e) {
            try {
                Log.error("addGroupUserTag,error:{},groupName:{},username:{},tagValue:{}", new Object[]{e.getMessage(), groupName, username, tagValue});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            redisPoolMgr.zadd(GROUP_USER_TAG_KEY + groupName + username, timeStr, tagValue, 2592000);
            redisPoolMgr.zadd(GROUP_TAG_KEY + username, timeStr, tagValue, 2592000);
        }
    }
}

